/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.booking.initiatePayment.b2b;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.server.ibecorp.common.components.PriceComponentsParameters;
import com.gridnine.xtrip.server.ibecorp.common.rest.CommonConverterHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.Money;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.booking.InitiatePaymentResult;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.booking.RepriceBookingResult;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import com.gridnine.xtrip.server.pg.ibus.common.PgPriceChangedException;
import java.math.BigDecimal;

public class PriceChangedExceptionHandler
extends BaseProcessor {
    public void process(MessageContext ctx) {
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        PgPriceChangedException exception = (PgPriceChangedException)ctx.getMandatoryObject((Enum)IBusStandardContextKeys.ADVICE_EXCEPTION);
        Reservation reservation = exception.getReservation();
        BigDecimal oldPrice = exception.getOldPrice();
        BigDecimal newPrice = exception.getNewPrice();
        InitiatePaymentResult result = new InitiatePaymentResult();
        RepriceBookingResult repriceResult = new RepriceBookingResult();
        repriceResult.setPriceChanged(true);
        String currency = PriceComponentsParameters.getBriefInfoParameters(salesContext).getCurrency();
        Money oldMoney = CommonConverterHelper.convertMoney2Rest(oldPrice, currency);
        Money newMoney = CommonConverterHelper.convertMoney2Rest(newPrice, currency);
        repriceResult.setOldPrice(oldMoney);
        repriceResult.setNewPrice(newMoney);
        result.getPriceChangeInfo().put(reservation.getUid(), repriceResult);
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)result);
        ctx.putObject((Enum)IBusIbecorpContextKeys.PRICE_CHANGED, (Object)true);
    }
}

