/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.booking.initiatePayment.b2c;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSite;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMStep4Settings;
import com.gridnine.xtrip.common.model.ibecorp.sm.SalesOfficeDetails;
import com.gridnine.xtrip.common.model.profile.Address;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.pg.model.PaymentInitiationParameters;
import com.gridnine.xtrip.common.pg.model.PgName;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.booking.initiatePayment.b2c.B2CInitiatePaymentHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.booking.B2BInitiatePaymentParameters;
import com.gridnine.xtrip.server.ibecorp.common.CommonHelper;
import com.gridnine.xtrip.server.ibecorp.common.components.PriceComponentsParameters;
import com.gridnine.xtrip.server.ibecorp.common.rest.CommonConverterHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.SiteConverterHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.booking.BookingConverterHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.booking.BookingPaymentHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.booking.initiatePayment.BaseInitiatePaymentResultConverter;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.booking.InitiatePaymentInfo;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.booking.InitiatePaymentResult;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.math.BigDecimal;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public class B2CInitiatePaymentResultConverter
extends BaseInitiatePaymentResultConverter {
    @Override
    protected void convertCashOrInvoiceParameters(MessageContext ctx, InitiatePaymentResult result, PaymentType paymentType) throws Exception {
        B2BInitiatePaymentParameters parameters = (B2BInitiatePaymentParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        EntityReference site = (EntityReference)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.SITE);
        EntityContainer bookingFile = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE);
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        PaymentInitiationParameters paymentInitiationParameters = BookingPaymentHelper.createPaymentInitiationParameters(BookingPaymentHelper.getComebackURL(ctx), (EntityContainer<BookingFile>)bookingFile, salesContext, ContractType.CLIENT);
        Map<PaymentType, MiscUtil.Pair<PgName, BigDecimal>> paymentTypesMap = BookingPaymentHelper.getPaymentTypesMap(paymentInitiationParameters, (EntityContainer<BookingFile>)bookingFile, ContractType.CLIENT);
        String currency = PriceComponentsParameters.getBriefInfoParameters(salesContext).getCurrency();
        if (paymentType == PaymentType.INVOICE) {
            InitiatePaymentInfo info = new InitiatePaymentInfo();
            Reservation firstReservation = B2CInitiatePaymentHelper.getFirstReservation((EntityContainer<BookingFile>)bookingFile);
            info.setPnr(CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)firstReservation));
            info.setTotal(CommonConverterHelper.convertMoney2Rest((BigDecimal)paymentTypesMap.get(PaymentType.INVOICE).getSecond(), currency));
            info.setText(L10nResourcesManager.getStr((String)"SITE_INVOICE_NOTIFICATION_MESSAGE", (Locale)LocaleHelper.getCurrentLocale(), (Object[])new Object[0]));
            result.setInitiatePaymentInfo(info);
            return;
        }
        SMStep4Settings step4Settings = Objects.requireNonNull(CommonHelper.getStep4Settings((EntityReference<SMSite>)site));
        if (paymentType == PaymentType.CASH) {
            SalesOfficeDetails salesOfficeDetails = step4Settings.getCashSalesOfficesDetails().stream().filter(sod -> sod.getUid().equals(parameters.getSalesOfficeUid())).findFirst().orElseThrow(() -> Xeption.forDeveloper((String)"invalid SalesOfficeUid value", (Object[])new Object[0]));
            InitiatePaymentInfo paymentInfo = BookingConverterHelper.convertBookingToInitiatePaymntInfo((EntityContainer<BookingFile>)bookingFile, CommonConverterHelper.convertMoney2Rest((BigDecimal)paymentTypesMap.get(PaymentType.CASH).getSecond(), currency), SiteConverterHelper.getLocalizedText(step4Settings.getCashSummaryBlock()), salesContext);
            paymentInfo.setText(paymentInfo.getText().replace("${address}", ProfileHelper.buildFullAddress((Address)salesOfficeDetails.getAddress(), (Locale)LocaleHelper.getCurrentLocale(), (boolean)false)));
            result.setInitiatePaymentInfo(paymentInfo);
        }
        if (paymentType == PaymentType.CASH_DELIVERY) {
            result.setInitiatePaymentInfo(BookingConverterHelper.convertBookingToInitiatePaymntInfo((EntityContainer<BookingFile>)bookingFile, CommonConverterHelper.convertMoney2Rest((BigDecimal)paymentTypesMap.get(PaymentType.CASH_DELIVERY).getSecond(), currency), SiteConverterHelper.getLocalizedText(step4Settings.getCashDeliverySummaryBlock()), salesContext));
        }
    }
}

