/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.booking.initiatePayment.b2c;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.dict.CommunicationType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSite;
import com.gridnine.xtrip.common.model.mail.MailPart;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.pg.IBusPgContextKeys;
import com.gridnine.xtrip.common.util.PersonalName;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.booking.initiatePayment.b2c.B2CInitiatePaymentHelper;
import com.gridnine.xtrip.server.ibecorp.common.CommonHelper;
import com.gridnine.xtrip.server.ibecorp.l10n.Messages;
import com.gridnine.xtrip.server.ibecorp.notifications.NotificationHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.ArrayList;

public class SendPaymentNotificationProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) {
        PaymentType paymentType = (PaymentType)ctx.getMandatoryObject((Enum)IBusPgContextKeys.PAYMENT_TYPE);
        SalesContext sc = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        EntityContainer bookingCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE);
        ArrayList emailsTo = new ArrayList();
        ((Organization)EntityStorage.get().resolve(sc.getSubagency()).getEntity()).getCommunications().stream().filter(c -> c.getType() == CommunicationType.EMAIL).forEach(c -> emailsTo.add(c.getSense()));
        String recordLocator = CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)B2CInitiatePaymentHelper.getFirstReservation((EntityContainer<BookingFile>)bookingCtr));
        String subject = CommonHelper.getLocalizedString(Messages.PAYMENT_HELPER_INFORMATION_ABOUT_BOOKING, new Object[0]) + " " + recordLocator;
        StringBuilder text = new StringBuilder();
        text.append(CommonHelper.getLocalizedString(Messages.PAYMENT_HELPER_BOOKING_NUMBER, new Object[0])).append(" ").append(recordLocator).append("\n").append(CommonHelper.getLocalizedString(Messages.PAYMENT_HELPER_CONTACT, new Object[0])).append(" ").append(TextUtil.buildFullName((PersonalName)((BookingFile)bookingCtr.getEntity()).getCustomer().getPassport())).append("\n");
        String phone = "";
        String email = "";
        for (Communication comm : ((BookingFile)bookingCtr.getEntity()).getCustomer().getCommunications()) {
            if (comm.getType() == CommunicationType.EMAIL) {
                email = comm.getSense();
                continue;
            }
            if (comm.getType() != CommunicationType.CELL && comm.getType() != CommunicationType.MOBILE && comm.getType() != CommunicationType.HOME_PHONE) continue;
            phone = "+" + comm.getCountryCode() + comm.getCityCode() + comm.getSense();
        }
        if (!phone.isEmpty()) {
            text.append(CommonHelper.getLocalizedString(Messages.PAYMENT_HELPER_MOBILE_PHONE, new Object[0])).append(" ").append(phone).append("\n");
        }
        if (!email.isEmpty()) {
            text.append(CommonHelper.getLocalizedString(Messages.PAYMENT_HELPER_EMAIL, new Object[0])).append(" ").append(email).append("\n");
        }
        text.append(CommonHelper.getLocalizedString(Messages.PAYMENT_HELPER_PAYMENT_TYPE, new Object[0])).append(" ").append(paymentType.toString()).append("\n").append(CommonHelper.getLocalizedString(Messages.PAYMENT_HELPER_FORWARDING_TO_PAYMENT_SITE_WARNING, new Object[0]));
        try {
            NotificationHelper.sendSimpleNotification(bookingCtr.toReference(), (EntityReference<SMSite>)((EntityReference)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.SITE)), emailsTo.toArray(new String[0]), subject, text.toString(), false, new MailPart[0]);
        }
        catch (Throwable t) {
            this.log.error(String.format("Failed sending payment notification for reservation [%s]", recordLocator));
        }
    }
}

