/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.booking.initiatePayment.b2c;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.dict.CommunicationType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSite;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMStep4Settings;
import com.gridnine.xtrip.common.model.ibecorp.sm.SalesOfficeDetails;
import com.gridnine.xtrip.common.model.mail.MailPart;
import com.gridnine.xtrip.common.model.profile.Address;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.pg.IBusPgContextKeys;
import com.gridnine.xtrip.common.util.PersonalName;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.booking.initiatePayment.b2c.B2CInitiatePaymentHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.booking.B2BInitiatePaymentParameters;
import com.gridnine.xtrip.server.ibecorp.common.CommonHelper;
import com.gridnine.xtrip.server.ibecorp.l10n.Messages;
import com.gridnine.xtrip.server.ibecorp.notifications.NotificationHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Objects;

public class SendSalesOfficeReservationNotificationProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) {
        B2BInitiatePaymentParameters parameters = (B2BInitiatePaymentParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        PaymentType paymentType = (PaymentType)ctx.getMandatoryObject((Enum)IBusPgContextKeys.PAYMENT_TYPE);
        SalesContext sc = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        EntityContainer bookingCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE);
        EntityReference site = (EntityReference)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.SITE);
        SMStep4Settings step4Settings = Objects.requireNonNull(CommonHelper.getStep4Settings((EntityReference<SMSite>)site));
        SalesOfficeDetails salesOfficeDetails = step4Settings.getCashSalesOfficesDetails().stream().filter(sod -> sod.getUid().equals(parameters.getSalesOfficeUid())).findFirst().orElseThrow(() -> Xeption.forDeveloper((String)"invalid SalesOfficeUid value", (Object[])new Object[0]));
        ArrayList<String> tos = new ArrayList<String>();
        if (salesOfficeDetails.isSendToOfficeCustomEmail()) {
            tos.add(salesOfficeDetails.getEmail());
        }
        if (salesOfficeDetails.isSendToAgencyCommonEmail()) {
            ((Organization)EntityStorage.get().resolve(sc.getSubagency()).getEntity()).getCommunications().stream().filter(c -> c.getType() == CommunicationType.EMAIL).forEach(c -> tos.add(c.getSense()));
        }
        if (tos.isEmpty()) {
            return;
        }
        Reservation reservation = B2CInitiatePaymentHelper.getFirstReservation((EntityContainer<BookingFile>)bookingCtr);
        String recordLocator = CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)reservation);
        String subject = CommonHelper.getLocalizedString(Messages.PAYMENT_HELPER_INFORMATION_ABOUT_BOOKING, new Object[0]) + " " + recordLocator;
        StringBuilder text = new StringBuilder();
        text.append(CommonHelper.getLocalizedString(Messages.PAYMENT_HELPER_BUYOUT_ADDRESS, new Object[0])).append(" ").append(ProfileHelper.buildFullAddress((Address)salesOfficeDetails.getAddress(), (Locale)LocaleHelper.getCurrentLocale(), (boolean)false)).append("\n");
        text.append(CommonHelper.getLocalizedString(Messages.PAYMENT_HELPER_BOOKING_NUMBER, new Object[0])).append(" ").append(recordLocator).append("\n").append(CommonHelper.getLocalizedString(Messages.PAYMENT_HELPER_CONTACT, new Object[0])).append(" ").append(TextUtil.buildFullName((PersonalName)((BookingFile)bookingCtr.getEntity()).getCustomer().getPassport())).append("\n");
        CommonHelper.getPhone(((BookingFile)bookingCtr.getEntity()).getCustomer().getCommunications(), CommunicationType.CELL, CommunicationType.MOBILE, CommunicationType.HOME_PHONE).map(CommonHelper::buildPhoneNumber).ifPresent(phone -> text.append(CommonHelper.getLocalizedString(Messages.PAYMENT_HELPER_MOBILE_PHONE, new Object[0])).append(" ").append((String)phone).append("\n"));
        CommonHelper.getEmail(((BookingFile)bookingCtr.getEntity()).getCustomer().getCommunications()).ifPresent(email -> {
            text.append(CommonHelper.getLocalizedString(Messages.PAYMENT_HELPER_EMAIL, new Object[0])).append(" ").append(email.getSense()).append("\n");
            tos.add(email.getSense());
        });
        int i = 1;
        for (Product prod : AirProductHelper.getAirProductsList((Reservation)reservation)) {
            text.append(CommonHelper.getLocalizedString(Messages.PAYMENT_HELPER_PASSENGER_NUMBER, new Object[0])).append(i++).append(": ").append(TextUtil.buildFullName((PersonalName)prod.getTraveller().getPassport())).append("\n");
        }
        text.append(CommonHelper.getLocalizedString(Messages.PAYMENT_HELPER_PAYMENT_TYPE, new Object[0])).append(" ").append(paymentType.toString()).append("\n").append(CommonHelper.getLocalizedString(Messages.PAYMENT_HELPER_FORWARDING_TO_PAYMENT_SITE_WARNING, new Object[0]));
        try {
            NotificationHelper.sendSimpleNotification(bookingCtr.toReference(), (EntityReference<SMSite>)site, tos.toArray(new String[0]), subject, text.toString(), false, new MailPart[0]);
        }
        catch (Throwable t) {
            this.log.error(String.format("failed sending sales at office notification for reservation [%s]", recordLocator));
        }
    }
}

