/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.booking.refund;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.midoffice.model.UnsellFinanceDetails;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.XSSerializable;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.B2BRestHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.booking.RefundDetailsResult;
import com.gridnine.xtrip.server.ibecorp.common.components.PriceComponentsParameters;
import com.gridnine.xtrip.server.ibecorp.common.components.ReservationPriceComponents;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.util.HashSet;
import java.util.Objects;

public class RefundDetailsResultBuilder
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        EntityReference userRef = (EntityReference)ctx.getObject((Enum)IBusIbecorpContextKeys.AUTHORIZED_USER);
        UnsellFinanceDetails details = (UnsellFinanceDetails)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.UNSELL_FINANCE_DETAILS);
        EntityContainer bookingCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE_CLONE);
        PriceComponentsParameters priceComponentsParameters = PriceComponentsParameters.getB2BComponentsParameters((EntityReference<Person>)userRef, salesContext);
        Reservation reservation = null;
        HashSet<BaseProduct> unsellProducts = new HashSet<BaseProduct>();
        for (String productUid : details.getGdsDetails().keySet()) {
            BaseProduct product = BookingHelper.findProduct((EntityContainer)bookingCtr, (String)productUid);
            if (product == null) {
                throw Xeption.forDeveloper((String)"can't find product with uid {0}", (Object[])new Object[]{productUid});
            }
            if (reservation == null) {
                reservation = product.getReservation();
            } else if (!MiscUtil.equals((Object)reservation, (Object)product.getReservation())) {
                throw Xeption.forDeveloper((String)"multiple reservations is not supported: {0} != {1}", (Object[])new Object[]{CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)reservation), CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)product.getReservation())});
            }
            ProductHandler handler = Objects.requireNonNull(GeneralProductHelper.getHandler((BaseProduct)product));
            BaseProduct refund = handler.getNextProduct(product);
            BaseProduct unsell = refund != null ? refund : product;
            unsellProducts.add(unsell);
            unsellProducts.addAll(BookingHelper.getConnectedProducts((BaseProduct)unsell));
        }
        RefundDetailsResult result = new RefundDetailsResult();
        result.setRefundPrice(ReservationPriceComponents.builder(reservation, priceComponentsParameters).setProductFilter(unsellProducts::contains).setNegateAfter().setIncludeVoid().build().createPrice());
        result.setFinanceDetailsToken(B2BRestHelper.encodeToken((XSSerializable)details));
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)result);
    }
}

