/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.booking.refund.railway;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.ibecorp.rzd.RzdCommonHelper;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.cabinet.CommonRailProxyConverter;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.booking.OrderProductsParameters;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.RailRefundProxy;
import com.gridnine.xtrip.server.ibecorp.common.rest.rail.IBusIbecorpRailContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class CommonRailRefundProxyConverter
extends BaseProcessor {
    private boolean beforeRefund;
    private static final String beforeRefundName = "beforeRefund";

    public void configure(Map<String, String> parameters) {
        super.configure(parameters);
        this.beforeRefund = Boolean.valueOf(parameters.get(beforeRefundName));
    }

    public void process(MessageContext ctx) throws Exception {
        OrderProductsParameters refundParameters = (OrderProductsParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        RailRefundProxy refundProxy = (RailRefundProxy)ctx.getMandatoryObject((Enum)IBusIbecorpRailContextKeys.REST_PROXY);
        refundProxy.setTitle(this.getTitle(LocaleManager.get().getCurrentLocale()));
        refundProxy.setBeforeRefundMessage(this.getBeforeRefundMessage());
        refundProxy.setSeatInfo(this.getSeatInfo(reservation, refundParameters.getProductUids()));
    }

    private String getSeatInfo(Reservation reservation, List<String> uids) {
        String seatInfo;
        Map<String, Set<String>> productPlaces = CommonRailProxyConverter.getProductPlaces(reservation);
        if (this.beforeRefund) {
            HashSet places = new HashSet();
            for (Map.Entry<String, Set<String>> entry : productPlaces.entrySet()) {
                if (!uids.contains(entry.getKey())) continue;
                places.addAll(entry.getValue());
            }
            seatInfo = RzdCommonHelper.convertPlacesSet(places);
            RailwayProduct product = RzdCommonHelper.getProduct((Reservation)reservation);
            seatInfo = seatInfo + RzdCommonHelper.getServiceClassStr((RailwayProduct)product);
        } else {
            seatInfo = RzdCommonHelper.getPlacesInfo(Collections.singletonList(reservation), (ProductStatus)ProductStatus.REFUND);
        }
        return seatInfo;
    }

    private String getTitle(Locale locale) {
        return this.beforeRefund ? LocaleManager.get().getL10nResourceManager().getMessage(locale, "IBECORP_RAIL_REFUND_TEMPLATE_TITLE_CANCELLATION_STATEMENT", new Object[0]) : LocaleManager.get().getL10nResourceManager().getMessage(locale, "IBECORP_RAIL_REFUND_TEMPLATE_TITLE_RETURN_RECEIPT", new Object[0]);
    }

    private String getBeforeRefundMessage() {
        return this.beforeRefund ? L10nResourcesManager.getStr((String)"IBECORP_RAIL_REFUND_TEMPLATE_MESSAGE_CANCELLATION_STATEMENT", (Object[])new Object[0]) : null;
    }
}

