/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.booking.refund.railway;

import com.gridnine.xtrip.common.jr.JasperUtil;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.util.Base64;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.RailRefundProductProxy;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.RailRefundProxy;
import com.gridnine.xtrip.server.ibecorp.common.rest.rail.IBusIbecorpRailContextKeys;
import com.gridnine.xtrip.server.ibecorp.model.cabinet.RailProductProxy;
import com.gridnine.xtrip.server.ibus.IbusHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.math.BigDecimal;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRMapCollectionDataSource;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class RailRefundDocumentContentGenerator
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        RailRefundProxy source = (RailRefundProxy)ctx.getMandatoryObject((Enum)IBusIbecorpRailContextKeys.REST_PROXY);
        List contents = (List)IbusHelper.getObjectN((MessageContext)ctx, (Enum)IBusIbecorpRailContextKeys.DOCUMENT_CONTENTS, () -> new ArrayList());
        byte[] content = this.generateContent(source);
        contents.add(Base64.encode((byte[])content));
        BigDecimal totalRefundSum = (BigDecimal)ctx.getObject((Enum)IBusIbecorpRailContextKeys.RAIL_REFUND_TOTAL_SUM);
        ctx.putObject((Enum)IBusIbecorpRailContextKeys.RAIL_REFUND_TOTAL_SUM, (Object)source.getTotal().add(MiscUtil.guarded((BigDecimal)totalRefundSum)));
    }

    private byte[] generateContent(RailRefundProxy source) throws Exception {
        Locale locale = LocaleManager.get().getCurrentLocale();
        JasperReport report = locale.equals(new Locale("ru", "ru")) || locale.equals(new Locale("ru")) ? JasperUtil.getReport((URL)((Object)((Object)this)).getClass().getResource("resource/railRefundTemplate.jrxml")) : JasperUtil.getReport((URL)((Object)((Object)this)).getClass().getResource("resource/railRefundTemplate_EN.jrxml"));
        Map<String, Object> params = RailRefundDocumentContentGenerator.getReportParameters(source);
        JasperPrint pdfPrint = JasperFillManager.fillReport((JasperReport)report, params, (JRDataSource)RailRefundDocumentContentGenerator.getDataSource(source));
        return JasperExportManager.exportReportToPdf((JasperPrint)pdfPrint);
    }

    private static Map<String, Object> getReportParameters(RailRefundProxy source) throws Exception {
        DateTimeFormatter dtf;
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("title", source.getTitle());
        parameters.put("orderNumber", source.getOrderNumber());
        parameters.put("ticketNumber", source.getProductNumber());
        Locale currentLocale = LocaleManager.get().getCurrentLocale();
        DateTimeFormatter dtfWithTZ = dtf = DateTimeFormat.forPattern((String)"dd MMMM yyyy HH:mm:ss").withLocale(currentLocale);
        DateTime inquiryDate = new DateTime();
        DateTime orderDate = source.getOrderDate();
        parameters.put("inquiryDate", inquiryDate.toString(dtfWithTZ));
        parameters.put("transactionNumber", source.getTransactionNumber());
        parameters.put("orderDate", orderDate != null ? orderDate.toString(dtfWithTZ) : null);
        parameters.put("trainNumber", source.getTrainNumber());
        parameters.put("route", source.getTrainRoute());
        parameters.put("departureDate", source.getDepartureDate() != null ? source.getDepartureDate().toString(dtf) : null);
        parameters.put("arrivalDate", source.getArrivalDate() != null ? source.getArrivalDate().toString(dtf) : null);
        parameters.put("carriageInfo", source.getCarriageInfo());
        parameters.put("seatsInfo", source.getSeatInfo());
        parameters.put("additionalInfo", source.getAdditionalInfo());
        parameters.put("warningInfo", RailRefundDocumentContentGenerator.getWarningInfo());
        return parameters;
    }

    private static String dateTimeToString(DateTime dt) {
        Locale currentLocale = LocaleManager.get().getCurrentLocale();
        DateTimeFormatter dtf = DateTimeFormat.forPattern((String)"dd MMMM yyyy HH:mm:ss").withLocale(currentLocale);
        return dt.toString(dtf);
    }

    private static JRDataSource getDataSource(RailRefundProxy source) {
        return new JRMapCollectionDataSource(RailRefundDocumentContentGenerator.getTicketsList(source));
    }

    private static List<Map<String, ?>> getTicketsList(RailRefundProxy source) {
        ArrayList dataList = new ArrayList();
        ArrayList ticketsList = new ArrayList();
        int number = 1;
        for (RailProductProxy proxy : source.getProducts()) {
            RailRefundProductProxy product = (RailRefundProductProxy)proxy;
            HashMap<String, Object> ticketDescription = new HashMap<String, Object>();
            ticketDescription.put("number", number);
            ticketDescription.put("ticketNumber", product.getTicketNumber());
            ticketDescription.put("docNumber", product.getPassengerDoc());
            ticketDescription.put("tariff", Optional.ofNullable(product.getRzdTariff()).map(Object::toString).orElse(""));
            ticketDescription.put("passenger", product.getPassengerFio());
            ++number;
            ticketsList.add(ticketDescription);
        }
        HashMap ticketsListDescription = new HashMap();
        ticketsListDescription.put("tickets", ticketsList);
        dataList.add(ticketsListDescription);
        return dataList;
    }

    private static String getWarningInfo() {
        return L10nResourcesManager.getStr((String)"IBECORP_RAIL_REFUND_WARNING_MESSAGE", (Object[])new Object[0]);
    }
}

