/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.booking.refund.railway;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.ibecorp.rzd.RzdCommonHelper;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.ValidationUtil;
import com.gridnine.xtrip.common.model.helpers.XtripPriceStructure;
import com.gridnine.xtrip.common.model.helpers.XtripPriceStructureHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibecorp.RzdHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.RailRefundProductProxy;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.RailRefundProxy;
import com.gridnine.xtrip.server.ibecorp.common.rest.rail.IBusIbecorpRailContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.IBusRailwayContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;

public class SimulateRefundProcessor
extends BaseProcessor {
    private boolean beforeRefund;
    private static final String beforeRefundName = "beforeRefund";
    private boolean simulate;
    private static final String simulateName = "simulate";

    public void configure(Map<String, String> parameters) {
        super.configure(parameters);
        this.beforeRefund = Boolean.valueOf(parameters.get(beforeRefundName));
        this.simulate = Boolean.valueOf(parameters.get(simulateName));
    }

    public void process(MessageContext ctx) throws Exception {
        RailRefundProxy refundProxy = (RailRefundProxy)ctx.getMandatoryObject((Enum)IBusIbecorpRailContextKeys.REST_PROXY);
        EntityContainer bookingFileContainer = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE);
        Reservation oldReservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        List refundProducts = (List)ctx.getMandatoryObject((Enum)IBusRailwayContextKeys.RAILWAY_PRODUCTS);
        if (this.simulate && ctx.getObject("messages") != null && ValidationUtil.hasErrors(this.getIBusMesasages((Map)ctx.getObject("messages")))) {
            throw Xeption.forDeveloper((String)"problem with simulate rail refund", (Object[])new Object[0]);
        }
        Reservation reservation = BookingHelper.findReservationByUid((BookingFile)((BookingFile)bookingFileContainer.getEntity()), (String)oldReservation.getUid());
        ctx.putObject((Enum)IBusMidofficeContextKeys.RESERVATION, (Object)reservation);
        List products = RzdCommonHelper.getProducts((Reservation)reservation);
        BigDecimal total = BigDecimal.ZERO;
        for (RailwayProduct product : products) {
            if (this.isContinue(refundProducts, product)) continue;
            BigDecimal totalProduct = this.getProductTotal(product);
            for (Traveller traveller : product.getPassengers()) {
                RailRefundProductProxy productProxy = RzdHelper.getCommonRailProductProxy(product, traveller, RailRefundProductProxy.class);
                productProxy.setTotal(totalProduct);
                productProxy.setRzdTariff(RzdHelper.getProductTariff(product, traveller));
                productProxy.setTicketNumber(product.getSystemNumber());
                refundProxy.getProducts().add(productProxy);
            }
            total = MiscUtil.sum((BigDecimal[])new BigDecimal[]{total, totalProduct});
        }
        refundProxy.setOrderDate((DateTime)products.stream().filter(prd -> prd.getStatus() == ProductStatus.SELL).findAny().map(prod -> new DateTime((Object)prod.getIssueDate())).orElse(null));
        refundProxy.setTotal(total);
        refundProxy.setTotalInfo(this.getTotalInfo());
        refundProxy.setBeforeRefund(this.beforeRefund);
    }

    private List<Message> getIBusMesasages(Map<Date, Message> messagesMap) {
        if (messagesMap == null) {
            return Collections.emptyList();
        }
        Collection<Message> iBusMessages = messagesMap.values();
        if (iBusMessages == null) {
            return Collections.emptyList();
        }
        return new ArrayList<Message>(iBusMessages);
    }

    private String getTotalInfo() {
        String totalInfo = !this.beforeRefund ? "IBECORP_REFUND_TOTAL_INFO_RETURNED" : (this.simulate ? "IBECORP_REFUND_TOTAL_INFO_TO_RETURN" : "IBECORP_REFUND_TOTAL_INFO_TOTAL");
        return L10nResourcesManager.getStr((String)totalInfo, (Object[])new Object[0]);
    }

    private BigDecimal getProductTotal(RailwayProduct product) throws Exception {
        XtripPriceStructure priceStructure = XtripPriceStructureHelper.calculatePriceStructure((BaseProduct)product, (boolean)false);
        BigDecimal total = priceStructure.getTotal();
        return total == null ? BigDecimal.ZERO : total.abs();
    }

    private boolean isContinue(List<BaseProduct> refundProducts, RailwayProduct product) {
        if (this.simulate) {
            if (product.getStatus() != ProductStatus.REFUND) {
                return true;
            }
            RailwayProduct prev = product.getPreviousProduct();
            if (this.beforeRefund && !refundProducts.contains(prev)) {
                return true;
            }
        } else {
            if (!this.beforeRefund && product.getStatus() != ProductStatus.REFUND) {
                return true;
            }
            if (this.beforeRefund && !refundProducts.contains(product)) {
                return true;
            }
        }
        return false;
    }
}

