/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.cabinet;

import com.gridnine.xtrip.common.model.rules.standard.RuleResultValue;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.cabinet.CabinetConverterHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.renderer.BaseActionValue;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.renderer.MultiSelectRuleActionValue;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.renderer.RenderedItem;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.renderer.RuleActionUpdatedValue;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.renderer.SimpleCommissionActionValue;
import java.util.Collection;
import java.util.List;

public enum ActionValueRenderer {
    SIMPLE_COMMISSION_FIELD{

        SimpleCommissionActionValue renderValue(Object value) {
            RuleResultValue ruleResultValue = (RuleResultValue)value;
            SimpleCommissionActionValue result = new SimpleCommissionActionValue();
            result.setRenderer(this.name());
            result.setAmount(ruleResultValue.getValue());
            result.setCurrency(ruleResultValue.getCurrencyCode());
            result.setTarget(ruleResultValue.getTarget());
            result.setForceSegmentCalculation(ruleResultValue.isForceSegmentCalculation());
            if (ruleResultValue.getFopValues() != null && ruleResultValue.getFopValues().length > 0) {
                throw new UnsupportedOperationException();
            }
            return result;
        }

        RuleResultValue unrenderValue(RuleActionUpdatedValue value) {
            RuleResultValue result = new RuleResultValue();
            result.setValue(value.getAmount());
            result.setCurrencyCode(value.getCurrency());
            result.setTarget(value.getTarget());
            result.setForceSegmentCalculation(result.isForceSegmentCalculation());
            return result;
        }

        SimpleCommissionActionValue renderBaseValues(Object value) {
            SimpleCommissionActionValue result = new SimpleCommissionActionValue();
            result.setRenderer(this.name());
            result.getTargets().addAll((Collection)value);
            return result;
        }
    }
    ,
    MULTISELECT{

        MultiSelectRuleActionValue renderValue(Object value) {
            MultiSelectRuleActionValue result = new MultiSelectRuleActionValue();
            result.setRenderer(this.name());
            result.getSelectedValues().addAll((Collection)value);
            return result;
        }

        @Override
        List<RenderedItem> unrenderValue(RuleActionUpdatedValue value) {
            return CabinetConverterHelper.wrapIds2RenderedItem(value.getSelectedValues());
        }

        MultiSelectRuleActionValue renderBaseValues(Object value) {
            MultiSelectRuleActionValue result = new MultiSelectRuleActionValue();
            result.setRenderer(this.name());
            result.getValues().addAll((Collection)value);
            return result;
        }
    };


    abstract BaseActionValue renderValue(Object var1);

    abstract Object unrenderValue(RuleActionUpdatedValue var1);

    abstract BaseActionValue renderBaseValues(Object var1);
}

