/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.cabinet;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.ibecorp.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.incidents.IncidentsLog;
import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.l10n.model.L10nStringHelper;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.l10n.model.PersonalLocalizableName;
import com.gridnine.xtrip.common.l10n.model.PersonalLocalizableNameUtil;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.CommunicationType;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.gds.sabre.ProfileSynchronizationUtil;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.ibecorp.NotificationType;
import com.gridnine.xtrip.common.model.profile.AirlineBonusCard;
import com.gridnine.xtrip.common.model.profile.Contract2ModelContract;
import com.gridnine.xtrip.common.model.profile.CostCode;
import com.gridnine.xtrip.common.model.profile.CostCodeProperties;
import com.gridnine.xtrip.common.model.profile.EmployeeCategory;
import com.gridnine.xtrip.common.model.profile.ModelContract;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationIndex;
import com.gridnine.xtrip.common.model.profile.OrganizationType;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonCommunication;
import com.gridnine.xtrip.common.model.profile.PersonCostCode;
import com.gridnine.xtrip.common.model.profile.PersonEmployment;
import com.gridnine.xtrip.common.model.profile.PersonIndex;
import com.gridnine.xtrip.common.model.profile.PersonNotificationSettings;
import com.gridnine.xtrip.common.model.profile.PersonPassportWrapper;
import com.gridnine.xtrip.common.model.profile.PersonType;
import com.gridnine.xtrip.common.model.profile.RailwayBonusCard;
import com.gridnine.xtrip.common.model.restriction.resource.ModelRestrictionEntityResources;
import com.gridnine.xtrip.common.restriction.resource.RestrictionResourceProxy;
import com.gridnine.xtrip.common.restriction.resource.standard.StandardRestrictionResourceOperations;
import com.gridnine.xtrip.common.rules.RuleRestriction;
import com.gridnine.xtrip.common.rules.RuleResult;
import com.gridnine.xtrip.common.rules.RuleSettings;
import com.gridnine.xtrip.common.rules.RulesEnvironment;
import com.gridnine.xtrip.common.rules.elements.RuleAction;
import com.gridnine.xtrip.common.rules.elements.RuleCondition;
import com.gridnine.xtrip.common.rules.elements.RuleProperty;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.utils.SearchQueryHelper;
import com.gridnine.xtrip.common.system.model.RegionalType;
import com.gridnine.xtrip.common.user.UserData;
import com.gridnine.xtrip.common.util.DateUtils;
import com.gridnine.xtrip.common.util.ExceptionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.TranslitUtil;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.autocomplete.organizations.CorporateClientHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.booking.RestBookingHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.cabinet.ActionValueConverter;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.cabinet.CabinetHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.cabinet.RestrictionValueConverter;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.OrganizationRestCostCode;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.Action;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.BlankOwnerReference;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.Condition;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.Contract;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.ContractListItem;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.Employee;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.EmployeeCategoryInfo;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.EmployeeListItemPassport;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.EmployeeOrganizationCostCode;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.EmployeeOrganizationInfo;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.EmployerType;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.PersonListItem;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.Property;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.RestDisabledNotificationType;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.RestEmployeeCostCode;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.RestEmployeeCostCodeValue;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.Rule;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.RuleGroupListItem;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.RuleRestrictionInfo;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.RuleRestrictionUpdated;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.RuleResultInfo;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.RuleResultUpdated;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.SystemAccess;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.renderer.BaseActionValue;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.renderer.BaseRuleRestrictionValue;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.renderer.RenderedItem;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.renderer.RuleActionUpdatedValue;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.renderer.RuleRestrictionUpdatedValue;
import com.gridnine.xtrip.server.ibecorp.common.CommonHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.CommonConverterHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.cabinet.RestPerson;
import com.gridnine.xtrip.server.ibecorp.common.rest.rail.model.RailBonusCard;
import com.gridnine.xtrip.server.ibecorp.notifications.NotificationHelper;
import com.gridnine.xtrip.server.ibecorp.security.acl.IbePermissionManager;
import com.gridnine.xtrip.server.restriction.helper.RestrictionsHelper;
import com.gridnine.xtrip.server.security.acl.helper.AclHelper;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class CabinetConverterHelper {
    public static final Locale ruLocale = new Locale("ru");
    private static final Pattern CYRILLIC = Pattern.compile("[\u0430-\u044f\u0410-\u042f]+");

    public static List<RestPerson> convertPersons(List<PersonIndex> personIndexes) {
        return personIndexes.stream().map(idx -> EntityStorage.get().resolve(idx.getSource())).map(CabinetConverterHelper::convertPerson2Rest).peek(person -> person.setUid(null)).sorted((p1, p2) -> {
            String p1Lat = MiscUtil.guarded((String)(p1.getLastNameLat() + " " + p1.getFirstNameLat()));
            String p2Lat = MiscUtil.guarded((String)(p2.getLastNameLat() + " " + p2.getFirstNameLat()));
            String p1Cyr = MiscUtil.guarded((String)(p1.getLastName() + " " + p1.getFirstName()));
            String p2Cyr = MiscUtil.guarded((String)(p2.getLastName() + " " + p2.getFirstName()));
            int cmp = p1Lat.compareToIgnoreCase(p2Lat);
            return cmp != 0 ? cmp : p1Cyr.compareToIgnoreCase(p2Cyr);
        }).collect(Collectors.toList());
    }

    public static RestPerson convertPerson2Rest(EntityContainer<Person> personCtr) {
        RestPerson result = new RestPerson();
        return CabinetConverterHelper.convertPerson2Rest(personCtr, result);
    }

    public static <P extends RestPerson> P convertPerson2Rest(EntityContainer<Person> personCtr, P result) {
        result.setUid(personCtr.getUid());
        Person person = (Person)personCtr.getEntity();
        result.setWithoutMiddleName(person.isWithoutMiddleName());
        result.setFirstNameLat(L10nStringHelper.getValue((L10nString)person.getFirstName(), (Locale)Locale.ENGLISH, (boolean)true));
        result.setSecondNameLat(L10nStringHelper.getValue((L10nString)person.getSecondName(), (Locale)Locale.ENGLISH, (boolean)true));
        result.setLastNameLat(L10nStringHelper.getValue((L10nString)person.getLastName(), (Locale)Locale.ENGLISH, (boolean)true));
        result.setMiddleNameLat(L10nStringHelper.getValue((L10nString)person.getMiddleName(), (Locale)Locale.ENGLISH, (boolean)true));
        result.setFirstName(L10nStringHelper.getValue((L10nString)person.getFirstName(), (Locale)ruLocale, (boolean)true));
        result.setSecondName(L10nStringHelper.getValue((L10nString)person.getSecondName(), (Locale)ruLocale, (boolean)true));
        result.setLastName(L10nStringHelper.getValue((L10nString)person.getLastName(), (Locale)ruLocale, (boolean)true));
        result.setMiddleName(L10nStringHelper.getValue((L10nString)person.getMiddleName(), (Locale)ruLocale, (boolean)true));
        result.setGender(person.getGender());
        result.setBirthDate(DateUtils.toLocalDate((Date)person.getBirthday()));
        result.getPassports().addAll(PersonPassportWrapper.wrap((List)person.getPassports()).stream().map(CommonConverterHelper::convertPassport2Rest).collect(Collectors.toList()));
        result.getPhones().addAll(CommonHelper.getPhones(person.getCommunications(), CommunicationType.CELL, CommunicationType.MOBILE).stream().map(CommonConverterHelper::convertPhoneCommunication2Rest).collect(Collectors.toList()));
        result.getEmails().addAll(CommonHelper.getEmails(person.getCommunications()).stream().map(CommonConverterHelper::convertEmailCommunication2Rest).filter(Objects::nonNull).collect(Collectors.toList()));
        if (SystemHelper.containsInRegionalSettings((RegionalType)RegionalType.KZ)) {
            result.setIIN(person.getRegistrationIdKz());
        }
        result.getAirlineBonusCards().addAll(person.getAirlineBonusCards().stream().map(CommonConverterHelper::convertAirlineBonusCard2Rest).collect(Collectors.toList()));
        person.getRailwayBonusCards().stream().filter(Objects::nonNull).map(CommonConverterHelper::convertRailwayBonusCard2Rest).forEach(card -> result.getRailwayBonusCards().add(card));
        result.setDisabled(((Person)personCtr.getEntity()).isDisabled());
        return result;
    }

    public static Employee convertPerson2RestEmployee(EntityContainer<Person> personCtr) throws Exception {
        return CabinetConverterHelper.convertPerson2RestEmployee(personCtr, false);
    }

    public static Employee convertPerson2RestEmployee(EntityContainer<Person> personCtr, boolean isCabinetHolder) throws Exception {
        Employee result = new Employee();
        CabinetConverterHelper.convertPerson2Rest(personCtr, result);
        Person person = (Person)personCtr.getEntity();
        boolean systemAccessGranted = CabinetHelper.updateUserAccountGranted();
        if (systemAccessGranted || isCabinetHolder) {
            SystemAccess systemAccess = new SystemAccess();
            systemAccess.setLogin(person.getLoginName());
            result.setSystemAccess(systemAccess);
        }
        List personEmployments = person.isDisabled() ? person.getEmployments() : com.gridnine.xtrip.common.model.helpers.ProfileHelper.getPersonEmployments((Person)person);
        personEmployments.stream().map(employment -> CabinetConverterHelper.convertPersonEmployment2EmployeeOrganizationInfo(employment, personCtr, isCabinetHolder)).filter(Objects::nonNull).forEach(info -> result.getOrganizationInfos().add(info));
        result.setSecurityType(person.getSecurityType());
        result.setCreatePersonAllowed(CabinetHelper.isGrantedCreatePerson((EntityContainer<Person>)EntityContainer.create((BaseEntity)new Person())));
        return result;
    }

    private static EmployeeOrganizationInfo convertPersonEmployment2EmployeeOrganizationInfo(PersonEmployment employment, EntityContainer<Person> personCtr, boolean isCabinetHolder) {
        Person employee = (Person)personCtr.getEntity();
        EntityReference employmentOrganizationRef = employment.getOrganization();
        EntityContainer orgCtr = EntityStorage.get().resolve(employmentOrganizationRef);
        if (orgCtr == null) {
            return null;
        }
        Organization org = (Organization)orgCtr.getEntity();
        EmployeeOrganizationInfo result = new EmployeeOrganizationInfo();
        result.setOrganization(orgCtr.toReference());
        result.setMainEmployment(employment.isMainEmployment());
        result.setRole(employee.getAclSettings().getAclRole());
        result.setEmployeeCategoryInfo(CabinetConverterHelper.convertEmployeeCategoryToRest(employment.getEmployeeCategory()));
        result.setAclViewGranted(false);
        result.setAclCreateGranted(false);
        result.setAclEditGranted(false);
        result.setAclDeleteGranted(false);
        try {
            RestrictionResourceProxy aclProxy;
            Map aclProxyMap = RestrictionsHelper.buildProxies(personCtr, (String)ModelRestrictionEntityResources.ENTITY_PERSON.getId());
            boolean personEditGranted = IbePermissionManager.isEntityGranted(personCtr, aclProxyMap, StandardRestrictionResourceOperations.EDIT);
            if (personEditGranted && (aclProxy = (RestrictionResourceProxy)aclProxyMap.get(employment.getUid())) != null) {
                String currentLogin = UserData.get().getCurrentUser();
                result.setAclViewGranted(AclHelper.isGranted((RestrictionResourceProxy)aclProxy, (String)ModelRestrictionEntityResources.ENTITY_PERSON_EMPLOYMENT.getId(), (String)currentLogin, (String)StandardRestrictionResourceOperations.VIEW.getId(), Collections.emptyList()));
                result.setAclCreateGranted(AclHelper.isGranted((RestrictionResourceProxy)aclProxy, (String)ModelRestrictionEntityResources.ENTITY_PERSON_EMPLOYMENT.getId(), (String)currentLogin, (String)StandardRestrictionResourceOperations.CREATE.getId(), Collections.emptyList()));
                result.setAclEditGranted(AclHelper.isGranted((RestrictionResourceProxy)aclProxy, (String)ModelRestrictionEntityResources.ENTITY_PERSON_EMPLOYMENT.getId(), (String)currentLogin, (String)StandardRestrictionResourceOperations.EDIT.getId(), Collections.emptyList()));
                result.setAclDeleteGranted(AclHelper.isGranted((RestrictionResourceProxy)aclProxy, (String)ModelRestrictionEntityResources.ENTITY_PERSON_EMPLOYMENT.getId(), (String)currentLogin, (String)StandardRestrictionResourceOperations.DELETE.getId(), Collections.emptyList()));
            }
        }
        catch (Exception e) {
            IncidentsLog.reportException((String)("AclHelper.isGranted failed for person " + PersonalLocalizableNameUtil.buildFullName((PersonalLocalizableName)employee, (Locale)LocaleHelper.getCurrentLocale(), (boolean)false) + " (" + employee.getUid() + ")"), (Throwable)e);
        }
        if (!employee.getCostCodes().isEmpty()) {
            List<EmployeeOrganizationCostCode> organizationCostCodes = RestBookingHelper.getEmployeeOrganizationCostCodes(org, CabinetConverterHelper.convertCostCodesToRestEmployeeCostCodes(employee.getCostCodes()));
            List costCodeCategoryUids = organizationCostCodes.stream().map(OrganizationRestCostCode::getCostCodeCategoryUid).collect(Collectors.toList());
            employee.getCostCodes().stream().filter(cc -> MiscUtil.equals((Object)cc.getOrganization(), (Object)orgCtr.toReference())).filter(cc -> cc.getCostCodeProperties() != null).filter(cc -> cc.getCostCodeProperties().getCategory() != null).filter(cc -> costCodeCategoryUids.contains(cc.getCostCodeProperties().getCategory().getCode())).map(CabinetConverterHelper::convertEmployeeCostCodeToRest).forEach(result.getCostCodesInfo()::add);
        }
        if (isCabinetHolder) {
            PersonNotificationSettings personNotificationSettings = NotificationHelper.getPersonNotificationSettings((Person)personCtr.getEntity(), (EntityReference<Organization>)employmentOrganizationRef);
            ProfileHelper.PERSON_NOTIFICATION_TYPES.stream().map(nt -> CabinetConverterHelper.buildRestDisabledNotificationType(nt, personNotificationSettings)).forEach(result.getDisabledNotificationTypes()::add);
        }
        return result;
    }

    private static RestDisabledNotificationType buildRestDisabledNotificationType(NotificationType notificationType, PersonNotificationSettings personNotificationSettings) {
        RestDisabledNotificationType result = new RestDisabledNotificationType();
        result.setNotificationType(notificationType);
        result.setDisabled(personNotificationSettings != null && personNotificationSettings.getDisabledNotificationTypes().contains(notificationType));
        return result;
    }

    private static List<RestEmployeeCostCode> convertCostCodesToRestEmployeeCostCodes(List<? extends CostCode> costCodes) {
        return costCodes.stream().map(CabinetConverterHelper::convertEmployeeCostCodeToRest).collect(Collectors.toList());
    }

    private static RestEmployeeCostCode convertEmployeeCostCodeToRest(CostCode costCode) {
        RestEmployeeCostCode restCostCode = new RestEmployeeCostCode();
        restCostCode.setName(costCode.getCostCodeProperties().getName());
        restCostCode.setCostCodeCategoryUid(costCode.getCostCodeProperties().getCategory().getCode());
        restCostCode.setValue(RestBookingHelper.getEmployeeCostCodeValue(costCode));
        return restCostCode;
    }

    public static EmployeeCategoryInfo convertEmployeeCategoryToRest(EmployeeCategory emplCat) {
        if (emplCat == null) {
            return null;
        }
        Locale currentLocale = LocaleManager.get().getCurrentLocale();
        EmployeeCategoryInfo info = new EmployeeCategoryInfo();
        info.setUid(emplCat.getUid());
        info.setName(L10nStringHelper.getValue((L10nString)emplCat.getName(), (Locale)currentLocale, (boolean)false));
        return info;
    }

    public static PersonListItem convertPersonEmployersMap2PersonListItem(MiscUtil.Pair<EntityContainer<Person>, Set<EntityReference<Organization>>> personEmployersMapEntry) {
        EntityContainer personCtr = (EntityContainer)personEmployersMapEntry.getFirst();
        PersonListItem result = new PersonListItem();
        result.setPersonRef(personCtr.toReference());
        Person person = (Person)personCtr.getEntity();
        result.getClients().addAll((Collection)personEmployersMapEntry.getSecond());
        result.setFullName(PersonalLocalizableNameUtil.buildFullName((PersonalLocalizableName)person, (Locale)LocaleHelper.getCurrentLocale(), (boolean)false));
        result.setBirthDate(DateUtils.toLocalDate((Date)person.getBirthday()));
        result.setDisabled(person.isDisabled());
        person.getPassports().stream().map(CabinetConverterHelper::passport2EmployeeListItemPassport).forEach(result.getDocuments()::add);
        CommonHelper.getPhones(person.getCommunications(), CommunicationType.CELL, CommunicationType.MOBILE).stream().map(CommonConverterHelper::convertPhoneCommunication2Rest).forEach(result.getPhones()::add);
        CommonHelper.getEmails(person.getCommunications()).stream().map(CommonConverterHelper::convertEmailCommunication2Rest).filter(TextUtil::nonBlank).forEach(result.getEmails()::add);
        return result;
    }

    public static PersonListItem convertTravellerPersonListItem(EntityContainer<Person> travellerCtr) {
        PersonListItem result = new PersonListItem();
        result.setPersonRef(travellerCtr.toReference());
        Person traveller = (Person)travellerCtr.getEntity();
        traveller.getEmployments().stream().map(PersonEmployment::getOrganization).forEach(result.getClients()::add);
        result.setFullName(PersonalLocalizableNameUtil.buildFullName((PersonalLocalizableName)traveller, (Locale)LocaleHelper.getCurrentLocale(), (boolean)false));
        result.setBirthDate(DateUtils.toLocalDate((Date)traveller.getBirthday()));
        result.setDisabled(traveller.isDisabled());
        traveller.getPassports().stream().map(CabinetConverterHelper::passport2EmployeeListItemPassport).filter(Objects::nonNull).forEach(result.getDocuments()::add);
        CommonHelper.getPhones(traveller.getCommunications(), CommunicationType.CELL, CommunicationType.MOBILE).stream().map(CommonConverterHelper::convertPhoneCommunication2Rest).filter(Objects::nonNull).forEach(result.getPhones()::add);
        CommonHelper.getEmails(traveller.getCommunications()).stream().map(CommonConverterHelper::convertEmailCommunication2Rest).filter(Objects::nonNull).forEach(result.getEmails()::add);
        return result;
    }

    private static EmployeeListItemPassport passport2EmployeeListItemPassport(Passport passport) {
        EmployeeListItemPassport document = new EmployeeListItemPassport();
        document.setNumber(passport.getNumber());
        document.setType(passport.getType());
        return document;
    }

    public static void updateRestEmployee2Person(Employee restEmployee, Person result, boolean isCreate) {
        CabinetConverterHelper.updateRestEmployee2Person(restEmployee, result, isCreate, false, false);
    }

    public static void updateRestEmployee2Person(Employee restEmployee, Person result, boolean isCreate, boolean isB2C, boolean isCabinetHolder) {
        Date now = new Date();
        HashSet orgs = new HashSet();
        restEmployee.getOrganizationInfos().removeIf(orgInfo -> !orgs.add(orgInfo.getOrganization()));
        CabinetConverterHelper.deleteEmployeeDuplicates(result);
        result.getEmployments().removeIf(empl -> MiscUtil.isBetween((Date)empl.getOpened(), (Date)empl.getClosed(), (Date)now) && !orgs.contains(empl.getOrganization()));
        if (!isB2C) {
            result.getTypes().clear();
            result.getTypes().addAll(CabinetConverterHelper.getPersonTypes(restEmployee));
        }
        if (isCabinetHolder) {
            result.getNotificationSettings().clear();
        }
        for (EmployeeOrganizationInfo info : restEmployee.getOrganizationInfos()) {
            PersonEmployment employment = result.getEmployments().stream().filter(empl -> MiscUtil.equals((Object)info.getOrganization(), (Object)empl.getOrganization())).findFirst().orElseGet(() -> {
                PersonEmployment newEmpl = new PersonEmployment();
                newEmpl.setOrganization(info.getOrganization());
                result.getEmployments().add(newEmpl);
                return newEmpl;
            });
            employment.setMainEmployment(info.isMainEmployment());
            if (!MiscUtil.isBetween((Date)employment.getOpened(), (Date)employment.getClosed(), (Date)now)) {
                employment.setOpened(null);
                employment.setClosed(null);
            }
            if (info.isMainEmployment()) {
                result.getAclSettings().setAclRole(info.getRole());
            }
            EntityContainer orgCtr = EntityStorage.get().resolve(info.getOrganization());
            Organization org = (Organization)orgCtr.getEntity();
            EmployeeCategoryInfo restEmpCat = info.getEmployeeCategoryInfo();
            if (restEmpCat != null) {
                org.getEmployeeCategories().stream().filter(Objects::nonNull).filter(orgEmplCat -> restEmpCat.getUid().equals(orgEmplCat.getUid())).findFirst().ifPresent(ExceptionUtil.wrapConsumer(cat -> {
                    if (isCreate || CabinetHelper.updateUserAccountCategoryGranted()) {
                        employment.setEmployeeCategory(cat);
                    } else if (!MiscUtil.equals((Object)cat, (Object)employment.getEmployeeCategory())) {
                        throw Xeption.forEndUser((String)"ERROR_UPDATE_EMPLOYEE_CATEGORY_NOT_ALLOWED", (Object[])new Object[0]);
                    }
                }));
            }
            List<PersonCostCode> newPersonCostCodes = CorporateClientHelper.convertPersonRestCostCodes(info.getCostCodesInfo(), (EntityContainer<Organization>)orgCtr, RestBookingHelper.REST_EMPLOYEE_COST_CODE_VALUES_EQUATOR, (cc, rcc) -> {
                RestEmployeeCostCodeValue value = rcc.getValue();
                if (value != null) {
                    cc.setValue(ProfileSynchronizationUtil.removeIllegalSymbols((String)value.getEnglishValue(), (boolean)true));
                    cc.setLocalValue(value.getLocalValue());
                    cc.setEnglishValue(value.getEnglishValue());
                }
            });
            List categoriesToReplace = newPersonCostCodes.stream().map(CostCode::getCostCodeProperties).map(CostCodeProperties::getCategory).collect(Collectors.toList());
            result.getCostCodes().removeIf(cc -> MiscUtil.equals((Object)cc.getOrganization(), (Object)info.getOrganization()) && cc.getCostCodeProperties() != null && categoriesToReplace.contains(cc.getCostCodeProperties().getCategory()));
            result.getCostCodes().addAll(newPersonCostCodes);
            if (!isCabinetHolder) continue;
            PersonNotificationSettings personNotificationSettings = new PersonNotificationSettings();
            personNotificationSettings.setOrganization(orgCtr.toReference());
            info.getDisabledNotificationTypes().stream().filter(RestDisabledNotificationType::isDisabled).map(RestDisabledNotificationType::getNotificationType).filter(ProfileHelper.PERSON_NOTIFICATION_TYPES::contains).forEach(personNotificationSettings.getDisabledNotificationTypes()::add);
            result.getNotificationSettings().add(personNotificationSettings);
        }
        CabinetConverterHelper.updateRest2Person((RestPerson)restEmployee, result);
        result.setSecurityType(restEmployee.getSecurityType());
    }

    public static void deleteEmployeeDuplicates(Person person) {
        Map<EntityReference, List<PersonEmployment>> orgEmploymentsMap = person.getEmployments().stream().collect(Collectors.groupingBy(PersonEmployment::getOrganization));
        for (List<PersonEmployment> orgEmployments : orgEmploymentsMap.values()) {
            if (orgEmployments.size() == 1) continue;
            PersonEmployment employment = CabinetConverterHelper.findActualOrLastEmployment(orgEmployments);
            person.getEmployments().removeIf(pe -> MiscUtil.equals((Object)pe.getOrganization(), (Object)employment.getOrganization()) && !MiscUtil.equals((Object)pe, (Object)employment));
        }
    }

    private static PersonEmployment findActualOrLastEmployment(List<PersonEmployment> orgEmployments) {
        Date now = new Date();
        PersonEmployment result = null;
        for (PersonEmployment employment : orgEmployments) {
            if (MiscUtil.isBetween((Date)employment.getOpened(), (Date)employment.getClosed(), (Date)now)) {
                return employment;
            }
            if (result == null) {
                result = employment;
                continue;
            }
            int compareOpened = MiscUtil.compare((Date)employment.getOpened(), (Date)result.getOpened(), (boolean)true);
            if (compareOpened < 0) continue;
            if (compareOpened > 0) {
                result = employment;
                continue;
            }
            if (MiscUtil.compare((Date)employment.getClosed(), (Date)result.getClosed(), (boolean)false) <= 0) continue;
            result = employment;
        }
        return result;
    }

    private static Collection<PersonType> getPersonTypes(Employee restEmployee) {
        Set orgUids = restEmployee.getOrganizationInfos().stream().filter(Objects::nonNull).map(EmployeeOrganizationInfo::getOrganization).filter(Objects::nonNull).map(EntityReference::getUid).filter(TextUtil::nonBlank).collect(Collectors.toSet());
        if (orgUids.isEmpty()) {
            return Collections.emptyList();
        }
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchQueryHelper.buildOrEqStringCriterion((String)"containerUid", orgUids));
        query.getPreferredProperties().add(OrganizationIndex.Property.types.name());
        List orgIndices = EntityStorage.get().search(OrganizationIndex.class, query).getData();
        Set orgTypes = orgIndices.stream().map(OrganizationIndex::getTypes).flatMap(Collection::stream).filter(Objects::nonNull).collect(Collectors.toSet());
        ArrayList<PersonType> result = new ArrayList<PersonType>();
        if (orgTypes.contains(OrganizationType.CORPORATE_CLIENT)) {
            result.add(PersonType.PASSENGER);
        }
        if (orgTypes.contains(OrganizationType.AGENCY)) {
            result.add(PersonType.AGENT);
        }
        return result;
    }

    private static boolean containsCyrillicSymbols(String value) {
        return StringUtils.isNotBlank((String)value) && CYRILLIC.matcher(value).find();
    }

    private static String getTranslation(String value) {
        return TranslitUtil.cyr2lat((String)value, (TranslitUtil.TranslitRules)TranslitUtil.TranslitRules.GOST_52535_1_2006);
    }

    public static void updateRest2Person(RestPerson restPerson, Person result) {
        CabinetConverterHelper.updatePersonNames(result, restPerson.getLastName(), restPerson.getFirstName(), restPerson.getSecondName(), restPerson.getMiddleName(), LocaleHelper.RU_LOCALE);
        CabinetConverterHelper.updatePersonNames(result, restPerson.getLastNameLat(), restPerson.getFirstNameLat(), restPerson.getSecondNameLat(), restPerson.getMiddleNameLat(), LocaleHelper.EN_LOCALE);
        if (restPerson.isWithoutMiddleName()) {
            result.getMiddleName().getValues().clear();
        }
        result.setGender(restPerson.getGender());
        result.setBirthday(DateUtils.toJavaDate((LocalDate)restPerson.getBirthDate()));
        result.setWithoutMiddleName(restPerson.isWithoutMiddleName());
        restPerson.getPassports().forEach(restPassport -> {
            restPassport.setBirthDate(restPerson.getBirthDate());
            restPassport.setGender(restPerson.getGender());
        });
        result.getPassports().clear();
        restPerson.getPassports().stream().map(CommonConverterHelper::convertPassportFromRest).forEach(w -> w.unwrap((Collection)result.getPassports()));
        result.getCommunications().clear();
        result.getCommunications().addAll(restPerson.getPhones().stream().map(phone -> CommonConverterHelper.convertRest2PhoneCommunication(phone, CommunicationType.MOBILE, PersonCommunication::new)).collect(Collectors.toList()));
        result.getCommunications().addAll(restPerson.getEmails().stream().map(email -> CommonConverterHelper.convertRest2EmailCommunication(email, PersonCommunication::new)).collect(Collectors.toList()));
        if (SystemHelper.containsInRegionalSettings((RegionalType)RegionalType.KZ)) {
            result.setRegistrationIdKz(restPerson.getIIN());
        }
        result.getAirlineBonusCards().clear();
        CabinetConverterHelper.updateAirlineBonusCards(restPerson, result.getAirlineBonusCards());
        CabinetConverterHelper.updateRailwayBonusCards(restPerson, result.getRailwayBonusCards());
    }

    private static void updatePersonNames(Person result, String lastName, String firstName, String secondName, String middleName, Locale locale) {
        L10nStringHelper.setValue((L10nString)result.getFirstName(), (String)firstName, (Locale)locale);
        L10nStringHelper.setValue((L10nString)result.getSecondName(), (String)secondName, (Locale)locale);
        L10nStringHelper.setValue((L10nString)result.getLastName(), (String)lastName, (Locale)locale);
        L10nStringHelper.setValue((L10nString)result.getMiddleName(), (String)middleName, (Locale)locale);
    }

    private static void updateAirlineBonusCards(RestPerson restPerson, List<AirlineBonusCard> airlineBonusCards) {
        airlineBonusCards.clear();
        restPerson.getAirlineBonusCards().stream().map(CommonConverterHelper::convertRest2AirlineBonusCard).forEach(airlineBonusCards::add);
    }

    private static void updateRailwayBonusCards(RestPerson restPerson, List<RailwayBonusCard> railwayBonusCards) {
        railwayBonusCards.clear();
        for (RailBonusCard card : restPerson.getRailwayBonusCards()) {
            RailwayBonusCard railwayBonusCard = CommonConverterHelper.convertRest2RailwayBonusCard(card);
            railwayBonusCards.add(railwayBonusCard);
        }
    }

    public static EmployerType convertOrganizationType2EmployerType(Collection<OrganizationType> orgTypes, EntityReference<Organization> orgRef) {
        if (orgTypes.contains(OrganizationType.CORPORATE_CLIENT)) {
            return EmployerType.CORPORATE_CLIENT;
        }
        if (orgTypes.contains(OrganizationType.AGENCY)) {
            EntityReference<Organization> mainAgencyRef = CommonHelper.findMainAgency();
            return orgRef.equals(mainAgencyRef) ? EmployerType.MAIN_AGENCY : EmployerType.AGENCY;
        }
        return null;
    }

    public static BlankOwnerReference convertBlankOwnerReference2Rest(Organization org, Locale locale) {
        BlankOwnerReference result = new BlankOwnerReference();
        result.setCode(org.getCode());
        result.setName((String)CommonConverterHelper.findByLocale(org.getShortName().getValues(), locale));
        return result;
    }

    public static ContractListItem convertContract2ContractListItem(EntityContainer<com.gridnine.xtrip.common.model.profile.Contract> contractEntityContainer) {
        ContractListItem result = new ContractListItem();
        com.gridnine.xtrip.common.model.profile.Contract contract = (com.gridnine.xtrip.common.model.profile.Contract)contractEntityContainer.getEntity();
        result.setUid(contractEntityContainer.getUid());
        result.setType(contract.getContractType());
        result.setName(contract.getName());
        result.setNumber(contract.getNumber());
        result.setClient(contract.getCustomer());
        result.setSupplier(contract.getSupplier());
        result.setStartDate(MiscUtil.toLocalDate((Date)contract.getStartDate()));
        result.setEndDate(MiscUtil.toLocalDate((Date)contract.getEndDate()));
        return result;
    }

    public static Contract convertContract2Rest(EntityContainer<com.gridnine.xtrip.common.model.profile.Contract> contractEntityContainer) {
        Contract result = new Contract();
        com.gridnine.xtrip.common.model.profile.Contract contract = (com.gridnine.xtrip.common.model.profile.Contract)contractEntityContainer.getEntity();
        result.setUid(contractEntityContainer.getUid());
        result.setType(contract.getContractType());
        result.setAgreementType(contract.getAgreementType());
        result.setName(contract.getName());
        result.setClient(contract.getCustomer());
        result.setSupplier(contract.getSupplier());
        result.setStartDate(MiscUtil.toLocalDate((Date)contract.getStartDate()));
        result.setEndDate(MiscUtil.toLocalDate((Date)contract.getEndDate()));
        result.setNumber(contract.getNumber());
        result.setSignDate(MiscUtil.toLocalDate((Date)contract.getIssueDate()));
        EntityStorage es = EntityStorage.get();
        result.getRuleGroups().addAll(contract.getModelContracts().stream().map(Contract2ModelContract::getModelContract).map(arg_0 -> ((EntityStorage)es).resolve(arg_0)).map(CabinetConverterHelper::convertModelContract2Rest).collect(Collectors.toList()));
        return result;
    }

    public static RuleGroupListItem convertModelContract2Rest(EntityContainer<ModelContract> modelContractEntityContainer, boolean uidAndNameOnly) {
        RuleGroupListItem result = new RuleGroupListItem();
        ModelContract modelContract = (ModelContract)modelContractEntityContainer.getEntity();
        result.setUid(modelContractEntityContainer.getUid());
        result.setName(modelContract.getName());
        if (!uidAndNameOnly) {
            result.setLastModififed(MiscUtil.toLocalDateTime((Date)modelContractEntityContainer.getModified()));
            result.setPriority(modelContract.getPriority());
        }
        return result;
    }

    public static RuleGroupListItem convertModelContract2Rest(EntityContainer<ModelContract> modelContractEntityContainer) {
        return CabinetConverterHelper.convertModelContract2Rest(modelContractEntityContainer, true);
    }

    public static Rule convertRule2Rest(RuleSettings ruleSetting) {
        Rule result = new Rule();
        result.setUid(ruleSetting.getUid());
        result.setName(ruleSetting.getName());
        result.setDescription(ruleSetting.getRestrictionsInfoNoHtml());
        result.setStartDate(MiscUtil.toLocalDate((Date)ruleSetting.getPeriodBegin()));
        result.setEndDate(MiscUtil.toLocalDate((Date)ruleSetting.getPeriodEnd()));
        return result;
    }

    public static RuleRestrictionInfo convertRuleRestriction2Rest(RuleRestriction ruleRestriction) {
        RuleRestrictionInfo result = new RuleRestrictionInfo();
        RuleProperty property = ruleRestriction.getProperty();
        RuleCondition condition = ruleRestriction.getCondition();
        result.setProperty(CabinetConverterHelper.convertRuleProperty2Rest(property));
        result.setCondition(CabinetConverterHelper.convertRuleCondition2Rest(condition));
        result.setRestrictionValue(CabinetConverterHelper.convertRuleRestrictionValue2Rest(property, ruleRestriction.getValue()));
        return result;
    }

    public static RuleRestriction convertRest2RuleRestriction(RuleRestrictionUpdated ruleRestrictionUpdated) {
        RuleRestriction result = new RuleRestriction();
        result.setCondition(CabinetConverterHelper.convertRest2RuleCondition(ruleRestrictionUpdated.getCondition()));
        result.setProperty(CabinetConverterHelper.convertRest2RuleProperty(ruleRestrictionUpdated.getProperty()));
        result.setValue(CabinetConverterHelper.convertRest2RuleRestrictionValue(result.getProperty(), ruleRestrictionUpdated.getRestrictionValue()));
        return result;
    }

    private static BaseRuleRestrictionValue convertRuleRestrictionValue2Rest(RuleProperty property, Object value) {
        RestrictionValueConverter valueConverter = RestrictionValueConverter.valueOf(property.getRendererId());
        return valueConverter.convertValue2Rest(value);
    }

    private static Object convertRest2RuleRestrictionValue(RuleProperty property, RuleRestrictionUpdatedValue value) {
        RestrictionValueConverter valueConverter = RestrictionValueConverter.valueOf(property.getRendererId());
        return valueConverter.convertRest2Value(value);
    }

    static RenderedItem convertEnum2RenderedItem(Enum<?> item) {
        RenderedItem result = new RenderedItem();
        result.setCode(item.name());
        result.setCaption(item.toString());
        return result;
    }

    static RenderedItem wrapId2RenderedItem(String id) {
        RenderedItem result = new RenderedItem();
        result.setCode(id);
        return result;
    }

    static List<RenderedItem> wrapIds2RenderedItem(List<String> ids) {
        return ids.stream().map(CabinetConverterHelper::wrapId2RenderedItem).collect(Collectors.toList());
    }

    static <E extends Enum> Function<RenderedItem, E> convertRenderedItem2Enum(Class<E> clazz) {
        return ri -> Enum.valueOf(clazz, ri.getCode());
    }

    static <E extends Enum> E convertRenderedItem2Enum(RenderedItem renderedItem, Class<E> clazz) {
        return (E)((Enum)CabinetConverterHelper.convertRenderedItem2Enum(clazz).apply(renderedItem));
    }

    static RenderedItem convertBoolean2RenderedItem(Boolean item) {
        RenderedItem result = new RenderedItem();
        result.setCode(item.toString());
        result.setCaption(item.toString());
        return result;
    }

    static Boolean convertRenderedItem2Boolean(RenderedItem item) {
        return Boolean.parseBoolean(item.getCode());
    }

    static <E extends Enum> List<RenderedItem> convertEnumListValue2RenderedItems(List<E> value) {
        return value.stream().map(CabinetConverterHelper::convertEnum2RenderedItem).collect(Collectors.toList());
    }

    static <E extends Enum> List<RenderedItem> convertEnumListValue2RenderedItems(E ... value) {
        return CabinetConverterHelper.convertEnumListValue2RenderedItems(Arrays.asList(value));
    }

    static <E extends Enum> List<E> convertRenderedItems2EnumListValue(List<RenderedItem> ruleRestrictionValue, Class<E> clazz) {
        return ruleRestrictionValue.stream().map(CabinetConverterHelper.convertRenderedItem2Enum(clazz)).collect(Collectors.toList());
    }

    private static <D extends BaseDictionary, R extends DictionaryReference<D>> RenderedItem convertDictionaryReference2RenderedItem(R dictionaryReference) {
        RenderedItem result = new RenderedItem();
        result.setCode(dictionaryReference.getCode());
        result.setCaption(dictionaryReference.getCaption());
        return result;
    }

    private static <D extends BaseDictionary, R extends DictionaryReference<D>> Function<RenderedItem, R> convertRenderedItem2DictionaryReference(Class<D> clazz) {
        return ri -> DictionaryCache.get().findByCode(clazz, ri.getCode()).toReference();
    }

    static <D extends BaseDictionary, R extends DictionaryReference<D>> List<RenderedItem> convertDictionaryReferencesToRenderedItems(List<R> dictionaryReference) {
        return dictionaryReference.stream().map(CabinetConverterHelper::convertDictionaryReference2RenderedItem).collect(Collectors.toList());
    }

    static <D extends BaseDictionary, R extends DictionaryReference<D>> List<R> convertRenderedItems2DictionaryReferences(List<RenderedItem> renderedItems, Class<D> clazz) {
        return renderedItems.stream().map(CabinetConverterHelper.convertRenderedItem2DictionaryReference(clazz)).collect(Collectors.toList());
    }

    private static <T extends BaseEntity, R extends EntityReference<T>> R convert2EntityReference(String uid, Class<T> clazz) {
        return (R)new EntityReference(uid, clazz, null);
    }

    private static <T extends BaseEntity, R extends EntityReference<T>> RenderedItem convertEntityReference2RenderedItem(R entityReference) {
        RenderedItem result = new RenderedItem();
        EntityContainer entityContainer = EntityStorage.get().resolve(entityReference);
        result.setCode(entityContainer.getUid());
        result.setCaption(entityContainer.getEntity().toString());
        return result;
    }

    private static <T extends BaseEntity, R extends EntityReference<T>> R convertRenderedItem2EntityReference(RenderedItem renderedItem, Class<T> clazz) {
        return CabinetConverterHelper.convert2EntityReference(renderedItem.getCode(), clazz);
    }

    static <T extends BaseEntity, R extends EntityReference<T>> List<RenderedItem> convertEntityReferencesUids2RenderedItems(List<String> uids, Class<T> clazz) {
        List references = uids.stream().map(s -> CabinetConverterHelper.convert2EntityReference(s, clazz)).collect(Collectors.toList());
        return CabinetConverterHelper.convertEntityReferences2RenderedItems(references);
    }

    static <T extends BaseEntity, R extends EntityReference<T>> List<RenderedItem> convertEntityReferences2RenderedItems(List<R> entityReferences) {
        return entityReferences.stream().map(CabinetConverterHelper::convertEntityReference2RenderedItem).collect(Collectors.toList());
    }

    private static <T extends BaseEntity, R extends EntityReference<T>> List<R> convertRenderedItems2EntityReferences(List<RenderedItem> renderedItems, Class<T> clazz) {
        return renderedItems.stream().map(renderedItem -> CabinetConverterHelper.convertRenderedItem2EntityReference(renderedItem, clazz)).collect(Collectors.toList());
    }

    static <T extends BaseEntity, R extends EntityReference<T>> List<String> convertRenderedItems2EntityReferenceUids(List<RenderedItem> renderedItems, Class<T> clazz) {
        return CabinetConverterHelper.convertRenderedItems2EntityReferences(renderedItems, clazz).stream().map(EntityReference::getUid).collect(Collectors.toList());
    }

    public static org.joda.time.LocalDate convertDate2Rest(Date date) {
        return date != null ? new org.joda.time.LocalDate((Object)date) : null;
    }

    public static Date convertRest2Date(org.joda.time.LocalDate localDate) {
        return localDate != null ? localDate.toDate() : null;
    }

    public static Property convertRuleProperty2Rest(RuleProperty property) {
        Property result = new Property();
        result.setId(property.getId());
        result.setName(property.getDisplayName());
        return result;
    }

    private static RuleProperty convertRest2RuleProperty(String property) {
        return ((RulesEnvironment)Environment.getPublished(RulesEnvironment.class)).findProperty(property);
    }

    public static Condition convertRuleCondition2Rest(RuleCondition condition) {
        Condition result = new Condition();
        result.setId(condition.getId());
        result.setName(condition.getDisplayName());
        result.setValue(condition.hasRightSide());
        return result;
    }

    private static RuleCondition convertRest2RuleCondition(String condition) {
        return ((RulesEnvironment)Environment.getPublished(RulesEnvironment.class)).findCondition(condition);
    }

    public static RuleResultInfo convertRuleResult2Rest(RuleResult ruleResult) {
        RuleResultInfo result = new RuleResultInfo();
        RuleAction action = ruleResult.getAction();
        result.setAction(CabinetConverterHelper.convertRuleAction2Rest(action));
        result.setActionValue(CabinetConverterHelper.convertActionValue2Rest(action, ruleResult.getValue()));
        return result;
    }

    public static RuleResult convertRest2RuleResult(RuleResultUpdated ruleResultUpdated) {
        RuleResult result = new RuleResult();
        result.setAction(CabinetConverterHelper.convertRest2RuleAction(ruleResultUpdated.getAction()));
        result.setValue(CabinetConverterHelper.convertRest2ActionValue(result.getAction(), ruleResultUpdated.getActionValue()));
        return result;
    }

    private static BaseActionValue convertActionValue2Rest(RuleAction action, Object value) {
        ActionValueConverter valueConverter = ActionValueConverter.valueOf(action.getRendererId());
        return valueConverter.convertValue2Rest(value);
    }

    private static Object convertRest2ActionValue(RuleAction action, RuleActionUpdatedValue value) {
        ActionValueConverter valueConverter = ActionValueConverter.valueOf(action.getRendererId());
        return valueConverter.convertRest2Value(value);
    }

    public static Action convertRuleAction2Rest(RuleAction ruleAction) {
        Action result = new Action();
        result.setId(ruleAction.getId());
        result.setName(ruleAction.getDisplayName());
        result.setValue(ruleAction.hasValue());
        return result;
    }

    private static RuleAction convertRest2RuleAction(String action) {
        return ((RulesEnvironment)Environment.getPublished(RulesEnvironment.class)).findAction(action);
    }
}

