/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.cabinet;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.ibecorp.restriction.resource.IbeRestrictionGroupResources;
import com.gridnine.xtrip.common.incidents.IncidentsLog;
import com.gridnine.xtrip.common.jr.JasperUtil;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.asset.AssetsStorage;
import com.gridnine.xtrip.common.model.assets.UserAccount;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.BookingFileIndex;
import com.gridnine.xtrip.common.model.booking.CommonProductIndex;
import com.gridnine.xtrip.common.model.booking.ReservationStatus;
import com.gridnine.xtrip.common.model.booking.commission.BaseCommissionProperties;
import com.gridnine.xtrip.common.model.booking.commission.FeePropertiesIndex;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.parameters.EntityStorageSearchParameters;
import com.gridnine.xtrip.common.model.finance.FinanceDocument;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSite;
import com.gridnine.xtrip.common.model.profile.ContractCustomerIndex;
import com.gridnine.xtrip.common.model.profile.ContractIndex;
import com.gridnine.xtrip.common.model.profile.ModelContract;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationIndex;
import com.gridnine.xtrip.common.model.profile.OrganizationType;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonEmployment;
import com.gridnine.xtrip.common.model.restriction.resource.ModelRestrictionEntityResources;
import com.gridnine.xtrip.common.model.system.BillingTransactionIndex;
import com.gridnine.xtrip.common.model.system.BinaryData;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.model.system.DownloadableData;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.Metadata;
import com.gridnine.xtrip.common.model.system.MetadataKey;
import com.gridnine.xtrip.common.model.system.TemplateDocument;
import com.gridnine.xtrip.common.model.system.TemplateDocumentIndex;
import com.gridnine.xtrip.common.restriction.resource.standard.StandardRestrictionResourceOperations;
import com.gridnine.xtrip.common.rules.RuleSettings;
import com.gridnine.xtrip.common.search.ResultMode;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.common.search.utils.SearchQueryHelper;
import com.gridnine.xtrip.common.security.acl.principal.AclUser;
import com.gridnine.xtrip.common.user.UserData;
import com.gridnine.xtrip.common.util.CompositeNumber;
import com.gridnine.xtrip.common.util.LocaleUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.autocomplete.organizations.CorporateClientHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.cabinet.CabinetConverterHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.Employee;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.GetAbstractPersonInfoResult;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.SystemAccess;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.site.CabinetMenuSection;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.site.CabinetMenuSettings;
import com.gridnine.xtrip.server.ibecorp.common.rest.authorization.AuthorizationHelper;
import com.gridnine.xtrip.server.ibecorp.helpers.XreportsIntegrationHelper;
import com.gridnine.xtrip.server.ibecorp.security.acl.IbePermissionManager;
import com.gridnine.xtrip.server.restriction.helper.RestrictionsHelper;
import com.gridnine.xtrip.server.security.acl.helper.AclHelper;
import java.io.ByteArrayOutputStream;
import java.security.GeneralSecurityException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.lang.StringUtils;

public class CabinetHelper {
    private static final Map<Locale, NumberFormat> NUMBER_FORMATS;

    public static NumberFormat getNumberFormat(Locale locale) {
        NumberFormat result = NUMBER_FORMATS.get(locale);
        return result != null ? result : NumberFormat.getInstance();
    }

    public static Comparator<BillingTransactionIndex> createBalancesComparator() {
        return (o1, o2) -> {
            int result = CabinetHelper.compareDates(o1.getTransactionDate(), o2.getTransactionDate());
            if (result == 0) {
                result = CabinetHelper.compareStrings(CabinetHelper.getBookingNumber(o1), CabinetHelper.getBookingNumber(o2));
            }
            return result;
        };
    }

    public static Comparator<ContractCustomerIndex> createClientsComparator() {
        return (ind1, ind2) -> {
            if (ind1 == null || ind1.getCustomer() == null) {
                return 1;
            }
            if (ind2 == null || ind2.getCustomer() == null) {
                return -1;
            }
            return CabinetHelper.compareStrings(ind1.getCustomer().getCaption(), ind2.getCustomer().getCaption());
        };
    }

    private static int compareStrings(String o1, String o2) {
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            return 1;
        }
        if (o2 == null) {
            return -1;
        }
        return o1.compareTo(o2);
    }

    private static int compareDates(Date o1, Date o2) {
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            return 1;
        }
        if (o2 == null) {
            return -1;
        }
        return o1.compareTo(o2);
    }

    public static String getBookingNumber(BillingTransactionIndex bti) {
        if (bti.getReferencedEntity() != null && BookingFile.class.equals((Object)bti.getReferencedEntity().getType())) {
            return bti.getReferencedEntity().getCaption();
        }
        return null;
    }

    public static boolean hasErrors(Iterable<Message> messages) {
        for (Message message : messages) {
            if (message.getType() != MessageType.ERROR) continue;
            return true;
        }
        return false;
    }

    public static EntityReference<Organization> findAgencyReference(Person person) {
        EntityReference agencyRef = null;
        EntityReference pOfWorkRef = CabinetHelper.findPlaceOFWorkReference(person);
        if (AuthorizationHelper.isCorporantAuthorized(person)) {
            EntityContainer pOfWorkCtr = EntityStorage.get().resolve(pOfWorkRef);
            if (pOfWorkCtr != null && ((Organization)pOfWorkCtr.getEntity()).getParent() != null) {
                agencyRef = ((Organization)pOfWorkCtr.getEntity()).getParent();
            }
        } else {
            agencyRef = pOfWorkRef;
        }
        return agencyRef;
    }

    public static EntityReference<Organization> findPlaceOFWorkReference(Person person) {
        PersonEmployment employment;
        List<PersonEmployment> employments = AuthorizationHelper.getValidEmployments(person);
        if (employments.size() > 1) {
            return AuthorizationHelper.findSelectedEmployment(person.getLoginName());
        }
        if (employments.size() == 1 && (employment = employments.get(0)).isMainEmployment()) {
            return employment.getOrganization();
        }
        return null;
    }

    @Deprecated
    public static EntityReference<Organization> findAgencyReferenceOld(Person person) {
        EntityReference agencyRef = null;
        EntityReference pOfWorkRef = CabinetHelper.findPlaceOFWorkReferenceOld(person);
        if (AuthorizationHelper.isCorporantAuthorizedOld(person)) {
            EntityContainer pOfWorkCtr = EntityStorage.get().resolve(pOfWorkRef);
            if (pOfWorkCtr != null && ((Organization)pOfWorkCtr.getEntity()).getParent() != null) {
                agencyRef = ((Organization)pOfWorkCtr.getEntity()).getParent();
            }
        } else {
            agencyRef = pOfWorkRef;
        }
        return agencyRef;
    }

    public static EntityReference<Organization> findPlaceOFWorkReferenceOld(Person person) {
        EntityReference res = null;
        for (PersonEmployment pe : person.getEmployments()) {
            if (pe == null || pe.getOrganization() == null || !pe.isMainEmployment() && person.getEmployments().size() != 1) continue;
            res = pe.getOrganization();
        }
        return res;
    }

    public static EntityContainer<TemplateDocument> getTemplateDocument(Locale locale) {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)TemplateDocumentIndex.Property.templateId.name(), (Object)"itinerary-receipt"));
        List indexes = ((EntityStorage)Environment.getPublished(EntityStorage.class)).search(TemplateDocumentIndex.class, query).getData();
        for (TemplateDocumentIndex index : indexes) {
            EntityContainer templateDocumentContainer = EntityStorage.get().resolve(index.getSource());
            boolean localeFound = false;
            for (Metadata meta : ((TemplateDocument)templateDocumentContainer.getEntity()).getMetadata()) {
                if (meta.getKey() == null || meta.getValue() == null || !meta.getKey().getCode().equals(MetadataKey.KEY_LOCALE.name()) || !TextUtil.isSame((String)meta.getValue().toString(), (String)locale.toString(), (boolean)true)) continue;
                localeFound = true;
            }
            if (!localeFound) continue;
            return templateDocumentContainer;
        }
        return null;
    }

    public static String findGrantedLogin(Person person) {
        if (AuthorizationHelper.isCorporantAuthorized(person)) {
            try {
                return ((Person)EntityStorage.get().resolve(person.getParent()).getEntity()).getLoginName();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return person.getLoginName();
    }

    @Deprecated
    public static String findGrantedLoginOld(Person person) {
        if (AuthorizationHelper.isCorporantAuthorizedOld(person)) {
            try {
                return ((Person)EntityStorage.get().resolve(person.getParent()).getEntity()).getLoginName();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return person.getLoginName();
    }

    public static RuleSettings findRuleSettings(ModelContract modelContract, String ruleUid) {
        return modelContract.getRuleSet().getRules().stream().filter(rs -> rs.getUid().equals(ruleUid)).findFirst().orElse(null);
    }

    public static <E extends BaseCommissionProperties, I extends EntityIndex<E>> List<EntityReference<E>> getAllCommissions(Class<I> cls, List<ProductType> productTypes) {
        try {
            LinkedList<EntityReference<EntityReference>> result = new LinkedList<EntityReference<EntityReference>>();
            SearchQuery query = new SearchQuery();
            if (FeePropertiesIndex.class.isAssignableFrom(cls) && productTypes != null) {
                ArrayList<SearchCriterion> criterions = new ArrayList<SearchCriterion>();
                for (ProductType productType : productTypes) {
                    criterions.add(SearchCriterion.contains((String)FeePropertiesIndex.Property.productTypes.name(), (Object)productType.name()));
                }
                query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])criterions.toArray(new SearchCriterion[0])));
            }
            for (EntityIndex index : EntityStorage.get().search(cls, query, (EntityStorageSearchParameters)new EntityStorageSearchParameters().noCache(true)).getData()) {
                result.add(index.getSource());
            }
            result.sort((o1, o2) -> TextUtil.compare((String)o1.getCaption(), (String)o2.getCaption(), (boolean)false, (boolean)false));
            return result;
        }
        catch (Exception e) {
            return Collections.emptyList();
        }
    }

    public static Set<OrganizationType> getOrganizationTypes(EntityReference<Organization> orgRef) {
        SearchQuery query = new SearchQuery();
        query.getPreferredProperties().add(OrganizationIndex.Property.types.name());
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)"containerUid", (Object)orgRef.getUid()));
        return ((OrganizationIndex)EntityStorage.get().search(OrganizationIndex.class, query).getData().get(0)).getTypes();
    }

    public static SearchQuery buildClientsQuery(EntityReference<Organization> agency) {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ContractIndex.Property.supplier.name(), agency));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ContractIndex.Property.contractType.name(), (Object)ContractType.CLIENT));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ContractIndex.Property.newModel.name(), (Object)Boolean.TRUE));
        Date now = new Date();
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractIndex.Property.startDate.name(), null), SearchCriterion.le((String)ContractIndex.Property.startDate.name(), (Object)MiscUtil.setDayEndTime((Date)now))}));
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractIndex.Property.endDate.name(), null), SearchCriterion.ge((String)ContractIndex.Property.endDate.name(), (Object)MiscUtil.clearTime((Date)now))}));
        query.getPreferredProperties().add(ContractIndex.Property.customer.name());
        return query;
    }

    public static List<EntityReference<Organization>> findCorporateClients(EntityReference<Organization> agency) {
        return CabinetHelper.findClients(agency, true);
    }

    public static List<EntityReference<Organization>> findAllClients(EntityReference<Organization> agency) {
        return CabinetHelper.findClients(agency, false);
    }

    private static List<EntityReference<Organization>> findClients(EntityReference<Organization> agency, boolean isOnlyCorporateClients) {
        List<EntityReference<Organization>> clientsNewContracts = CabinetHelper.findClientsNewContracts(agency, isOnlyCorporateClients);
        if (!clientsNewContracts.isEmpty()) {
            return clientsNewContracts;
        }
        return CabinetHelper.findClientsOldContracts(agency, isOnlyCorporateClients);
    }

    private static List<EntityReference<Organization>> findClientsNewContracts(EntityReference<Organization> agency, boolean isOnlyCorporateClients) {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ContractIndex.Property.supplier.name(), agency));
        if (isOnlyCorporateClients) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ContractIndex.Property.contractType.name(), (Object)ContractType.CLIENT));
        }
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ContractIndex.Property.newModel.name(), (Object)Boolean.TRUE));
        Date now = new Date();
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractIndex.Property.startDate.name(), null), SearchCriterion.le((String)ContractIndex.Property.startDate.name(), (Object)MiscUtil.setDayEndTime((Date)now))}));
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractIndex.Property.endDate.name(), null), SearchCriterion.ge((String)ContractIndex.Property.endDate.name(), (Object)MiscUtil.clearTime((Date)now))}));
        query.getPreferredProperties().add(ContractIndex.Property.customer.name());
        List data = EntityStorage.get().search(ContractIndex.class, query).getData();
        if (data.isEmpty()) {
            return Collections.emptyList();
        }
        return data.stream().map(ContractIndex::getCustomer).filter(Objects::nonNull).distinct().collect(Collectors.toList());
    }

    private static List<EntityReference<Organization>> findClientsOldContracts(EntityReference<Organization> agency, boolean isOnlyCorporateClients) {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractCustomerIndex.Property.newModel.name(), (Object)false), SearchCriterion.eq((String)ContractCustomerIndex.Property.newModel.name(), null)}));
        if (isOnlyCorporateClients) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ContractCustomerIndex.Property.contractType.name(), (Object)ContractType.CLIENT));
        }
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ContractCustomerIndex.Property.supplier.name(), agency));
        Date now = new Date();
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractCustomerIndex.Property.startDate.name(), null), SearchCriterion.le((String)ContractCustomerIndex.Property.startDate.name(), (Object)MiscUtil.setDayEndTime((Date)now))}));
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractCustomerIndex.Property.endDate.name(), null), SearchCriterion.ge((String)ContractCustomerIndex.Property.endDate.name(), (Object)MiscUtil.clearTime((Date)now))}));
        query.getPreferredProperties().add(ContractCustomerIndex.Property.customer.name());
        List data = EntityStorage.get().search(ContractCustomerIndex.class, query).getData();
        if (data.isEmpty()) {
            return Collections.emptyList();
        }
        return data.stream().map(ContractCustomerIndex::getCustomer).filter(Objects::nonNull).distinct().collect(Collectors.toList());
    }

    public static List<ProductType> getProductTypes() {
        return Arrays.asList(ProductType.AIR_TICKET, ProductType.RAILWAY_PRODUCT, ProductType.HOTEL_RESERVATION, ProductType.AEROEXPRESS, ProductType.BUS, ProductType.CAR_RENTAL, ProductType.INSURANCE_ACCIDENT, ProductType.INSURANCE_TOURISTIC, ProductType.MISC_PRODUCT, ProductType.TAXI, ProductType.VISA_PRODUCT, ProductType.TRANSFER);
    }

    public static void checkRequestPaginationParameters(Integer page, Integer pageSize) {
        if (page == null) {
            throw Xeption.forDeveloper((String)"'page' parameter is null", (Object[])new Object[0]);
        }
        if (pageSize == null) {
            throw Xeption.forDeveloper((String)"'pageSize' parameter is null", (Object[])new Object[0]);
        }
    }

    public static <E extends BaseEntity, I extends EntityIndex<E>> int queryCount(SearchQuery query, Class<I> cls) {
        query.setResultMode(ResultMode.COUNT_ONLY);
        return EntityStorage.get().search(cls, query).getTotalCount();
    }

    public static <E extends BaseEntity, I extends EntityIndex<E>> List<I> queryPageData(SearchQuery query, Class<I> cls, int page, int pageSize, SortOrder order, String ... orderProperties) {
        query.setLimit(pageSize);
        query.setOffset(page * pageSize);
        for (String orderProperty : orderProperties) {
            query.getCriteria().getOrders().put(orderProperty, order);
        }
        query.setResultMode(ResultMode.DATA_ONLY);
        return EntityStorage.get().search(cls, query).getData();
    }

    public static void applyB2cBookingsMandatoryFilters(SearchQuery query, EntityReference<Person> loginAgentRef, EntityReference<SMSite> siteRef) {
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BookingFileIndex.Property.customerProfile.name(), loginAgentRef));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BookingFileIndex.Property.site.name(), siteRef));
        SearchCriterion currentCriterion = SearchQueryHelper.buildOrContainsEnumCriterion((String)BookingFileIndex.Property.reservationStatuses.name(), EnumSet.of(ReservationStatus.PAYED, ReservationStatus.ISSUED));
        SearchCriterion archivedCriterion = SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchQueryHelper.buildOrContainsEnumCriterion((String)BookingFileIndex.Property.reservationStatuses.name(), EnumSet.of(ReservationStatus.CANCELED, ReservationStatus.BOOKING, ReservationStatus.INTENTION)), SearchCriterion.gt((String)BookingFileIndex.Property.createDate.name(), (Object)MiscUtil.addYearsToDate((Date)new Date(), (int)-1))});
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{currentCriterion, archivedCriterion}));
    }

    public static void applyB2cProductsMandatoryFilters(SearchQuery query, EntityReference<Person> loginAgentRef, EntityReference<SMSite> siteRef) {
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)CommonProductIndex.Property.bookingAgent.name(), loginAgentRef));
        SearchCriterion currentCriterion = SearchQueryHelper.buildOrEqEnumCriterion((String)CommonProductIndex.Property.reservationStatus.name(), EnumSet.of(ReservationStatus.PAYED, ReservationStatus.ISSUED));
        SearchCriterion archivedCriterion = SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchQueryHelper.buildOrEqEnumCriterion((String)CommonProductIndex.Property.reservationStatus.name(), EnumSet.of(ReservationStatus.CANCELED, ReservationStatus.BOOKING, ReservationStatus.INTENTION)), SearchCriterion.gt((String)CommonProductIndex.Property.bookingCreateDate.name(), (Object)MiscUtil.addYearsToDate((Date)new Date(), (int)-1))});
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{currentCriterion, archivedCriterion}));
    }

    public static void applyB2bBookingsMandatoryFilters(SearchQuery query, EntityReference<Organization> currentOrganization, EntityContainer<Person> loginAgentCtr) {
        ArrayList<SearchCriterion> criterionList = new ArrayList<SearchCriterion>();
        for (PersonEmployment employment : ((Person)loginAgentCtr.getEntity()).getEmployments()) {
            criterionList.add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)BookingFileIndex.Property.subagency.name(), (Object)employment.getOrganization()), SearchCriterion.contains((String)BookingFileIndex.Property.subagencies.name(), (Object)employment.getOrganization())}));
        }
        CorporateClientHelper.getCorporateClients(currentOrganization, true).stream().map(org -> SearchCriterion.eq((String)BookingFileIndex.Property.client.name(), (Object)org)).forEach(criterionList::add);
        query.getCriteria().getCriterions().add(SearchQueryHelper.toOrCriterion(criterionList));
    }

    public static void applyB2bProductsMandatoryFilters(SearchQuery query, EntityReference<Organization> currentOrganization, EntityContainer<Person> loginAgentCtr) {
        ArrayList<SearchCriterion> criterionList = new ArrayList<SearchCriterion>();
        for (PersonEmployment employment : ((Person)loginAgentCtr.getEntity()).getEmployments()) {
            criterionList.add(SearchCriterion.eq((String)CommonProductIndex.Property.subagency.name(), (Object)employment.getOrganization()));
        }
        CorporateClientHelper.getCorporateClients(currentOrganization, true).stream().map(org -> SearchCriterion.eq((String)CommonProductIndex.Property.client.name(), (Object)org)).forEach(criterionList::add);
        query.getCriteria().getCriterions().add(SearchQueryHelper.toOrCriterion(criterionList));
    }

    public static CabinetMenuSettings getCabinetMenuSettingsB2C(boolean authorizedUser) {
        CabinetMenuSettings cabinetSettings = new CabinetMenuSettings();
        cabinetSettings.getAllowedSections().add(CabinetMenuSection.SEARCH);
        if (authorizedUser) {
            cabinetSettings.getAllowedSections().add(CabinetMenuSection.ORDERS);
            cabinetSettings.getAllowedSections().add(CabinetMenuSection.PASSENGERS);
            cabinetSettings.getAllowedSections().add(CabinetMenuSection.USER_DATA);
        }
        return cabinetSettings;
    }

    public static CabinetMenuSettings getCabinetMenuSettings() throws Exception {
        CabinetMenuSettings cabinetSettings = new CabinetMenuSettings();
        String reportsLink = XreportsIntegrationHelper.getLink(UserData.get().getCurrentUser());
        cabinetSettings.setReportsLink(reportsLink);
        for (CabinetMenuSection section : CabinetMenuSection.values()) {
            if (!CabinetHelper.isSectionGranted(section) || section == CabinetMenuSection.REPORT && !TextUtil.nonBlank((String)reportsLink)) continue;
            cabinetSettings.getAllowedSections().add(section);
        }
        return cabinetSettings;
    }

    private static boolean isSectionGranted(CabinetMenuSection section) throws Exception {
        switch (section) {
            case ORDERS: {
                return CabinetHelper.isGranted(IbeRestrictionGroupResources.GROUP_BOOKINGS);
            }
            case CONTRACTS_AND_FEES: {
                return CabinetHelper.isGranted(IbeRestrictionGroupResources.GROUP_CONTRACTS);
            }
            case BUSINESS_TRIP: {
                return CabinetHelper.isGranted(IbeRestrictionGroupResources.GROUP_TRIPS);
            }
            case SALES: {
                return CabinetHelper.isGranted(IbeRestrictionGroupResources.GROUP_SALES);
            }
            case FINANCES: {
                return CabinetHelper.isGranted(IbeRestrictionGroupResources.GROUP_FINANCES);
            }
            case PASSENGERS: {
                return CabinetHelper.isGranted(IbeRestrictionGroupResources.GROUP_PASSENGERS);
            }
            case EMPLOYEES: {
                return CabinetHelper.isGranted(IbeRestrictionGroupResources.GROUP_EMPLOYEES);
            }
            case SCHEDULE: {
                return CabinetHelper.isGranted(IbeRestrictionGroupResources.GROUP_SCHEDULE);
            }
            case REPORT: {
                return CabinetHelper.isGranted(IbeRestrictionGroupResources.GROUP_REPORTS);
            }
            case SEARCH: {
                return CabinetHelper.isGranted(IbeRestrictionGroupResources.GROUP_SEARCH);
            }
            case USER_DATA: {
                return true;
            }
        }
        return false;
    }

    public static boolean isGranted(IbeRestrictionGroupResources groupResources) throws Exception {
        return AclHelper.isGranted(null, (String)groupResources.getId(), (String)UserData.get().getCurrentUser(), (String)StandardRestrictionResourceOperations.USE.getId(), Collections.emptyList());
    }

    public static boolean updateUserAccountGranted() throws Exception {
        return CabinetHelper.isGranted(IbeRestrictionGroupResources.GROUP_EMPLOYEES_CREDENTIALS);
    }

    public static boolean updateUserAccountCategoryGranted() throws Exception {
        return CabinetHelper.isGranted(IbeRestrictionGroupResources.GROUP_EMPLOYEES_CATEGORY);
    }

    public static boolean isBookingGranted() throws Exception {
        return CabinetHelper.isGranted(IbeRestrictionGroupResources.GROUP_BOOKING);
    }

    public static void updatePersonGranted(GetAbstractPersonInfoResult result, EntityContainer<Person> personCtr) throws Exception {
        Map aclProxyMap = RestrictionsHelper.buildProxies(personCtr, (String)ModelRestrictionEntityResources.ENTITY_PERSON.getId());
        result.setDisablePersonAllowed(IbePermissionManager.isEntityGranted(personCtr, aclProxyMap, StandardRestrictionResourceOperations.DELETE));
        result.setEditPersonAllowed(IbePermissionManager.isEntityGranted(personCtr, aclProxyMap, StandardRestrictionResourceOperations.EDIT));
    }

    public static boolean isGrantedCreatePerson(EntityContainer<Person> personCtr) throws Exception {
        return IbePermissionManager.isEntityGranted(personCtr, StandardRestrictionResourceOperations.CREATE);
    }

    private static String getEmail(Employee restEmployee) {
        return restEmployee.getEmails().stream().filter(Objects::nonNull).findFirst().orElse(null);
    }

    public static UserAccount updateUserAccount(Employee restEmployee, Person person) throws Exception {
        SystemAccess systemAccess = restEmployee.getSystemAccess();
        UserAccount userAccount = null;
        if (systemAccess == null || StringUtils.isBlank((String)systemAccess.getLogin())) {
            throw Xeption.forDeveloper((String)"systemAccess or login is null", (Object[])new Object[0]);
        }
        if (!person.getLoginName().equals(systemAccess.getLogin())) {
            throw Xeption.forDeveloper((String)String.format("login %s person %s is not match login %s from systemAccess", person.getLoginName(), ProfileHelper.getFullName((Person)person, (Locale)Locale.ENGLISH, (boolean)false), systemAccess.getLogin()), (Object[])new Object[0]);
        }
        if (TextUtil.nonBlank((String)systemAccess.getLogin())) {
            userAccount = (UserAccount)AssetsStorage.get().find(UserAccount.class, UserAccount.Property.loginName.name(), (Object)systemAccess.getLogin());
            if (userAccount == null) {
                throw new GeneralSecurityException(String.format("User %s is absent in database", systemAccess.getLogin()));
            }
            if (StringUtils.isNotBlank((String)systemAccess.getPassword())) {
                userAccount.setPassword(systemAccess.getPassword().toCharArray());
            }
            userAccount.setEmail(CabinetHelper.getEmail(restEmployee));
        }
        return userAccount;
    }

    public static MiscUtil.Pair<UserAccount, AclUser> createUserAccount(Person person, Employee restEmployee) throws Exception {
        SystemAccess systemAccess = restEmployee.getSystemAccess();
        if (systemAccess != null && StringUtils.isNotBlank((String)systemAccess.getLogin()) && StringUtils.isNotBlank((String)systemAccess.getPassword())) {
            MiscUtil.Pair pair = new MiscUtil.Pair();
            UserAccount account = new UserAccount();
            account.setLoginName(systemAccess.getLogin());
            account.setFullName(ProfileHelper.getFullName((Person)person, (Locale)CabinetConverterHelper.ruLocale, (boolean)false));
            account.setPassword(systemAccess.getPassword().toCharArray());
            account.setActive(true);
            account.setEmail(CabinetHelper.getEmail(restEmployee));
            pair.setFirst((Object)account);
            AclUser aclUser = new AclUser();
            aclUser.setId(account.getLoginName());
            aclUser.setName(account.getFullName());
            pair.setSecond((Object)aclUser);
            person.setLoginName(systemAccess.getLogin());
            return pair;
        }
        return null;
    }

    public static DownloadableData buildZIP2Download(List<DownloadableData> files, String fileName) {
        DownloadableData result = new DownloadableData();
        BinaryData binaryData = new BinaryData();
        binaryData.setContentType(ContentType.BINARY);
        result.setFileName(fileName);
        result.setContent(binaryData);
        List preparedFiles = files.stream().collect(Collectors.groupingBy(DownloadableData::getFileName)).entrySet().stream().flatMap(entry -> {
            String name = (String)entry.getKey();
            List groupedFiles = (List)entry.getValue();
            if (groupedFiles.size() > 1) {
                int fileExtensionDivider = name.lastIndexOf(".");
                for (int i = 1; i < groupedFiles.size(); ++i) {
                    String modifiedName = fileExtensionDivider != -1 ? String.format("%s (%s)%s", name.substring(0, fileExtensionDivider), i, name.substring(fileExtensionDivider)) : String.format("%s (%s)", name, i);
                    ((DownloadableData)groupedFiles.get(i)).setFileName(modifiedName);
                }
            }
            return groupedFiles.stream();
        }).collect(Collectors.toList());
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            try (ZipOutputStream zos = new ZipOutputStream(bos);){
                for (DownloadableData file : preparedFiles) {
                    ZipEntry entry2 = new ZipEntry(file.getFileName());
                    zos.putNextEntry(entry2);
                    zos.write(file.getContent().getData());
                    zos.closeEntry();
                }
            }
            binaryData.setData(bos.toByteArray());
        }
        catch (Exception e) {
            IncidentsLog.reportStackTrace((String)"Unable to ZIP itinerary receipts");
        }
        return result;
    }

    public static DownloadableData buildPdfFinanceDocument(FinanceDocument document) throws Exception {
        DownloadableData downloadableData = new DownloadableData();
        String fileName = TextUtil.buildFullNumber((CompositeNumber)document);
        fileName = String.format("%s_%s", fileName, document.getType());
        fileName = fileName.replaceAll("\\s+", "_");
        fileName = fileName + ".pdf";
        BinaryData content = new BinaryData();
        content.setContentType(ContentType.PDF);
        content.setData(JasperUtil.convertToPdf((byte[])document.getContent().getData()));
        downloadableData.setFileName(fileName);
        downloadableData.setContent(content);
        return downloadableData;
    }

    static {
        HashMap<Locale, NumberFormat> tNUMBER_FORMATS = new HashMap<Locale, NumberFormat>();
        tNUMBER_FORMATS.put(LocaleUtil.LOCALE_RU, NumberFormat.getInstance(LocaleUtil.LOCALE_RU));
        tNUMBER_FORMATS.put(new Locale("ru", "RU"), NumberFormat.getInstance(LocaleUtil.LOCALE_RU));
        tNUMBER_FORMATS.put(LocaleUtil.LOCALE_UK, NumberFormat.getInstance(LocaleUtil.LOCALE_RU));
        tNUMBER_FORMATS.put(LocaleUtil.LOCALE_BG, NumberFormat.getInstance(LocaleUtil.LOCALE_RU));
        tNUMBER_FORMATS.put(LocaleUtil.LOCALE_AZ, NumberFormat.getInstance(LocaleUtil.LOCALE_RU));
        tNUMBER_FORMATS.put(LocaleUtil.LOCALE_KA, NumberFormat.getInstance(LocaleUtil.LOCALE_RU));
        tNUMBER_FORMATS.put(LocaleUtil.LOCALE_HY, NumberFormat.getInstance(LocaleUtil.LOCALE_RU));
        tNUMBER_FORMATS.put(LocaleUtil.LOCALE_EN, NumberFormat.getInstance(LocaleUtil.LOCALE_RU));
        NUMBER_FORMATS = Collections.unmodifiableMap(tNUMBER_FORMATS);
    }
}

