/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.cabinet;

import com.gridnine.xtrip.common.ibecorp.exception.RankedXeption;
import com.gridnine.xtrip.common.ibecorp.exception.XeptionSeverity;
import com.gridnine.xtrip.common.ibecorp.rules.PersonProfileValidationActionsSet;
import com.gridnine.xtrip.common.ibecorp.rzd.RzdCommonHelper;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.asset.AssetsStorage;
import com.gridnine.xtrip.common.model.assets.UserAccount;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.PassportType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonEmployment;
import com.gridnine.xtrip.common.model.profile.PersonIndex;
import com.gridnine.xtrip.common.model.restriction.resource.ModelRestrictionEntityResources;
import com.gridnine.xtrip.common.model.rules.TransliterationType;
import com.gridnine.xtrip.common.model.system.StandardValidationMessages;
import com.gridnine.xtrip.common.model.validation.ValidationMessage;
import com.gridnine.xtrip.common.restriction.resource.RestrictionResourceProxy;
import com.gridnine.xtrip.common.restriction.resource.standard.StandardRestrictionResourceOperations;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.user.UserData;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.booking.RestBookingHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.Employee;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.EmployeeOrganizationInfo;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.EmployeeValidationMessanges;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.SystemAccess;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.SystemAccessValidationMessages;
import com.gridnine.xtrip.server.ibecorp.common.CommonHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.CommonValidationHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.BonusCard;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.BonusCardValidationMessages;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.PassportValidationMessages;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.RestPassport;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.cabinet.PersonValidationMessages;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.cabinet.RestPerson;
import com.gridnine.xtrip.server.ibecorp.common.rest.rail.model.RailBonusCard;
import com.gridnine.xtrip.server.ibecorp.helpers.IbecorpRulesHelper;
import com.gridnine.xtrip.server.ibecorp.security.acl.IbePermissionManager;
import com.gridnine.xtrip.server.restriction.helper.RestrictionsHelper;
import com.gridnine.xtrip.server.security.acl.helper.AclHelper;
import java.time.LocalDate;
import java.time.Period;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;

public class CabinetValidationHelper {
    private static final Pattern loginPattern = Pattern.compile("[-_a-zA-Z0-9]+");
    private static Set<PassportType> MANDATORY_CYR_DOC_TYPES = EnumSet.of(PassportType.INTERNAL);
    private static Set<PassportType> MANDATORY_LAT_DOC_TYPES = EnumSet.of(PassportType.FOREIGN);

    public static void validateCabinetHolder(Employee holder, SalesContext salesContext, Person curUser) throws Exception {
        CabinetValidationHelper.validatePerson((RestPerson)holder, salesContext, curUser);
        CabinetValidationHelper.validateEmployeeEmail(holder);
        CabinetValidationHelper.validateEmployeePassword(holder);
    }

    public static void validateEmployee(Employee employee, SalesContext salesContext, EntityContainer<Person> personCtr, Person curUser) throws Exception {
        boolean personEditGranted;
        Map aclProxyMap;
        Map map = aclProxyMap = personCtr == null ? null : RestrictionsHelper.buildProxies(personCtr, (String)ModelRestrictionEntityResources.ENTITY_PERSON.getId());
        if (aclProxyMap != null && !(personEditGranted = IbePermissionManager.isEntityGranted(personCtr, aclProxyMap, StandardRestrictionResourceOperations.EDIT))) {
            throw Xeption.forDeveloper((String)"Person edit is not granted", (Object[])new Object[0]);
        }
        CabinetValidationHelper.validateEmployeeOrganizationInfo(employee, personCtr, aclProxyMap);
        CabinetValidationHelper.validatePerson((RestPerson)employee, salesContext, curUser);
        CabinetValidationHelper.validateEmployeePassword(employee);
    }

    public static void systemAccessCreateValidation(Employee employee) {
        SystemAccess access = employee.getSystemAccess();
        if (StringUtils.isBlank((String)access.getLogin()) && StringUtils.isBlank((String)access.getPassword())) {
            return;
        }
        if (StringUtils.isBlank((String)access.getLogin())) {
            access.getValidationContext().getLoginValidationMessages().add(SystemAccessValidationMessages.getMissingLogin());
        } else {
            if (!loginPattern.matcher(access.getLogin()).matches()) {
                access.getValidationContext().getLoginValidationMessages().add(SystemAccessValidationMessages.getIllegalLogin());
            }
            if (AssetsStorage.get().find(UserAccount.class, UserAccount.Property.loginName.name(), (Object)access.getLogin()) != null) {
                access.getValidationContext().getLoginValidationMessages().add(SystemAccessValidationMessages.getExistingLogin());
            }
        }
        if (StringUtils.isBlank((String)access.getPassword())) {
            access.getValidationContext().getPasswordValidationMessages().add(SystemAccessValidationMessages.getMissingPassword());
        }
        CabinetValidationHelper.validateEmployeePassword(employee);
        CabinetValidationHelper.validateEmployeeEmail(employee);
    }

    private static void validateEmployeePassword(Employee employee) {
        SystemAccess access = employee.getSystemAccess();
        if (access == null || StringUtils.isBlank((String)employee.getSystemAccess().getPassword())) {
            return;
        }
        CommonValidationHelper.validatePasswordPolicy(access.getPassword(), access.getValidationContext().getPasswordValidationMessages());
    }

    public static void validateEmployeeEmail(Employee employee) {
        if (employee.getEmails().isEmpty() || employee.getEmails().stream().anyMatch(TextUtil::isBlank)) {
            employee.getValidationContext().getEmailsListValidationMessages().put(0, Collections.singletonList(PersonValidationMessages.getEmptyEmail()));
        }
    }

    private static void validateEmployeeOrganizationInfo(Employee employee, EntityContainer<Person> personCtr, Map<String, RestrictionResourceProxy> aclProxyMap) throws Exception {
        List organizationInfos = employee.getOrganizationInfos();
        if (organizationInfos.stream().noneMatch(EmployeeOrganizationInfo::isMainEmployment)) {
            organizationInfos.forEach(i -> i.getValidationContext().getOrganizationValidationMessages().add(EmployeeValidationMessanges.getMissingMainEmployment()));
            return;
        }
        if (organizationInfos.stream().anyMatch(o -> o.getOrganization() == null)) {
            organizationInfos.stream().filter(o -> o.getOrganization() == null).forEach(or -> or.getValidationContext().getOrganizationValidationMessages().add(EmployeeValidationMessanges.getMissingEmployment()));
            return;
        }
        String currentLogin = UserData.get().getCurrentUser();
        for (EmployeeOrganizationInfo info : organizationInfos) {
            boolean viewGranted;
            RestrictionResourceProxy aclProxy;
            boolean editGranted;
            PersonEmployment employment;
            if (personCtr != null && (employment = (PersonEmployment)((Person)personCtr.getEntity()).getEmployments().stream().filter(pe -> MiscUtil.equals((Object)pe.getOrganization(), (Object)info.getOrganization())).findFirst().orElse(null)) != null && (!(editGranted = AclHelper.isGranted((RestrictionResourceProxy)(aclProxy = aclProxyMap.get(employment.getUid())), (String)ModelRestrictionEntityResources.ENTITY_PERSON_EMPLOYMENT.getId(), (String)currentLogin, (String)StandardRestrictionResourceOperations.EDIT.getId(), Collections.emptyList())) || !(viewGranted = AclHelper.isGranted((RestrictionResourceProxy)aclProxy, (String)ModelRestrictionEntityResources.ENTITY_PERSON_EMPLOYMENT.getId(), (String)currentLogin, (String)StandardRestrictionResourceOperations.VIEW.getId(), Collections.emptyList())))) continue;
            EntityContainer orgCtr = EntityStorage.get().resolve(info.getOrganization());
            Organization org = (Organization)orgCtr.getEntity();
            if (!org.getEmployeeCategories().isEmpty() && info.getEmployeeCategoryInfo() == null) {
                info.getValidationContext().getEmployeeCategoryInfoValidationMessages().add(EmployeeValidationMessanges.getMissingEmployeeCategory());
            }
            if (info.isMainEmployment() && employee.getSystemAccess() != null && !StringUtils.isBlank((String)employee.getSystemAccess().getLogin()) && !org.getAclSettings().getOrganizationAclRoles().isEmpty() && info.getRole() == null) {
                info.getValidationContext().getRoleValidationMessages().add(EmployeeValidationMessanges.getRoleNotSelected());
            }
            if (info.getOrganization() == null) {
                info.getValidationContext().getOrganizationValidationMessages().add(EmployeeValidationMessanges.getMissingOrganization());
            }
            RestBookingHelper.validateRestEmployeeCodeCodes(info.getCostCodesInfo(), org);
        }
    }

    public static void validatePerson(RestPerson person, SalesContext salesContext, Person curUser) throws Exception {
        PersonProfileValidationActionsSet personProfileValidationActions;
        if (person.isDisabled()) {
            throw RankedXeption.forEndUser((XeptionSeverity)XeptionSeverity.ERROR, (String)"PERSON_IS_DISABLED", (Object[])new Object[0]);
        }
        CabinetValidationHelper.validatePersonNames(person);
        person.getValidationContext().getBirthDateValidationMessages().addAll(CabinetValidationHelper.isValidBirthDate(person.getBirthDate()));
        person.getPassports().forEach(pass -> CabinetValidationHelper.validatePassport(pass, person));
        if (person.getGender() == null) {
            person.getValidationContext().getGenderValidationMessages().add(com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.PersonValidationMessages.getMissingGender());
        }
        if ((personProfileValidationActions = IbecorpRulesHelper.getPersonProfileValidationActions(curUser, salesContext)).isEmailMandatory() && person.getEmails().isEmpty()) {
            person.getValidationContext().getEmailsValidationMessages().add(PersonValidationMessages.getEmptyEmail());
        }
        for (String email : person.getEmails()) {
            HashSet<ValidationMessage> emailMessages = new HashSet<ValidationMessage>();
            if (TextUtil.isBlank((String)email)) {
                if (personProfileValidationActions.isEmailMandatory()) {
                    emailMessages.add(PersonValidationMessages.getEmptyEmail());
                }
            } else if (!CommonValidationHelper.isValidEmailFormat(email)) {
                emailMessages.add(PersonValidationMessages.getInvalidEmail());
            } else if (personProfileValidationActions.isCheckUniqueEmail() && CabinetValidationHelper.isDuplicateEmail(email, person)) {
                emailMessages.add(PassportValidationMessages.getFoundEmailDuplicate());
            }
            if (emailMessages.isEmpty()) continue;
            person.getValidationContext().getEmailsListValidationMessages().put(person.getEmails().indexOf(email), emailMessages);
        }
        person.getPhones().stream().filter(phone -> !CommonHelper.isEmpty(phone) && !CommonValidationHelper.isValidPhone(phone, new ArrayList<ValidationMessage>())).forEach(phone -> {
            Collection cfr_ignored_0 = person.getValidationContext().getPhonesListValidationMessages().put(person.getPhones().indexOf(phone), Collections.singleton(PersonValidationMessages.getInvalidPhone()));
        });
        person.getAirlineBonusCards().forEach(CabinetValidationHelper::validateBonusCard);
        person.getRailwayBonusCards().forEach(CabinetValidationHelper::validateRailwayBonusCard);
        boolean isKzCitizenship = person.getPassports().stream().map(RestPassport::getCitizenship).filter(Objects::nonNull).anyMatch(RzdCommonHelper::isKzCitizenship);
        CommonValidationHelper.validatePersonIin(person.getIIN(), isKzCitizenship, person.getValidationContext().getIINValidationMessages());
    }

    private static void validatePassport(RestPassport passport, RestPerson person) {
        RestPassport.RestPassportValidationContext validationContext = passport.getValidationContext();
        CabinetValidationHelper.validatePassportNames(passport);
        if (Objects.isNull(passport.getCitizenship())) {
            validationContext.getCitizenshipValidationMessages().add(PassportValidationMessages.getMissingCitizenship());
        }
        if (Objects.isNull(passport.getOriginCountry())) {
            validationContext.getOriginCountryValidationMessages().add(PassportValidationMessages.getMissingOrigin());
        }
        if (Objects.isNull(passport.getType())) {
            validationContext.getTypeValidationMessages().add(PassportValidationMessages.getMissingPassportType());
        }
        CabinetValidationHelper.isValidPassportExpiredDate(passport.getExpiredDate(), person.getBirthDate(), passport.getValidationContext().getExpiredDateValidationMessages(), CabinetValidationHelper.isCalculateExpiredDate(passport.getType()));
        CabinetValidationHelper.isValidPassportNumber(passport);
        CommonValidationHelper.isValidPassportType(passport.getType(), (DictionaryReference<Country>)passport.getCitizenship(), validationContext.getTypeValidationMessages());
        CabinetValidationHelper.isDuplicatePassport(passport, person);
    }

    private static void isValidPassportNumber(RestPassport passport) {
        if (CommonValidationHelper.isMissingPassportNumber(passport.getNumber(), passport.getValidationContext().getNumberValidationMessages())) {
            return;
        }
        CommonValidationHelper.isIllegalPassportNumber(passport.getType(), passport.getNumber(), passport.getValidationContext().getNumberValidationMessages());
    }

    private static void isDuplicatePassport(RestPassport passport, RestPerson person) {
        if (TextUtil.isBlank((String)passport.getNumber())) {
            return;
        }
        SearchQuery query = new SearchQuery();
        if (CabinetValidationHelper.isInfantOrChild(MiscUtil.toDate((LocalDate)person.getBirthDate()))) {
            return;
        }
        query.getCriteria().getCriterions().add(SearchCriterion.contains((String)PersonIndex.Property.passportNumbers.name(), (Object)passport.getNumber()));
        query.getCriteria().getCriterions().add(SearchCriterion.ne((String)"containerUid", (Object)person.getUid()));
        List personsWithSamePassportNumbers = EntityStorage.get().search(PersonIndex.class, query).getData();
        if (personsWithSamePassportNumbers.stream().anyMatch(p -> !CabinetValidationHelper.isInfantOrChild(p.getBirthday()))) {
            passport.getValidationContext().getNumberValidationMessages().add(PassportValidationMessages.getFoundDuplicate());
        }
    }

    private static boolean isDuplicateEmail(String email, RestPerson person) {
        if (TextUtil.isBlank((String)email)) {
            return false;
        }
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.icontains((String)PersonIndex.Property.emails.name(), (String)email));
        query.getCriteria().getCriterions().add(SearchCriterion.ne((String)"containerUid", (Object)person.getUid()));
        query.getPreferredProperties().add(PersonIndex.Property.name.name());
        query.setLimit(1);
        List personsWithSameEmail = EntityStorage.get().search(PersonIndex.class, query).getData();
        return !personsWithSameEmail.isEmpty();
    }

    private static boolean isInfantOrChild(Date birthday) {
        return ProfileHelper.isDateInfant((Date)birthday) || ProfileHelper.isDateChild((Date)birthday);
    }

    private static void validatePersonNames(RestPerson person) {
        CommonValidationHelper.isValidName(person.getFirstNameLat(), true, TransliterationType.LATIN, person.getValidationContext().getFirstNameLatValidationMessages());
        CommonValidationHelper.isValidName(person.getFirstName(), false, TransliterationType.CYRILLIC, person.getValidationContext().getFirstNameValidationMessages());
        CommonValidationHelper.isValidName(person.getSecondNameLat(), false, TransliterationType.LATIN, person.getValidationContext().getSecondNameLatValidationMessages());
        CommonValidationHelper.isValidName(person.getSecondName(), false, TransliterationType.CYRILLIC, person.getValidationContext().getSecondNameValidationMessages());
        CommonValidationHelper.isValidName(person.getLastNameLat(), true, TransliterationType.LATIN, person.getValidationContext().getLastNameLatValidationMessages());
        CommonValidationHelper.isValidName(person.getLastName(), false, TransliterationType.CYRILLIC, person.getValidationContext().getLastNameValidationMessages());
        if (!person.isWithoutMiddleName()) {
            CommonValidationHelper.isValidName(person.getMiddleNameLat(), true, TransliterationType.LATIN, person.getValidationContext().getMiddleNameLatValidationMessages());
            CommonValidationHelper.isValidName(person.getMiddleName(), false, TransliterationType.CYRILLIC, person.getValidationContext().getMiddleNameValidationMessages());
        }
    }

    private static void validatePassportNames(RestPassport passport) {
        boolean isCyrMandatory = MANDATORY_CYR_DOC_TYPES.contains(passport.getType());
        boolean isLatMandatory = MANDATORY_LAT_DOC_TYPES.contains(passport.getType());
        if (!isCyrMandatory && !isLatMandatory) {
            boolean cyrFilled = Stream.of(passport.getFirstName(), passport.getLastName()).anyMatch(TextUtil::nonBlank);
            boolean latFilled = Stream.of(passport.getFirstNameLat(), passport.getLastNameLat()).anyMatch(TextUtil::nonBlank);
            if (!cyrFilled && !latFilled) {
                passport.getValidationContext().getLastNameValidationMessages().add(PassportValidationMessages.getMissingLatinAndCyrillicNames());
                passport.getValidationContext().getLastNameLatValidationMessages().add(PassportValidationMessages.getMissingLatinAndCyrillicNames());
            } else {
                if (cyrFilled) {
                    isCyrMandatory = true;
                }
                if (latFilled) {
                    isLatMandatory = true;
                }
            }
        }
        CommonValidationHelper.isValidName(passport.getFirstName(), isCyrMandatory, TransliterationType.CYRILLIC, passport.getValidationContext().getFirstNameValidationMessages());
        CommonValidationHelper.isValidName(passport.getFirstNameLat(), isLatMandatory, TransliterationType.LATIN, passport.getValidationContext().getFirstNameLatValidationMessages());
        CommonValidationHelper.isValidName(passport.getSecondName(), false, TransliterationType.CYRILLIC, passport.getValidationContext().getSecondNameValidationMessages());
        CommonValidationHelper.isValidName(passport.getSecondNameLat(), false, TransliterationType.LATIN, passport.getValidationContext().getSecondNameLatValidationMessages());
        CommonValidationHelper.isValidName(passport.getLastName(), isCyrMandatory, TransliterationType.CYRILLIC, passport.getValidationContext().getLastNameValidationMessages());
        CommonValidationHelper.isValidName(passport.getLastNameLat(), isLatMandatory, TransliterationType.LATIN, passport.getValidationContext().getLastNameLatValidationMessages());
        if (passport.isWithoutMiddleName()) {
            if (TextUtil.nonBlank((String)passport.getMiddleName())) {
                throw Xeption.forDeveloper((String)"invalid params: withoutMiddleName=true when middleName exists", (Object[])new Object[0]);
            }
        } else {
            CommonValidationHelper.isValidName(passport.getMiddleName(), isCyrMandatory, TransliterationType.CYRILLIC, passport.getValidationContext().getMiddleNameValidationMessages());
        }
        if (passport.isWithoutMiddleNameLat()) {
            if (TextUtil.nonBlank((String)passport.getMiddleNameLat())) {
                throw Xeption.forDeveloper((String)"invalid params: withoutMiddleNameLat=true when middleNameLat exists", (Object[])new Object[0]);
            }
        } else {
            CommonValidationHelper.isValidName(passport.getMiddleNameLat(), isLatMandatory, TransliterationType.LATIN, passport.getValidationContext().getMiddleNameLatValidationMessages());
        }
    }

    private static Collection<ValidationMessage> isValidBirthDate(LocalDate date) {
        ArrayList<ValidationMessage> validationMessages = new ArrayList<ValidationMessage>();
        if (Objects.isNull(date)) {
            validationMessages.add(com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.PersonValidationMessages.getMissingBirthDate());
            return validationMessages;
        }
        Period period = Period.between(date, LocalDate.now());
        int age = period.getYears();
        if (age < 0 || age > 150 || period.getDays() < 0) {
            validationMessages.add(com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.PersonValidationMessages.getIllegalBirthDate());
        }
        return validationMessages;
    }

    private static boolean isCalculateExpiredDate(PassportType passportType) {
        return passportType == PassportType.INTERNAL;
    }

    private static void isValidPassportExpiredDate(LocalDate expiredDate, LocalDate birthDate, Collection<ValidationMessage> expiredDateValidationMessages, boolean isCalculatedDate) {
        if (Objects.isNull(expiredDate)) {
            expiredDateValidationMessages.add(PassportValidationMessages.getMissingPassportExpired());
            return;
        }
        if (isCalculatedDate && !CabinetValidationHelper.isExpiredDateCalculatedCorrectly(expiredDate, birthDate)) {
            expiredDateValidationMessages.add(PassportValidationMessages.getIncorrectlyCalculatedExpirationDate());
        }
    }

    private static void validateBonusCard(BonusCard bonusCard) {
        if (Objects.isNull(bonusCard.getAirline())) {
            bonusCard.getValidationContext().getAirlineValidationMessages().add(BonusCardValidationMessages.getMissingBonusCardAirline());
        }
        if (TextUtil.isBlank((String)bonusCard.getNameOnCard())) {
            bonusCard.getValidationContext().getNameOnCardValidationMessages().add(StandardValidationMessages.getMissingRequiredValue());
        }
        if (StringUtils.isBlank((String)bonusCard.getNumber())) {
            bonusCard.getValidationContext().getNumberValidationMessages().add(BonusCardValidationMessages.getMissingBonusCardNumber());
        }
    }

    private static void validateRailwayBonusCard(RailBonusCard railBonusCard) {
        if (StringUtils.isBlank((String)railBonusCard.getNumber())) {
            railBonusCard.getValidationContext().getNumberValidationMessages().add(BonusCardValidationMessages.getMissingBonusCardNumber());
        }
    }

    private static boolean isExpiredDateCalculatedCorrectly(LocalDate expiredDate, LocalDate birthDate) {
        Period period = Period.between(birthDate, LocalDate.now());
        int age = period.getYears();
        if (age < 20) {
            return expiredDate.equals(birthDate.plusYears(20L).plusDays(40L));
        }
        if (age < 45) {
            return expiredDate.equals(birthDate.plusYears(45L).plusDays(40L));
        }
        return expiredDate.equals(birthDate.plusYears(120L).plusDays(40L));
    }
}

