/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.cabinet;

import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.restriction.RestrictionIdentity;
import com.gridnine.xtrip.common.restriction.resource.RestrictionResourceOperation;
import com.gridnine.xtrip.server.ibecorp.l10n.Messages;
import com.gridnine.xtrip.server.ibus.IbusConfigurationHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.security.acl.helper.AclHelper;
import java.util.Collections;
import java.util.Map;

public class CheckAccessPermission
extends BaseProcessor {
    private RestrictionIdentity restrictionIdentity;
    private RestrictionResourceOperation restrictionResourceOperation;

    public void configure(Map<String, String> parameters) {
        try {
            String restriction = IbusConfigurationHelper.getMandatoryParameter(parameters, (String)"restriction");
            String restrictionEnumItem = IbusConfigurationHelper.getMandatoryParameter(parameters, (String)"restriction-enum-item");
            String operation = IbusConfigurationHelper.getMandatoryParameter(parameters, (String)"operation");
            String operationEnumItem = IbusConfigurationHelper.getMandatoryParameter(parameters, (String)"operation-enum-item");
            this.restrictionIdentity = (RestrictionIdentity)Enum.valueOf(Class.forName(restriction), restrictionEnumItem);
            this.restrictionResourceOperation = (RestrictionResourceOperation)Enum.valueOf(Class.forName(operation), operationEnumItem);
        }
        catch (Throwable throwable) {
            throw Xeption.forDeveloper((String)"error config", (Throwable)throwable, (Object[])new Object[0]);
        }
    }

    public void process(MessageContext ctx) throws Exception {
        EntityReference userRef = (EntityReference)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.AUTHORIZED_USER);
        String grantedLogin = ((Person)EntityStorage.get().resolve(userRef).getEntity()).getLoginName();
        boolean granted = AclHelper.isGranted(null, (String)this.restrictionIdentity.getId(), (String)grantedLogin, (String)this.restrictionResourceOperation.getId(), Collections.emptyList());
        if (!granted) {
            throw Xeption.forEndUser((String)Messages.ACCESS_DENIED, (Object[])new Object[0]);
        }
    }
}

