/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.cabinet;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.ibecorp.rzd.RzdCommonHelper;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.booking.railway.RailwaySegment;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.RailProxy;
import com.gridnine.xtrip.server.ibecorp.common.rest.rail.IBusIbecorpRailContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.IBusRailwayContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.joda.time.DateTime;

public class CommonRailProxyConverter
extends BaseProcessor {
    private Class<? extends RailProxy> clazz;
    private static final String clazzName = "clazz";

    public void configure(Map<String, String> parameters) {
        super.configure(parameters);
        try {
            this.clazz = Class.forName(parameters.get(clazzName));
        }
        catch (ClassNotFoundException e) {
            throw Xeption.forDeveloper((String)"no RailProxy Class Find", (Object[])new Object[0]);
        }
    }

    public void process(MessageContext ctx) throws Exception {
        List products = (List)ctx.getMandatoryObject((Enum)IBusRailwayContextKeys.RAILWAY_PRODUCTS);
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        RailProxy railProxy = this.clazz.newInstance();
        this.fillCommonInfo(reservation, railProxy);
        this.fillTrainInfo(reservation, CollectionUtil.getUids((Collection)products), railProxy);
        ctx.putObject((Enum)IBusIbecorpRailContextKeys.REST_PROXY, (Object)railProxy);
    }

    private void fillCommonInfo(Reservation reservation, RailProxy railProxy) throws Exception {
        railProxy.setOrderNumber(reservation.getBookingFile().getNumber());
        railProxy.setTransactionNumber(CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)reservation));
        railProxy.setProductNumber(this.getProductNumber(reservation));
        railProxy.setOrderDate(this.getOrderDate(reservation));
    }

    private void fillTrainInfo(Reservation reservation, List<String> refundUids, RailProxy railProxy) {
        RailwayProduct railwayProduct = RzdCommonHelper.getProductByUid((Reservation)reservation, (String)refundUids.get(0));
        RailwaySegment railwaySegment = RzdCommonHelper.getSegment((RailwayProduct)railwayProduct);
        Locale locale = LocaleManager.get().getCurrentLocale();
        railProxy.setTrainNumber(RzdCommonHelper.calcFullTrainNumber((RailwaySegment)railwaySegment));
        railProxy.setTrainRoute(String.format("%1$s - %2$s", RzdCommonHelper.formatRailwayFullName((DictionaryReference)railwaySegment.getDepartureStation(), (Locale)locale), RzdCommonHelper.formatRailwayFullName((DictionaryReference)railwaySegment.getArriveStation(), (Locale)locale)));
        railProxy.setDepartureDate(new DateTime(railwaySegment.getDepartureDate().getTime()));
        railProxy.setArrivalDate(new DateTime(railwaySegment.getArriveDate().getTime()));
        railProxy.setCarriageInfo(RzdCommonHelper.getCarInfo((RailwaySegment)railwaySegment, (Locale)locale));
        railProxy.setSeatInfo(this.getSeatInfo(reservation, refundUids, railwaySegment, locale));
        railProxy.setTimeInfo(railwaySegment.getTimeInfo());
        if (railwayProduct.getWithBedding() != null) {
            railProxy.setAdditionalInfo(CommonRailProxyConverter.getAdditionInfo(railwayProduct.getWithBedding(), locale));
        }
    }

    private String getSeatInfo(Reservation reservation, List<String> uids, RailwaySegment railwaySegment, Locale locale) {
        if (CollectionUtil.isEmpty(uids)) {
            return null;
        }
        Map<String, Set<String>> productPlaces = CommonRailProxyConverter.getProductPlaces(reservation);
        HashSet places = new HashSet();
        for (Map.Entry<String, Set<String>> entry : productPlaces.entrySet()) {
            if (!uids.contains(entry.getKey())) continue;
            places.addAll(entry.getValue());
        }
        StringBuilder sb = new StringBuilder();
        sb.append(RzdCommonHelper.convertPlacesSet(places));
        if (railwaySegment.getCompartmentType() != null) {
            sb.append(" ");
            sb.append(RzdCommonHelper.getLocaleCaption((Enum)railwaySegment.getCompartmentType(), (Locale)locale));
        }
        return sb.toString();
    }

    public static Map<String, Set<String>> getProductPlaces(Reservation reservation) {
        HashMap<String, Set<String>> productPlaces = new HashMap<String, Set<String>>();
        for (BaseProduct bp : reservation.getProducts()) {
            if (!(bp instanceof RailwayProduct)) continue;
            RailwayProduct rp = (RailwayProduct)bp;
            productPlaces.put(rp.getUid(), CommonRailProxyConverter.getProductPlaces(rp));
        }
        return productPlaces;
    }

    public static Set<String> getProductPlaces(RailwayProduct product) {
        HashSet<String> result = new HashSet<String>();
        for (RailwaySegment segment : product.getSegments()) {
            result.addAll(segment.getPlaces());
        }
        return result;
    }

    private String getProductNumber(Reservation reservation) throws Exception {
        return RzdCommonHelper.getOrderNumber((Reservation)reservation);
    }

    private DateTime getOrderDate(Reservation reservation) throws Exception {
        return new DateTime(reservation.getBookingFile().getCreateDate().getTime());
    }

    private static String getAdditionInfo(boolean withBedding, Locale locale) {
        return LocaleManager.get().getL10nResourceManager().getMessage(locale, withBedding ? "IBECORP_RAIL_PLACE_IN_CARRIGE_WITH_LINEN" : "IBECORP_RAIL_PLACE_IN_CARRIGE_WITHOUT_LINEN", new Object[0]);
    }
}

