/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.cabinet;

import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.PassengerTypeCategory;
import com.gridnine.xtrip.common.model.booking.PassengerTypeCategoryReference;
import com.gridnine.xtrip.common.model.booking.PassengerTypeReference;
import com.gridnine.xtrip.common.model.booking.ReservationType;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.ClassOfService;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.PassengerStatus;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.dict.WeekDay;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.profile.Branch;
import com.gridnine.xtrip.common.model.profile.BranchIndex;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.profile.SalesPointIndex;
import com.gridnine.xtrip.common.model.rules.standard.RulesHelper;
import com.gridnine.xtrip.common.model.system.CardVendor;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.DateInterval;
import com.gridnine.xtrip.common.util.Predicates;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.cabinet.CabinetConverterHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.cabinet.RuleRestrictionValueRenderer;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.renderer.BaseRuleRestrictionValue;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.renderer.NumberRuleRestrictionValue;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.renderer.RenderedItem;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.renderer.RuleRestrictionUpdatedValue;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.renderer.SelectRestrictionValue;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.joda.time.LocalDate;
import org.joda.time.LocalTime;

public enum RestrictionValueConverter {
    GDS_NAME{

        @Override
        BaseRuleRestrictionValue convertValue2Rest(Object object) {
            return this.getRenderer().renderValue(CabinetConverterHelper.convertEnumListValue2RenderedItems((List)object));
        }

        @Override
        List<GdsName> convertRest2Value(RuleRestrictionUpdatedValue restrictionUpdatedValue) {
            return CabinetConverterHelper.convertRenderedItems2EnumListValue((List)this.getRenderer().unrenderValue(restrictionUpdatedValue), GdsName.class);
        }

        @Override
        RuleRestrictionValueRenderer getRenderer() {
            return RuleRestrictionValueRenderer.MULTISELECT;
        }

        @Override
        public BaseRuleRestrictionValue convertBaseValues2Rest() {
            return this.getRenderer().renderBaseValues(CabinetConverterHelper.convertEnumListValue2RenderedItems((Enum[])GdsName.values()));
        }
    }
    ,
    NUMBER{

        NumberRuleRestrictionValue convertValue2Rest(Object object) {
            return (NumberRuleRestrictionValue)this.getRenderer().renderValue(object);
        }

        @Override
        Double convertRest2Value(RuleRestrictionUpdatedValue restrictionUpdatedValue) {
            return (Double)this.getRenderer().unrenderValue(restrictionUpdatedValue);
        }

        @Override
        RuleRestrictionValueRenderer getRenderer() {
            return RuleRestrictionValueRenderer.NUMBER_FIELD;
        }

        @Override
        public BaseRuleRestrictionValue convertBaseValues2Rest() {
            return this.getRenderer().renderBaseValues(Collections.emptyList());
        }
    }
    ,
    YES_NO{

        @Override
        BaseRuleRestrictionValue convertValue2Rest(Object object) {
            return this.getRenderer().renderValue(CabinetConverterHelper.convertBoolean2RenderedItem((Boolean)object));
        }

        @Override
        Boolean convertRest2Value(RuleRestrictionUpdatedValue restrictionUpdatedValue) {
            return CabinetConverterHelper.convertRenderedItem2Boolean((RenderedItem)this.getRenderer().unrenderValue(restrictionUpdatedValue));
        }

        @Override
        RuleRestrictionValueRenderer getRenderer() {
            return RuleRestrictionValueRenderer.COMBO;
        }

        @Override
        public BaseRuleRestrictionValue convertBaseValues2Rest() {
            return this.getRenderer().renderBaseValues(Arrays.asList(CabinetConverterHelper.convertBoolean2RenderedItem(Boolean.TRUE), CabinetConverterHelper.convertBoolean2RenderedItem(Boolean.FALSE)));
        }
    }
    ,
    MCO_CATEGORY{

        SelectRestrictionValue convertValue2Rest(Object object) {
            return (SelectRestrictionValue)this.getRenderer().renderValue(CabinetConverterHelper.convertEnum2RenderedItem((Enum)object));
        }

        MCOCategory convertRest2Value(RuleRestrictionUpdatedValue restrictionUpdatedValue) {
            return CabinetConverterHelper.convertRenderedItem2Enum((RenderedItem)this.getRenderer().unrenderValue(restrictionUpdatedValue), MCOCategory.class);
        }

        @Override
        RuleRestrictionValueRenderer getRenderer() {
            return RuleRestrictionValueRenderer.SELECT;
        }

        @Override
        public BaseRuleRestrictionValue convertBaseValues2Rest() {
            return this.getRenderer().renderBaseValues(CabinetConverterHelper.convertEnumListValue2RenderedItems((Enum[])MCOCategory.values()));
        }
    }
    ,
    STRING_LIST{

        @Override
        BaseRuleRestrictionValue convertValue2Rest(Object object) {
            return this.getRenderer().renderValue(RulesHelper.toString((Object)object));
        }

        @Override
        List<String> convertRest2Value(RuleRestrictionUpdatedValue restrictionUpdatedValue) {
            return RulesHelper.toStringCollection((Object)this.getRenderer().unrenderValue(restrictionUpdatedValue));
        }

        @Override
        RuleRestrictionValueRenderer getRenderer() {
            return RuleRestrictionValueRenderer.TEXT_FIELD;
        }

        @Override
        public BaseRuleRestrictionValue convertBaseValues2Rest() {
            return this.getRenderer().renderBaseValues(Collections.emptyList());
        }
    }
    ,
    TIME_INTERVAL{

        @Override
        BaseRuleRestrictionValue convertValue2Rest(Object object) {
            DateInterval dateInterval = (DateInterval)object;
            return this.getRenderer().renderValue(Arrays.asList(this.toLocalTime(dateInterval.getBeginDate()), this.toLocalTime(dateInterval.getEndDate())));
        }

        DateInterval convertRest2Value(RuleRestrictionUpdatedValue restrictionUpdatedValue) {
            return this.toDateInterval((List)this.getRenderer().unrenderValue(restrictionUpdatedValue));
        }

        @Override
        RuleRestrictionValueRenderer getRenderer() {
            return RuleRestrictionValueRenderer.TIME_INTERVAL_FIELDS;
        }

        @Override
        public BaseRuleRestrictionValue convertBaseValues2Rest() {
            return this.getRenderer().renderBaseValues(Arrays.asList(LocalTime.now(), LocalTime.now()));
        }

        DateInterval toDateInterval(List<LocalTime> localTimes) {
            return new DateInterval(this.toDate(localTimes.get(0)), this.toDate(localTimes.get(1)));
        }

        private Date toDate(LocalTime localTime) {
            return localTime.toDateTimeToday().toDate();
        }

        private LocalTime toLocalTime(Date date) {
            return new LocalTime((Object)date);
        }
    }
    ,
    NULL{

        @Override
        BaseRuleRestrictionValue convertValue2Rest(Object object) {
            return null;
        }

        @Override
        Object convertRest2Value(RuleRestrictionUpdatedValue restrictionUpdatedValue) {
            return null;
        }

        @Override
        RuleRestrictionValueRenderer getRenderer() {
            return null;
        }

        @Override
        public BaseRuleRestrictionValue convertBaseValues2Rest() {
            return null;
        }
    }
    ,
    DATE_INTERVAL{

        @Override
        BaseRuleRestrictionValue convertValue2Rest(Object object) {
            DateInterval dateInterval = (DateInterval)object;
            return this.getRenderer().renderValue(Arrays.asList(this.toLocalDate(dateInterval.getBeginDate()), this.toLocalDate(dateInterval.getEndDate())));
        }

        @Override
        Object convertRest2Value(RuleRestrictionUpdatedValue restrictionUpdatedValue) {
            return this.toDateInterval((List)restrictionUpdatedValue);
        }

        @Override
        RuleRestrictionValueRenderer getRenderer() {
            return RuleRestrictionValueRenderer.DATE_INTERVAL_FIELDS;
        }

        @Override
        public BaseRuleRestrictionValue convertBaseValues2Rest() {
            return this.getRenderer().renderBaseValues(Collections.emptyList());
        }

        DateInterval toDateInterval(List<LocalDate> localDates) {
            return new DateInterval(this.toDate(localDates.get(0)), this.toDate(localDates.get(1)));
        }

        private Date toDate(LocalDate localDate) {
            return localDate.toDate();
        }

        private LocalDate toLocalDate(Date date) {
            return new LocalDate((Object)date);
        }
    }
    ,
    WEEK_DAY{

        @Override
        BaseRuleRestrictionValue convertValue2Rest(Object object) {
            return this.getRenderer().renderValue(CabinetConverterHelper.convertEnumListValue2RenderedItems((List)object));
        }

        @Override
        List<WeekDay> convertRest2Value(RuleRestrictionUpdatedValue restrictionUpdatedValue) {
            return CabinetConverterHelper.convertRenderedItems2EnumListValue((List)this.getRenderer().unrenderValue(restrictionUpdatedValue), WeekDay.class);
        }

        @Override
        RuleRestrictionValueRenderer getRenderer() {
            return RuleRestrictionValueRenderer.MULTISELECT;
        }

        @Override
        public BaseRuleRestrictionValue convertBaseValues2Rest() {
            return this.getRenderer().renderBaseValues(CabinetConverterHelper.convertEnumListValue2RenderedItems((Enum[])WeekDay.values()));
        }
    }
    ,
    PRODUCT_CATEGORY{

        @Override
        BaseRuleRestrictionValue convertValue2Rest(Object object) {
            return this.getRenderer().renderValue(CabinetConverterHelper.convertEnum2RenderedItem((Enum)object));
        }

        ProductCategory convertRest2Value(RuleRestrictionUpdatedValue restrictionUpdatedValue) {
            return CabinetConverterHelper.convertRenderedItem2Enum(ProductCategory.class).apply((RenderedItem)this.getRenderer().unrenderValue(restrictionUpdatedValue));
        }

        @Override
        RuleRestrictionValueRenderer getRenderer() {
            return RuleRestrictionValueRenderer.SELECT;
        }

        @Override
        public BaseRuleRestrictionValue convertBaseValues2Rest() {
            return this.getRenderer().renderBaseValues(CabinetConverterHelper.convertEnumListValue2RenderedItems((Enum[])ProductCategory.values()));
        }
    }
    ,
    PASSENGER_TYPE_CATEGORY{

        @Override
        BaseRuleRestrictionValue convertValue2Rest(Object object) {
            return this.getRenderer().renderValue(CabinetConverterHelper.convertDictionaryReferencesToRenderedItems((List)object));
        }

        @Override
        List<PassengerTypeCategoryReference> convertRest2Value(RuleRestrictionUpdatedValue restrictionUpdatedValue) {
            return CabinetConverterHelper.convertRenderedItems2DictionaryReferences((List)this.getRenderer().renderValue(restrictionUpdatedValue), PassengerTypeCategory.class);
        }

        @Override
        RuleRestrictionValueRenderer getRenderer() {
            return RuleRestrictionValueRenderer.MULTISELECT;
        }

        @Override
        public BaseRuleRestrictionValue convertBaseValues2Rest() {
            return this.getRenderer().renderBaseValues(CabinetConverterHelper.convertDictionaryReferencesToRenderedItems(DictionaryCache.get().getAll(PassengerTypeCategory.class).values().stream().map(BaseDictionary::toReference).collect(Collectors.toList())));
        }
    }
    ,
    CLASS_OF_SERVICE{

        @Override
        BaseRuleRestrictionValue convertValue2Rest(Object object) {
            return this.getRenderer().renderValue(CabinetConverterHelper.convertEnumListValue2RenderedItems((List)object));
        }

        @Override
        List<ClassOfService> convertRest2Value(RuleRestrictionUpdatedValue restrictionUpdatedValue) {
            return CabinetConverterHelper.convertRenderedItems2EnumListValue((List)this.getRenderer().unrenderValue(restrictionUpdatedValue), ClassOfService.class);
        }

        @Override
        RuleRestrictionValueRenderer getRenderer() {
            return RuleRestrictionValueRenderer.MULTISELECT;
        }

        @Override
        public BaseRuleRestrictionValue convertBaseValues2Rest() {
            return this.getRenderer().renderBaseValues(CabinetConverterHelper.convertEnumListValue2RenderedItems((Enum[])ClassOfService.values()));
        }
    }
    ,
    STRING{

        @Override
        BaseRuleRestrictionValue convertValue2Rest(Object object) {
            return this.getRenderer().renderValue(object);
        }

        @Override
        String convertRest2Value(RuleRestrictionUpdatedValue restrictionUpdatedValue) {
            return (String)this.getRenderer().unrenderValue(restrictionUpdatedValue);
        }

        @Override
        RuleRestrictionValueRenderer getRenderer() {
            return RuleRestrictionValueRenderer.TEXT_FIELD;
        }

        @Override
        public BaseRuleRestrictionValue convertBaseValues2Rest() {
            return this.getRenderer().renderBaseValues(Collections.emptyList());
        }
    }
    ,
    PAYMENT_TYPES_LIST{

        @Override
        BaseRuleRestrictionValue convertValue2Rest(Object object) {
            return this.getRenderer().renderValue(CabinetConverterHelper.convertEnumListValue2RenderedItems((List)object));
        }

        @Override
        List<PaymentType> convertRest2Value(RuleRestrictionUpdatedValue restrictionUpdatedValue) {
            return CabinetConverterHelper.convertRenderedItems2EnumListValue((List)this.getRenderer().unrenderValue(restrictionUpdatedValue), PaymentType.class);
        }

        @Override
        RuleRestrictionValueRenderer getRenderer() {
            return RuleRestrictionValueRenderer.MULTISELECT;
        }

        @Override
        public BaseRuleRestrictionValue convertBaseValues2Rest() {
            return this.getRenderer().renderBaseValues(CabinetConverterHelper.convertEnumListValue2RenderedItems((Enum[])PaymentType.values()));
        }
    }
    ,
    BOOKING_CONTENT{

        @Override
        BaseRuleRestrictionValue convertValue2Rest(Object object) {
            return this.getRenderer().renderValue(CabinetConverterHelper.convertEnumListValue2RenderedItems((List)object));
        }

        @Override
        List<ProductType> convertRest2Value(RuleRestrictionUpdatedValue restrictionUpdatedValue) {
            return CabinetConverterHelper.convertRenderedItems2EnumListValue((List)this.getRenderer().unrenderValue(restrictionUpdatedValue), ProductType.class);
        }

        @Override
        RuleRestrictionValueRenderer getRenderer() {
            return RuleRestrictionValueRenderer.MULTISELECT;
        }

        @Override
        public BaseRuleRestrictionValue convertBaseValues2Rest() {
            return this.getRenderer().renderBaseValues(CabinetConverterHelper.convertEnumListValue2RenderedItems((Enum[])ProductType.values()));
        }
    }
    ,
    PASSENGER_STATUS{

        @Override
        BaseRuleRestrictionValue convertValue2Rest(Object object) {
            return this.getRenderer().renderValue(CabinetConverterHelper.convertEnumListValue2RenderedItems((List)object));
        }

        @Override
        List<PassengerStatus> convertRest2Value(RuleRestrictionUpdatedValue restrictionUpdatedValue) {
            return null;
        }

        @Override
        RuleRestrictionValueRenderer getRenderer() {
            return RuleRestrictionValueRenderer.MULTISELECT;
        }

        @Override
        public BaseRuleRestrictionValue convertBaseValues2Rest() {
            return this.getRenderer().renderBaseValues(CabinetConverterHelper.convertEnumListValue2RenderedItems((Enum[])PassengerStatus.values()));
        }
    }
    ,
    RESERVATION_TYPE{

        @Override
        BaseRuleRestrictionValue convertValue2Rest(Object object) {
            return this.getRenderer().renderValue(CabinetConverterHelper.convertEnumListValue2RenderedItems((List)object));
        }

        @Override
        List<ReservationType> convertRest2Value(RuleRestrictionUpdatedValue restrictionUpdatedValue) {
            return CabinetConverterHelper.convertRenderedItems2EnumListValue((List)this.getRenderer().unrenderValue(restrictionUpdatedValue), ReservationType.class);
        }

        @Override
        RuleRestrictionValueRenderer getRenderer() {
            return RuleRestrictionValueRenderer.MULTISELECT;
        }

        @Override
        public BaseRuleRestrictionValue convertBaseValues2Rest() {
            List<ReservationType> deprecatedTypes = Arrays.asList(ReservationType.CALL_CENTER, ReservationType.INTERNET);
            return this.getRenderer().renderBaseValues(CabinetConverterHelper.convertEnumListValue2RenderedItems(Arrays.stream(ReservationType.values()).filter(Predicates.not(deprecatedTypes::contains)).collect(Collectors.toList())));
        }
    }
    ,
    CREDIT_CARD_TYPE{

        @Override
        BaseRuleRestrictionValue convertValue2Rest(Object object) {
            return this.getRenderer().renderValue(CabinetConverterHelper.convertEnumListValue2RenderedItems((List)object));
        }

        @Override
        List<CardVendor> convertRest2Value(RuleRestrictionUpdatedValue restrictionUpdatedValue) {
            return CabinetConverterHelper.convertRenderedItems2EnumListValue((List)this.getRenderer().unrenderValue(restrictionUpdatedValue), CardVendor.class);
        }

        @Override
        RuleRestrictionValueRenderer getRenderer() {
            return RuleRestrictionValueRenderer.MULTISELECT;
        }

        @Override
        public BaseRuleRestrictionValue convertBaseValues2Rest() {
            return this.getRenderer().renderBaseValues(CabinetConverterHelper.convertEnumListValue2RenderedItems((Enum[])CardVendor.values()));
        }
    }
    ,
    PASSENGER_TYPE{

        @Override
        BaseRuleRestrictionValue convertValue2Rest(Object object) {
            return this.getRenderer().renderValue(CabinetConverterHelper.convertDictionaryReferencesToRenderedItems((List)object));
        }

        @Override
        List<PassengerTypeReference> convertRest2Value(RuleRestrictionUpdatedValue restrictionUpdatedValue) {
            return CabinetConverterHelper.convertRenderedItems2DictionaryReferences((List)this.getRenderer().unrenderValue(restrictionUpdatedValue), PassengerType.class);
        }

        @Override
        RuleRestrictionValueRenderer getRenderer() {
            return RuleRestrictionValueRenderer.MULTISELECT;
        }

        @Override
        public BaseRuleRestrictionValue convertBaseValues2Rest() {
            return this.getRenderer().renderBaseValues(CabinetConverterHelper.convertDictionaryReferencesToRenderedItems(DictionaryCache.get().getAll(PassengerType.class).values().stream().map(BaseDictionary::toReference).collect(Collectors.toList())));
        }
    }
    ,
    TARIFF_TYPE{

        @Override
        BaseRuleRestrictionValue convertValue2Rest(Object object) {
            return null;
        }

        @Override
        Object convertRest2Value(RuleRestrictionUpdatedValue restrictionUpdatedValue) {
            return null;
        }

        @Override
        RuleRestrictionValueRenderer getRenderer() {
            return null;
        }

        @Override
        public BaseRuleRestrictionValue convertBaseValues2Rest() {
            return null;
        }
    }
    ,
    SALES_POINTS{

        @Override
        BaseRuleRestrictionValue convertValue2Rest(Object object) {
            return this.getRenderer().renderValue(CabinetConverterHelper.convertEntityReferencesUids2RenderedItems((List)object, SalesPoint.class));
        }

        @Override
        List<String> convertRest2Value(RuleRestrictionUpdatedValue restrictionUpdatedValue) {
            return CabinetConverterHelper.convertRenderedItems2EntityReferenceUids((List)this.getRenderer().unrenderValue(restrictionUpdatedValue), SalesPoint.class);
        }

        @Override
        RuleRestrictionValueRenderer getRenderer() {
            return RuleRestrictionValueRenderer.MULTISELECT;
        }

        @Override
        public BaseRuleRestrictionValue convertBaseValues2Rest() {
            return this.getRenderer().renderBaseValues(CabinetConverterHelper.convertEntityReferences2RenderedItems(EntityStorage.get().search(SalesPointIndex.class, new SearchQuery()).getData().stream().map(SalesPointIndex::getSource).collect(Collectors.toList())));
        }
    }
    ,
    BRANCHES{

        @Override
        BaseRuleRestrictionValue convertValue2Rest(Object object) {
            return this.getRenderer().renderValue(CabinetConverterHelper.convertEntityReferencesUids2RenderedItems((List)object, Branch.class));
        }

        @Override
        List<String> convertRest2Value(RuleRestrictionUpdatedValue restrictionUpdatedValue) {
            return CabinetConverterHelper.convertRenderedItems2EntityReferenceUids((List)this.getRenderer().unrenderValue(restrictionUpdatedValue), Branch.class);
        }

        @Override
        RuleRestrictionValueRenderer getRenderer() {
            return RuleRestrictionValueRenderer.MULTISELECT;
        }

        @Override
        public BaseRuleRestrictionValue convertBaseValues2Rest() {
            return this.getRenderer().renderBaseValues(CabinetConverterHelper.convertEntityReferences2RenderedItems(EntityStorage.get().search(BranchIndex.class, new SearchQuery()).getData().stream().map(BranchIndex::getSource).collect(Collectors.toList())));
        }
    };


    abstract BaseRuleRestrictionValue convertValue2Rest(Object var1);

    abstract Object convertRest2Value(RuleRestrictionUpdatedValue var1);

    abstract RuleRestrictionValueRenderer getRenderer();

    public abstract BaseRuleRestrictionValue convertBaseValues2Rest();
}

