/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.cabinet;

import com.gridnine.xtrip.server.ibecorp.b2b.rest.cabinet.CabinetConverterHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.renderer.BaseRuleRestrictionValue;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.renderer.ComboRestrictionValue;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.renderer.DateIntervalRestrictionValue;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.renderer.MultiSelectRuleRestrictionValue;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.renderer.NumberRuleRestrictionValue;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.renderer.RenderedItem;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.renderer.RuleRestrictionUpdatedValue;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.renderer.SelectRestrictionValue;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.renderer.TextRestrictionValue;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.renderer.TimeIntervalRestrictionValue;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.joda.time.LocalDate;
import org.joda.time.LocalTime;

public enum RuleRestrictionValueRenderer {
    MULTISELECT{

        MultiSelectRuleRestrictionValue renderValue(Object restValue) {
            MultiSelectRuleRestrictionValue result = new MultiSelectRuleRestrictionValue();
            result.setRenderer(this.name());
            result.getSelectedValues().addAll((Collection)restValue);
            return result;
        }

        @Override
        List<RenderedItem> unrenderValue(RuleRestrictionUpdatedValue restValue) {
            return CabinetConverterHelper.wrapIds2RenderedItem(restValue.getSelectedValues());
        }

        MultiSelectRuleRestrictionValue renderBaseValues(Object restValue) {
            MultiSelectRuleRestrictionValue result = new MultiSelectRuleRestrictionValue();
            result.setRenderer(this.name());
            result.getValues().addAll((Collection)restValue);
            return result;
        }
    }
    ,
    NUMBER_FIELD{

        NumberRuleRestrictionValue renderValue(Object restValue) {
            NumberRuleRestrictionValue result = new NumberRuleRestrictionValue();
            result.setRenderer(this.name());
            result.setNumber(((Double)restValue).doubleValue());
            return result;
        }

        @Override
        Double unrenderValue(RuleRestrictionUpdatedValue restValue) {
            return restValue.getNumber();
        }

        NumberRuleRestrictionValue renderBaseValues(Object restValue) {
            NumberRuleRestrictionValue result = new NumberRuleRestrictionValue();
            result.setRenderer(this.name());
            return result;
        }
    }
    ,
    COMBO{

        ComboRestrictionValue renderValue(Object restValue) {
            ComboRestrictionValue result = new ComboRestrictionValue();
            result.setRenderer(this.name());
            result.setSelectedValue((RenderedItem)restValue);
            return result;
        }

        RenderedItem unrenderValue(RuleRestrictionUpdatedValue restValue) {
            return CabinetConverterHelper.wrapId2RenderedItem(restValue.getSelectedValue());
        }

        ComboRestrictionValue renderBaseValues(Object restValue) {
            ComboRestrictionValue result = new ComboRestrictionValue();
            result.setRenderer(this.name());
            result.getValues().addAll((Collection)restValue);
            return result;
        }
    }
    ,
    SELECT{

        SelectRestrictionValue renderValue(Object restValue) {
            SelectRestrictionValue result = new SelectRestrictionValue();
            result.setRenderer(this.name());
            result.setSelectedValue((RenderedItem)restValue);
            return result;
        }

        RenderedItem unrenderValue(RuleRestrictionUpdatedValue restValue) {
            return CabinetConverterHelper.wrapId2RenderedItem(restValue.getSelectedValue());
        }

        SelectRestrictionValue renderBaseValues(Object restValue) {
            SelectRestrictionValue result = new SelectRestrictionValue();
            result.setRenderer(this.name());
            result.getValues().addAll((Collection)restValue);
            return result;
        }
    }
    ,
    TEXT_FIELD{

        TextRestrictionValue renderValue(Object restValue) {
            TextRestrictionValue result = new TextRestrictionValue();
            result.setRenderer(this.name());
            result.setText((String)restValue);
            return result;
        }

        @Override
        String unrenderValue(RuleRestrictionUpdatedValue restValue) {
            return restValue.getText();
        }

        TextRestrictionValue renderBaseValues(Object restValue) {
            TextRestrictionValue result = new TextRestrictionValue();
            result.setRenderer(this.name());
            return result;
        }
    }
    ,
    TIME_INTERVAL_FIELDS{

        TimeIntervalRestrictionValue renderValue(Object restValue) {
            List times = (List)restValue;
            TimeIntervalRestrictionValue result = new TimeIntervalRestrictionValue();
            result.setStartDate((LocalTime)times.get(0));
            result.setEndDate((LocalTime)times.get(1));
            return result;
        }

        @Override
        List<LocalTime> unrenderValue(RuleRestrictionUpdatedValue restValue) {
            return Arrays.asList(restValue.getStartTime(), restValue.getEndTime());
        }

        TimeIntervalRestrictionValue renderBaseValues(Object restValue) {
            List times = (List)restValue;
            TimeIntervalRestrictionValue result = new TimeIntervalRestrictionValue();
            result.setStartDate((LocalTime)times.get(0));
            result.setEndDate((LocalTime)times.get(1));
            return result;
        }
    }
    ,
    DATE_INTERVAL_FIELDS{

        DateIntervalRestrictionValue renderValue(Object restValue) {
            List localDates = (List)restValue;
            DateIntervalRestrictionValue result = new DateIntervalRestrictionValue();
            if (!localDates.isEmpty()) {
                result.setStartDate((LocalDate)localDates.get(0));
                result.setEndDate((LocalDate)localDates.get(1));
            }
            return result;
        }

        @Override
        List<LocalDate> unrenderValue(RuleRestrictionUpdatedValue restValue) {
            return Arrays.asList(restValue.getStartDate(), restValue.getEndDate());
        }

        DateIntervalRestrictionValue renderBaseValues(Object restValue) {
            List localDates = (List)restValue;
            DateIntervalRestrictionValue result = new DateIntervalRestrictionValue();
            if (!localDates.isEmpty()) {
                result.setStartDate((LocalDate)localDates.get(0));
                result.setEndDate((LocalDate)localDates.get(1));
            }
            return result;
        }
    };


    abstract BaseRuleRestrictionValue renderValue(Object var1);

    abstract Object unrenderValue(RuleRestrictionUpdatedValue var1);

    abstract BaseRuleRestrictionValue renderBaseValues(Object var1);
}

