/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.cabinet.activatePerson;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.restriction.resource.standard.StandardRestrictionResourceOperations;
import com.gridnine.xtrip.common.user.UserData;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.cabinet.CabinetConverterHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.StandardGetMethodParam;
import com.gridnine.xtrip.server.ibecorp.security.acl.IbePermissionManager;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.util.Date;
import java.util.Objects;

public class ActivatePersonProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        StandardGetMethodParam param = (StandardGetMethodParam)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        EntityContainer personCtr = EntityStorage.get().load(Person.class, param.getUid());
        if (personCtr == null) {
            throw Xeption.forDeveloper((String)("Not found person container by uid: " + param.getUid()), (Object[])new Object[0]);
        }
        boolean granted = IbePermissionManager.isEntityGranted(personCtr, StandardRestrictionResourceOperations.EDIT);
        if (!granted) {
            throw Xeption.forEndUser((String)"ERROR_PERSON_EDIT_NOT_ALLOWED", (Object[])new Object[]{UserData.get().getCurrentUser()});
        }
        ActivatePersonProcessor.activatePerson((EntityContainer<Person>)personCtr);
    }

    private static void activatePerson(EntityContainer<Person> personCtr) {
        Person person = (Person)personCtr.getEntity();
        Date openedDate = new Date();
        person.setDisabled(false);
        CabinetConverterHelper.deleteEmployeeDuplicates(person);
        person.getEmployments().stream().filter(Objects::nonNull).filter(e -> e.getOrganization() != null && e.getClosed() != null && e.getClosed().before(openedDate)).forEach(pe -> {
            pe.setClosed(null);
            pe.setOpened(null);
        });
        EntityStorage.get().save(personCtr, true);
    }
}

