/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.cabinet.bookingDocuments;

import com.gridnine.xtrip.common.jr.JasperUtil;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.helpers.DocumentHelper;
import com.gridnine.xtrip.common.model.system.BaseFileDocument;
import com.gridnine.xtrip.common.model.system.BinaryData;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.model.system.DownloadableData;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.cabinet.CabinetHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.cabinet.bookingDocuments.BookingDocumentsHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.DocumentReference;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.DownloadBookingDocumentsParameters;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.util.stream.Collectors;

public class DownloadBookingDocumentsProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        DownloadBookingDocumentsParameters parameters = (DownloadBookingDocumentsParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)CabinetHelper.buildZIP2Download(parameters.getRefs().stream().map(DownloadBookingDocumentsProcessor::buildDownloadableData).collect(Collectors.toList()), "documents.zip"));
    }

    private static DownloadableData buildDownloadableData(DocumentReference ref) {
        try {
            BaseFileDocument doc = BookingDocumentsHelper.loadDocument(ref);
            DownloadableData data = new DownloadableData();
            BinaryData bd = new BinaryData();
            if (doc.getContentType() == ContentType.JASPERPRINT) {
                bd.setContentType(ContentType.PDF);
                bd.setData(JasperUtil.convertToPdf((byte[])doc.getContent()));
            } else {
                bd.setContentType(doc.getContentType());
                bd.setData(doc.getContent());
            }
            data.setContent(bd);
            data.setFileName(DocumentHelper.getDocNameWithExtension((BaseFileDocument)doc));
            return data;
        }
        catch (Exception ex) {
            throw Xeption.forDeveloper((String)"failed building downloadable data", (Throwable)ex, (Object[])new Object[0]);
        }
    }
}

