/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.cabinet.bookingDocuments;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TravelSubject;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.system.BasicDocumentIndex;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.model.system.DocumentType;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.DateUtils;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.BookingDocument;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.GetBookingDocumentsParameters;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.util.Date;
import java.util.Objects;
import java.util.stream.Collectors;

public class GetBookingDocumentsProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        GetBookingDocumentsParameters parameters = (GetBookingDocumentsParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        EntityReference bfRef = new EntityReference(parameters.getBookingUid(), BookingFile.class, null);
        EntityContainer bfCtr = EntityStorage.get().resolve(bfRef);
        SearchQuery documentsQuery = new SearchQuery();
        documentsQuery.getCriteria().getCriterions().add(SearchCriterion.ne((String)BasicDocumentIndex.Property.doNotShowOnSite.name(), (Object)true));
        documentsQuery.getCriteria().getCriterions().add(SearchCriterion.eq((String)BasicDocumentIndex.Property.owner.name(), (Object)bfRef));
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, EntityStorage.get().search(BasicDocumentIndex.class, documentsQuery).getData().stream().filter(idx -> GetBookingDocumentsProcessor.isShowOnSite(idx, (BookingFile)bfCtr.getEntity())).map(idx -> GetBookingDocumentsProcessor.buildBookingDocument(idx, (BookingFile)bfCtr.getEntity())).collect(Collectors.toList()));
    }

    private static boolean isShowOnSite(BasicDocumentIndex idx, BookingFile bookingFile) {
        BaseProduct product;
        if (idx.isExternal()) {
            return true;
        }
        if (idx.getNavigationKey() != null && (product = BookingHelper.findProductByUid((String)idx.getNavigationKey(), (BookingFile)bookingFile)) != null) {
            ProductHandler handler = ProductHandler.of((BaseProduct)product);
            TravelSubject travelSubject = handler.getDefaultTravelSubject();
            if (travelSubject == TravelSubject.RAILWAY) {
                return idx.getType() == DocumentType.TRAVELDOCUMENT && idx.getContentType() == ContentType.PDF || idx.getType() == DocumentType.RECEIPT && idx.getContentType() == ContentType.JASPERPRINT;
            }
            if (travelSubject == TravelSubject.AIR) {
                return idx.getType() == DocumentType.SPECIAL_TRAVELDOCUMENT && idx.getContentType() == ContentType.PDF || idx.getType() == DocumentType.RECEIPT && idx.getContentType() == ContentType.JASPERPRINT;
            }
            if (travelSubject == TravelSubject.HOTEL_RESERVATION) {
                return idx.getType() == DocumentType.VOUCHER && idx.getContentType() == ContentType.JASPERPRINT;
            }
            if (travelSubject == TravelSubject.TRANSFER) {
                return idx.getType() == DocumentType.RECEIPT && idx.getContentType() == ContentType.JASPERPRINT;
            }
            return idx.getType() == DocumentType.RECEIPT || idx.getType() == DocumentType.VOUCHER || idx.getType() == DocumentType.SPECIAL_TRAVELDOCUMENT || idx.getType() == DocumentType.TRAVELDOCUMENT;
        }
        return idx.getType() == DocumentType.TRAVELDOCUMENT && idx.getContentType() == ContentType.PDF || idx.getType() == DocumentType.SPECIAL_TRAVELDOCUMENT && idx.getContentType() == ContentType.PDF || idx.getType() == DocumentType.RECEIPT && idx.getContentType() == ContentType.JASPERPRINT || idx.getType() == DocumentType.VOUCHER && idx.getContentType() == ContentType.JASPERPRINT;
    }

    private static BookingDocument buildBookingDocument(BasicDocumentIndex idx, BookingFile bookingFile) {
        BookingDocument doc = new BookingDocument();
        doc.setUid(idx.getSource().getUid());
        doc.setClassName(idx.getSource().getType().getName());
        doc.setDocumentType(idx.getType());
        doc.setExternal(idx.isExternal());
        doc.setCreated(DateUtils.toLocalDateTime((Date)idx.getCreated()));
        doc.setName(idx.getName());
        doc.setTitle(idx.getTitle());
        if (idx.getNavigationKey() != null) {
            BaseProduct product = BookingHelper.findProductByUid((String)idx.getNavigationKey(), (BookingFile)bookingFile);
            if (product != null) {
                ProductHandler handler = ProductHandler.of((BaseProduct)product);
                doc.setRecordLocator(CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)product.getReservation()));
                doc.getTicketNumbers().addAll(handler.getProductNumbers(product));
                doc.getTravellersNames().addAll(handler.getTravellers(product).stream().map(Traveller::getName).filter(Objects::nonNull).collect(Collectors.toList()));
                doc.setTravelSubject(handler.getDefaultTravelSubject());
            } else {
                Reservation reservation = BookingHelper.findReservationByUid((BookingFile)bookingFile, (String)idx.getNavigationKey());
                if (reservation != null) {
                    doc.setRecordLocator(CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)reservation));
                }
            }
        }
        return doc;
    }
}

