/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.cabinet.bookingDocuments;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.DocumentHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSite;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.BaseFileDocument;
import com.gridnine.xtrip.common.model.system.BinaryData;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.model.system.Document;
import com.gridnine.xtrip.common.model.system.DownloadableData;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.util.ExceptionUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.cabinet.CabinetHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.cabinet.bookingDocuments.BookingDocumentsHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.booking.ReservationWithCommentParams;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.SendBookingDocumentsParameters;
import com.gridnine.xtrip.server.ibecorp.common.rest.CommonValidationHelper;
import com.gridnine.xtrip.server.ibecorp.notifications.ItineraryReceiptNotification;
import com.gridnine.xtrip.server.ibecorp.notifications.NotificationHelper;
import com.gridnine.xtrip.server.ibecorp.notifications.NotificationParameters;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class SendBookingDocumentsProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        SendBookingDocumentsParameters parameters = (SendBookingDocumentsParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        EntityReference bfRef = parameters.getCurrentBooking();
        EntityContainer bookingFileCtr = EntityStorage.get().resolve(bfRef);
        CommonValidationHelper.validationEmailMessages(parameters.getEmails(), parameters.getValidationContext().getEmailsListValidationMessages());
        BookingFile bookingFile = (BookingFile)bookingFileCtr.getEntity();
        List<BaseFileDocument> baseFileDocuments = parameters.getRefs().stream().map(BookingDocumentsHelper::loadDocument).filter(Objects::nonNull).map(ExceptionUtil.wrapFunction(doc -> doc.getContentType() == ContentType.JASPERPRINT ? NotificationHelper.convertJasper2Pdf(doc) : doc)).collect(Collectors.toList());
        salesContext.setClient(bookingFile.getCustomerProfile());
        EntityReference bookingRef = bookingFileCtr.toReference();
        NotificationParameters notificationParameters = new NotificationParameters((EntityReference<Organization>)salesContext.getSubagency(), (EntityReference<Organization>)salesContext.getClient(), (EntityReference<SMSite>)((EntityReference)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.SITE)), LocaleHelper.getCurrentLocale(), bookingRef, salesContext);
        List<BaseFileDocument> documents = baseFileDocuments.size() < 5 ? baseFileDocuments : this.contentInZip(baseFileDocuments);
        NotificationHelper.sendNotification(() -> new ItineraryReceiptNotification(notificationParameters, documents, parameters.getEmails(), bookingFile, this.buildCommentLetter(parameters.getSendItineraryReceiptWithComment())), bookingRef, true);
        ctx.addMessage(SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"DOC_SENT", (Object[])new Object[0]));
    }

    private List<BaseFileDocument> contentInZip(List<BaseFileDocument> baseFileDocuments) {
        DownloadableData zip = CabinetHelper.buildZIP2Download(baseFileDocuments.stream().map(SendBookingDocumentsProcessor::buildDownloadableData).collect(Collectors.toList()), "documents.zip");
        Document doc = new Document();
        doc.setName(zip.getFileName());
        doc.setContentType(zip.getContent().getContentType());
        doc.setContent(zip.getContent().getData());
        return Collections.singletonList(doc);
    }

    private static DownloadableData buildDownloadableData(BaseFileDocument doc) {
        DownloadableData data = new DownloadableData();
        BinaryData bd = new BinaryData();
        bd.setContentType(doc.getContentType());
        bd.setData(doc.getContent());
        data.setContent(bd);
        data.setFileName(DocumentHelper.getDocNameWithExtension((BaseFileDocument)doc));
        return data;
    }

    private String buildCommentLetter(List<ReservationWithCommentParams> restComments) {
        return restComments.stream().map(ReservationWithCommentParams::getComments).filter(TextUtil::nonBlank).collect(Collectors.joining("\n"));
    }
}

