/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.cabinet.contractEditingData;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.profile.ContractIndex;
import com.gridnine.xtrip.common.model.profile.ModelContractIndex;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.cabinet.CabinetConverterHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.ContractEditingDataResult;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.util.Date;
import java.util.Objects;
import java.util.stream.Collectors;

public class GetContractEditingDataProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        ContractEditingDataResult result = new ContractEditingDataResult();
        result.getContractTypes().add(ContractType.CLIENT);
        result.getSuppliers().add(salesContext.getSubagency());
        SearchQuery clientsQuery = new SearchQuery();
        clientsQuery.getCriteria().getCriterions().add(SearchCriterion.eq((String)ContractIndex.Property.supplier.name(), (Object)salesContext.getSubagency()));
        clientsQuery.getCriteria().getCriterions().add(SearchCriterion.eq((String)ContractIndex.Property.contractType.name(), (Object)ContractType.CLIENT));
        Date now = new Date();
        clientsQuery.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractIndex.Property.startDate.name(), null), SearchCriterion.le((String)ContractIndex.Property.startDate.name(), (Object)MiscUtil.setDayEndTime((Date)now))}));
        clientsQuery.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractIndex.Property.endDate.name(), null), SearchCriterion.ge((String)ContractIndex.Property.endDate.name(), (Object)MiscUtil.clearTime((Date)now))}));
        clientsQuery.getPreferredProperties().add(ContractIndex.Property.customer.name());
        result.getClients().addAll(EntityStorage.get().search(ContractIndex.class, clientsQuery).getData().stream().map(ContractIndex::getCustomer).filter(Objects::nonNull).distinct().collect(Collectors.toList()));
        SearchQuery ruleGroupsQuery = new SearchQuery();
        ruleGroupsQuery.getCriteria().getCriterions().add(SearchCriterion.contains((String)ModelContractIndex.Property.agencies.name(), (Object)salesContext.getSubagency()));
        ruleGroupsQuery.getPreferredProperties().add("containerUid");
        EntityStorage es = EntityStorage.get();
        result.getRuleGroups().addAll(EntityStorage.get().search(ModelContractIndex.class, ruleGroupsQuery).getData().stream().map(ModelContractIndex::getSource).map(arg_0 -> ((EntityStorage)es).resolve(arg_0)).map(CabinetConverterHelper::convertModelContract2Rest).collect(Collectors.toList()));
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)result);
    }
}

