/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.cabinet.createContract;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.profile.Contract2ModelContract;
import com.gridnine.xtrip.common.model.profile.ModelContract;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.Contract;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.UpdateContractParameters;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.UpdateContractResult;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.time.LocalDate;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class CreateContractProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        UpdateContractParameters params = (UpdateContractParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        Contract restContract = params.getContract();
        if (StringUtils.isNotBlank((String)restContract.getUid())) {
            throw Xeption.forDeveloper((String)"Contract to create has not blank uid", (Object[])new Object[0]);
        }
        com.gridnine.xtrip.common.model.profile.Contract contract = new com.gridnine.xtrip.common.model.profile.Contract();
        contract.setNewModel(true);
        contract.setName(restContract.getName());
        contract.setContractType(restContract.getType());
        contract.setAgreementType(restContract.getAgreementType());
        contract.setCustomer(restContract.getClient());
        contract.setSupplier(restContract.getSupplier());
        contract.setNumber(restContract.getNumber());
        contract.setIssueDate(MiscUtil.toDate((LocalDate)restContract.getSignDate()));
        contract.setStartDate(MiscUtil.toDate((LocalDate)restContract.getStartDate()));
        contract.setEndDate(MiscUtil.toDate((LocalDate)restContract.getEndDate()));
        List cmcs = restContract.getRuleGroups().stream().map(rg -> new EntityReference(rg.getUid(), ModelContract.class, rg.getName())).map(mc -> {
            Contract2ModelContract cmc = new Contract2ModelContract();
            cmc.setModelContract(mc);
            return cmc;
        }).collect(Collectors.toList());
        contract.getModelContracts().addAll(cmcs);
        EntityContainer contractCtr = EntityContainer.create((BaseEntity)contract);
        EntityStorage.get().save(contractCtr, true);
        UpdateContractResult result = new UpdateContractResult();
        result.setSuccess(true);
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)result);
    }
}

