/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.cabinet.createEmployee;

import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.asset.AssetsStorage;
import com.gridnine.xtrip.common.model.assets.UserAccount;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.ibecorp.SecurityType;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.security.acl.principal.AclUser;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.storage.LogicalStorageHelper;
import com.gridnine.xtrip.server.ibecorp.assets.UserSecurityTokenAsset;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.cabinet.CabinetConverterHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.cabinet.CabinetHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.Employee;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.UpdateEmployeeParameters;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.UpdateEmployeeResult;
import com.gridnine.xtrip.server.ibecorp.helpers.UserSecurityHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;

public class CreateEmployeeProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        UpdateEmployeeParameters params = (UpdateEmployeeParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        Employee employee = params.getEmployee();
        EntityContainer personCtr = new EntityContainer(Person.class);
        CabinetConverterHelper.updateRestEmployee2Person(employee, (Person)personCtr.getEntity(), true);
        MiscUtil.Pair<UserAccount, AclUser> pair = CabinetHelper.createUserAccount((Person)personCtr.getEntity(), employee);
        LogicalStorageHelper.unitOfWork(() -> {
            EntityStorage.get().save(personCtr, true);
            if (pair != null) {
                AssetsStorage.get().save((BaseAsset)pair.getFirst());
                AssetsStorage.get().save((BaseAsset)pair.getSecond());
            }
            if (params.getEmployee().getSecurityType() == SecurityType.GOOGLE && TextUtil.nonBlank((String)params.getEmployee().getGoogleAuthToken())) {
                UserSecurityTokenAsset userSecurityTokenAsset = UserSecurityHelper.findOrCreateUserSecurityTokenAsset(personCtr.getUid());
                UserSecurityHelper.setGoogleAuthToken(userSecurityTokenAsset, params.getEmployee().getGoogleAuthToken());
                AssetsStorage.get().save((BaseAsset)userSecurityTokenAsset);
            }
        });
        UpdateEmployeeResult result = new UpdateEmployeeResult();
        result.setEmployee(CabinetConverterHelper.convertPerson2RestEmployee((EntityContainer<Person>)personCtr));
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)result);
    }
}

