/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.cabinet.disablePerson;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.restriction.resource.standard.StandardRestrictionResourceOperations;
import com.gridnine.xtrip.common.user.UserData;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.StandardGetMethodParam;
import com.gridnine.xtrip.server.ibecorp.security.acl.IbePermissionManager;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.util.Calendar;
import java.util.Objects;

public class DisablePersonProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        StandardGetMethodParam param = (StandardGetMethodParam)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        EntityContainer personCtr = EntityStorage.get().load(Person.class, param.getUid());
        if (personCtr == null) {
            throw Xeption.forDeveloper((String)("Invalid uid: " + param.getUid()), (Object[])new Object[0]);
        }
        boolean granted = IbePermissionManager.isEntityGranted(personCtr, StandardRestrictionResourceOperations.DELETE);
        if (!granted) {
            throw Xeption.forEndUser((String)"ERROR_PERSON_DELETE_NOT_ALLOWED", (Object[])new Object[]{UserData.get().getCurrentUser()});
        }
        DisablePersonProcessor.disablePerson((EntityContainer<Person>)personCtr);
    }

    private static void disablePerson(EntityContainer<Person> personCtr) {
        Person person = (Person)personCtr.getEntity();
        Calendar closedDay = Calendar.getInstance();
        closedDay.add(5, -1);
        person.setDisabled(true);
        person.getEmployments().stream().filter(Objects::nonNull).forEach(emp -> emp.setClosed(closedDay.getTime()));
        EntityStorage.get().save(personCtr, true);
    }
}

