/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.cabinet.editOrder;

import com.gridnine.xtrip.common.lockmanager.LockUtil;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.EditOrderCommentParameters;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.EditOrderResult;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.util.Objects;

public class EditOrderCommentProcessor
extends BaseProcessor {
    private static String SUCCESS_CODE_MSG = "Success";
    private static String ERROR_CODE_MSG = "Unable to edit order - internal server error";

    public void process(MessageContext ctx) throws Exception {
        EditOrderCommentParameters request = (EditOrderCommentParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        if (Objects.isNull(request.getOrderUid())) {
            throw Xeption.forDeveloper((String)"ERROR_EMPTY_ORDER_UID", (Object[])new Object[0]);
        }
        EditOrderResult response = new EditOrderResult();
        EntityReference bfRef = request.getOrderUid();
        try {
            LockUtil.lock((EntityReference)bfRef, bfCtr -> {
                ((BookingFile)bfCtr.getEntity()).setNotes(request.getNotes());
                bfCtr.getVersionInfo().setVersionNotes("comment added");
                bfCtr.getVersionInfo().setDataSource("operation cabinet/editOrderComment");
                EntityStorage.get().save(bfCtr, true);
            });
            response.setStatusCode("0");
            response.setStatusText(SUCCESS_CODE_MSG);
        }
        catch (Exception e) {
            response.setStatusCode("500");
            response.setStatusText(ERROR_CODE_MSG);
        }
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)response);
    }
}

