/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.cabinet.editOrder;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.BookingFileIndex;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.parameters.EntityStorageSearchParameters;
import com.gridnine.xtrip.common.model.helpers.SearchQueryHelper;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.EditOrderParameters;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.EditOrderResult;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.util.List;

public class EditOrderProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        EditOrderParameters request = (EditOrderParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        if (TextUtil.isBlank((String)request.getPnr())) {
            throw Xeption.forDeveloper((String)"empty pnr", (Object[])new Object[0]);
        }
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchQueryHelper.getBookingRecordLocatorSearchCriterion((String)request.getPnr(), (boolean)true));
        List bfIndices = EntityStorage.get().search(BookingFileIndex.class, query, (EntityStorageSearchParameters)new EntityStorageSearchParameters().noCache(true)).getData();
        if (bfIndices.size() == 0) {
            throw Xeption.forDeveloper((String)("No booking file found for pnr " + request.getPnr()), (Object[])new Object[0]);
        }
        EditOrderResult response = new EditOrderResult();
        try {
            BookingFileIndex bfInd = (BookingFileIndex)bfIndices.get(0);
            EntityReference bfRef = bfInd.getSource();
            EntityContainer bfCont = EntityStorage.get().resolve(bfRef);
            ((BookingFile)bfCont.getEntity()).setNotes(request.getNotes());
            EntityStorage.get().save(bfCont, false);
            response.setStatusCode("0");
            response.setStatusText("OK");
        }
        catch (Exception e) {
            response.setStatusCode("500");
            response.setStatusText("OK");
        }
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)response);
    }
}

