/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.cabinet.finance;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.asset.AssetsStorage;
import com.gridnine.xtrip.common.model.assets.SysLogItem;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.finance.document.FinanceDocumentsCreateTaskParameters;
import com.gridnine.xtrip.common.model.finance.document.FinanceDocumentsCreateTaskResult;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.standard.helpers.SysLogHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.CreateFinanceDocumentsParameters;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import com.gridnine.xtrip.server.model.finance.document.FinanceDocumentsCreateTaskHelper;
import com.gridnine.xtrip.server.model.helpers.FinanceDocumentHelper;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class CreateFinanceDocumentsProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        CreateFinanceDocumentsParameters restParameters = (CreateFinanceDocumentsParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        EntityContainer bookingFile = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE);
        Date date = new Date();
        ContractType contractType = (ContractType)MiscUtil.guarded((Object)restParameters.getContractType(), (Object)ContractType.CLIENT);
        Set products = FinanceDocumentHelper.getShipmentFinanceDocumentProductDatas(BookingHelper.getBaseProductsStream((BookingFile)((BookingFile)bookingFile.getEntity())).collect(Collectors.toMap(item -> new NestedEntityReference(bookingFile, (BaseEntity)item, BookingHelper.generateShortProductName((BaseProduct)item)), item -> item)), (EntityReference)salesContext.getSubagency(), (Date)date).entrySet().stream().filter(entry -> ((Set)entry.getValue()).stream().anyMatch(data -> data.getContractType() == contractType)).map(Map.Entry::getKey).collect(Collectors.toSet());
        if (products.isEmpty()) {
            throw Xeption.forEndUser((String)"\u041f\u0440\u043e\u0434\u0443\u043a\u0442\u044b \u0434\u043b\u044f \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u044b\u0445 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u043e\u0432 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u044e\u0442", (Object[])new Object[0]);
        }
        FinanceDocumentsCreateTaskParameters parameters = new FinanceDocumentsCreateTaskParameters();
        parameters.setDate(date);
        parameters.getProducts().clear();
        parameters.getProducts().addAll(products);
        parameters.setContractType(contractType);
        final EntityReference bookingFileReference = bookingFile.toReference();
        FinanceDocumentsCreateTaskResult result = FinanceDocumentsCreateTaskHelper.create((FinanceDocumentsCreateTaskParameters)parameters, (FinanceDocumentsCreateTaskHelper.FinanceDocumentsCreateTaskCallback)new FinanceDocumentsCreateTaskHelper.FinanceDocumentsCreateTaskCallback(){

            public void setProgress(byte progress, String message) throws Exception {
            }

            public void addMessages(Collection<Message> messages) throws Exception {
                AssetsStorage.get().save((Iterable)messages.stream().filter(message -> message.getType() == MessageType.WARNING || message.getType() == MessageType.ERROR).map(message -> {
                    SysLogItem item = SysLogHelper.newAuditItem((EntityReference)bookingFileReference, (String)"\u0441\u043e\u0437\u0434\u0430\u043d\u0438\u0435 \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u044b\u0445 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u043e\u0432", (Message)message);
                    item.setDate(new Date());
                    return item;
                }).collect(Collectors.toList()));
            }
        });
    }
}

