/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.cabinet.finance;

import com.gridnine.xtrip.common.ibecorp.exception.RankedXeption;
import com.gridnine.xtrip.common.ibecorp.exception.XeptionSeverity;
import com.gridnine.xtrip.common.ibecorp.restriction.resource.IbeRestrictionGroupResources;
import com.gridnine.xtrip.common.jr.JasperUtil;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.FopComponent;
import com.gridnine.xtrip.common.model.booking.FopDetalization;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.finance.ExternalFinanceDocument;
import com.gridnine.xtrip.common.model.finance.ExternalFinanceDocumentIndex;
import com.gridnine.xtrip.common.model.finance.FinanceDocument;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.system.BinaryData;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.model.system.DownloadableData;
import com.gridnine.xtrip.common.model.system.StandardValidationMessages;
import com.gridnine.xtrip.common.model.validation.ValidationException;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.CompositeNumber;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.cabinet.CabinetHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.GetFinanceDocumentsParameters;
import com.gridnine.xtrip.server.ibecorp.l10n.Messages;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class GetFinanceDocumentsProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        List<ExternalFinanceDocument> externalFinanceDocuments;
        GetFinanceDocumentsParameters restParameters = (GetFinanceDocumentsParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        EntityContainer bookingFile = EntityStorage.get().load(BookingFile.class, restParameters.getBookingUid());
        if (bookingFile == null) {
            restParameters.getValidationContext().getBookingUidValidationMessages().add(StandardValidationMessages.getMissingRequiredValue());
            throw new ValidationException();
        }
        ContractType contractType = (ContractType)MiscUtil.guarded((Object)restParameters.getContractType(), (Object)ContractType.CLIENT);
        IbeRestrictionGroupResources financeGroupResources = this.getFinanceGroupResources(contractType);
        if (!CabinetHelper.isGranted(financeGroupResources)) {
            throw Xeption.forDeveloper((String)Messages.ACCESS_DENIED, (Object[])new Object[0]);
        }
        List<FinanceDocument> financeDocuments = this.getFinanceDocuments((EntityContainer<BookingFile>)bookingFile, contractType);
        List<ExternalFinanceDocument> list = externalFinanceDocuments = contractType == ContractType.CLIENT ? this.getExternalFinanceDocuments((EntityContainer<BookingFile>)bookingFile) : Collections.emptyList();
        if (financeDocuments.isEmpty() && externalFinanceDocuments.isEmpty()) {
            throw RankedXeption.forEndUser((XeptionSeverity)XeptionSeverity.INFO, (String)"FIN_DOCS_IS_EMPTY", (Object[])new Object[0]);
        }
        DownloadableData downloadableData = GetFinanceDocumentsProcessor.createZip(financeDocuments, externalFinanceDocuments, (EntityContainer<BookingFile>)bookingFile);
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)downloadableData);
    }

    private IbeRestrictionGroupResources getFinanceGroupResources(ContractType contractType) {
        switch (contractType) {
            case CLIENT: {
                return IbeRestrictionGroupResources.GROUP_BOOKINGS_CLIENT_FINANCES;
            }
            case SUBAGENCY: {
                return IbeRestrictionGroupResources.GROUP_BOOKINGS_SUBAGENT_FINANCES;
            }
        }
        throw Xeption.forDeveloper((String)"invalid contract type {0}", (Object[])new Object[]{contractType});
    }

    private List<FinanceDocument> getFinanceDocuments(EntityContainer<BookingFile> bookingFile, ContractType contractType) {
        return BookingHelper.getBaseProductsStream((BookingFile)((BookingFile)bookingFile.getEntity())).flatMap(product -> (contractType == ContractType.CLIENT ? GeneralProductHelper.getClientFops((BaseProduct)product).stream() : GeneralProductHelper.getSubagentFops((BaseProduct)product).stream()).map(fop -> (FopDetalization)product.getFopDetalizations().get(fop.getUid()))).filter(Objects::nonNull).flatMap(detalization -> detalization.getComponents().stream()).map(FopComponent::getShipment).filter(Objects::nonNull).distinct().map(arg_0 -> ((EntityStorage)EntityStorage.get()).resolve(arg_0)).filter(EntityStorageHelper::nonEmpty).flatMap(shipment -> ((Shipment)shipment.getEntity()).getFinanceDocuments().stream()).distinct().map(arg_0 -> ((EntityStorage)EntityStorage.get()).resolve(arg_0)).filter(EntityStorageHelper::nonEmpty).map(EntityContainer::getEntity).filter(document -> document.getContent() != null && document.getContent().getData() != null && (document.getContent().getContentType() == ContentType.JASPERPRINT || document.getContent().getContentType() == ContentType.PDF)).collect(Collectors.toList());
    }

    private List<ExternalFinanceDocument> getExternalFinanceDocuments(EntityContainer<BookingFile> bookingFile) {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ExternalFinanceDocumentIndex.Property.bookingFile.name(), (Object)bookingFile.toReference()));
        query.getPreferredProperties().add(ExternalFinanceDocumentIndex.Property.number.name());
        EntityStorage es = EntityStorage.get();
        return es.search(ExternalFinanceDocumentIndex.class, query).getData().stream().map(ExternalFinanceDocumentIndex::getSource).map(arg_0 -> ((EntityStorage)es).resolve(arg_0)).map(EntityContainer::getEntity).filter(document -> document.getContent() != null).collect(Collectors.toList());
    }

    private static DownloadableData createZip(List<FinanceDocument> financeDocuments, List<ExternalFinanceDocument> externalFinanceDocuments, EntityContainer<BookingFile> bookingFile) {
        String archiveName = String.format("finance_documents_%s.zip", ((BookingFile)bookingFile.getEntity()).toString());
        return CabinetHelper.buildZIP2Download(Stream.concat(financeDocuments.stream().map(fd -> {
            String fileName = TextUtil.buildFullNumber((CompositeNumber)fd);
            if (fd.getType() != null) {
                fileName = String.format("%s_%s", fileName, fd.getType());
            }
            fileName = fileName.replaceAll("\\s+", "_");
            fileName = fileName + ".pdf";
            DownloadableData dd = new DownloadableData();
            dd.setFileName(fileName);
            try {
                BinaryData bd = new BinaryData();
                bd.setData(fd.getContent().getContentType() == ContentType.JASPERPRINT ? JasperUtil.convertToPdf((byte[])fd.getContent().getData()) : fd.getContent().getData());
                bd.setContentType(ContentType.PDF);
                dd.setContent(bd);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            return dd;
        }), externalFinanceDocuments.stream().map(efd -> {
            DownloadableData dd = new DownloadableData();
            dd.setFileName(efd.getName());
            BinaryData bd = new BinaryData();
            bd.setData(efd.getContent());
            bd.setContentType(efd.getContentType());
            dd.setContent(bd);
            return dd;
        })).collect(Collectors.toList()), archiveName);
    }
}

