/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.cabinet.getAgents;

import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonIndex;
import com.gridnine.xtrip.common.model.profile.PersonType;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.cabinet.CabinetHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.AgentReference;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.GetAgentsParameters;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.GetAgentsResult;
import com.gridnine.xtrip.server.ibecorp.common.rest.authorization.AuthorizationHelper;
import com.gridnine.xtrip.server.ibecorp.security.acl.IbePermissionManager;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Locale;
import java.util.Map;

public class GetAgentsProcessor
extends BaseProcessor {
    static int comparePersons(Person o1, Person o2, String pattern, Locale locale) {
        int result = 0;
        if (result == 0) {
            result = MiscUtil.compare((Comparable)((Comparable)MiscUtil.findByLocale((Map)o1.getLastName().getValues(), (Locale)locale)), (Comparable)((Comparable)MiscUtil.findByLocale((Map)o2.getLastName().getValues(), (Locale)locale)));
        }
        return result;
    }

    public void process(MessageContext ctx) throws Exception {
        EntityReference<Organization> agencyRef;
        GetAgentsParameters request = (GetAgentsParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        Locale locale = LocaleHelper.getCurrentLocale();
        int limit = 0;
        if (request.getLimit() != null) {
            if (request.getLimit() <= 0) {
                throw Xeption.forDeveloper((String)"limit <= 0", (Object[])new Object[0]);
            }
            if (request.getLimit() > 100) {
                throw Xeption.forDeveloper((String)"limit > 100", (Object[])new Object[0]);
            }
            limit = request.getLimit();
        }
        EntityContainer perCont = (EntityContainer)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.AUTHORIZED_USER_CONTAINER);
        Person loginAgent = (Person)perCont.getEntity();
        GetAgentsResult result = new GetAgentsResult();
        boolean granted = IbePermissionManager.isIndexGranted(PersonIndex.class);
        if (!granted) {
            ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)result);
            return;
        }
        ArrayList<EntityContainer> searchResult = new ArrayList<EntityContainer>();
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.contains((String)PersonIndex.Property.types.name(), (Object)(AuthorizationHelper.isCorporantAuthorized(loginAgent) ? PersonType.PASSENGER.name() : PersonType.AGENT.name())));
        if (request.getPattern() != null) {
            String pattern = request.getPattern();
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.ilike((String)PersonIndex.Property.code.name(), (String)pattern), SearchCriterion.ilike((String)PersonIndex.Property.name.name(), (String)("%" + pattern + "%"))}));
        }
        if ((agencyRef = CabinetHelper.findPlaceOFWorkReference(loginAgent)) != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.contains((String)PersonIndex.Property.employmentsUids.name(), (Object)agencyRef.getUid()));
        }
        ArrayList<PersonIndex> searchResultIndices = new ArrayList<PersonIndex>(IbePermissionManager.secureSearch(PersonIndex.class, query));
        for (PersonIndex perInd : searchResultIndices) {
            EntityContainer perCtr = EntityStorage.get().resolve(perInd.getSource());
            if (perCtr == null || perCtr.getEntity() == null) continue;
            searchResult.add(perCtr);
        }
        Collections.sort(searchResult, this.createAgentsComparator(request.getPattern(), locale));
        for (EntityContainer ctr : searchResult) {
            Person per = (Person)ctr.getEntity();
            AgentReference agentRef = new AgentReference();
            agentRef.setContainerUid(ctr.getUid());
            agentRef.setLastName((String)MiscUtil.findByLocale((Map)per.getLastName().getValues(), (Locale)locale));
            agentRef.setFirstName((String)MiscUtil.findByLocale((Map)per.getFirstName().getValues(), (Locale)locale));
            result.getAgents().add(agentRef);
            if (result.getAgents().size() != limit) continue;
            break;
        }
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)result);
    }

    private Comparator<EntityContainer<Person>> createAgentsComparator(String pattern, Locale locale) {
        return (o1, o2) -> GetAgentsProcessor.comparePersons((Person)o1.getEntity(), (Person)o2.getEntity(), pattern, locale);
    }
}

