/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.cabinet.getBalance;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.ibecorp.CurrencyHelper;
import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.finance.ChartOfAccountsElementType;
import com.gridnine.xtrip.common.model.finance.DimensionType;
import com.gridnine.xtrip.common.model.helpers.BalanceHelper;
import com.gridnine.xtrip.common.model.helpers.FinanceHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.CreditLimitInfo;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.cabinet.CabinetHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.GetCurrentBalanceResult;
import com.gridnine.xtrip.server.ibecorp.common.rest.authorization.AuthorizationHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class GetCurrentBalanceProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Locale locale = LocaleHelper.getCurrentLocale();
        EntityContainer authorizedUserCtr = EntityStorage.get().resolve((EntityReference)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.AUTHORIZED_USER));
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        EntityReference currentOrgRef = (EntityReference)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.CURRENT_ORGANIZATION);
        Person authorizedUser = (Person)authorizedUserCtr.getEntity();
        EntityReference supplierAgencyRef = AuthorizationHelper.isCorporantAuthorized(authorizedUser) ? salesContext.getSubagency() : salesContext.getAgency();
        GetCurrentBalanceResult result = new GetCurrentBalanceResult();
        if (currentOrgRef.equals((Object)supplierAgencyRef)) {
            ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)result);
            return;
        }
        ContractType balanceContractType = AuthorizationHelper.isCorporantAuthorized(authorizedUser) ? ContractType.CLIENT : ContractType.SUBAGENCY;
        Map<DimensionType, EntityReference> dimensionTypeObjectMap = Collections.singletonMap(DimensionType.ORGANIZATION, supplierAgencyRef);
        String currency = CurrencyHelper.getCurrency((EntityReference)supplierAgencyRef, (EntityReference)currentOrgRef, (ContractType)balanceContractType);
        DictionaryReference currencyInfo = FinanceHelper.getCurrency((String)currency);
        NumberFormat nf = CabinetHelper.getNumberFormat(locale);
        if (!this.isUnlimitedCredit((EntityReference<Organization>)currentOrgRef, (EntityReference<Organization>)supplierAgencyRef)) {
            BigDecimal balance = MiscUtil.guarded((BigDecimal)BalanceHelper.calculateBalance((EntityReference)currentOrgRef, null, (Date)new Date(), (ChartOfAccountsElementType)ChartOfAccountsElementType.SUPPLIER, (DictionaryReference)currencyInfo, dimensionTypeObjectMap));
            BigDecimal credit = ProfileHelper.getOrganizationCreditAmount((EntityReference)currentOrgRef, (EntityReference)supplierAgencyRef);
            if (balanceContractType == ContractType.SUBAGENCY) {
                List<EntityReference<Organization>> clients = CabinetHelper.findCorporateClients((EntityReference<Organization>)currentOrgRef);
                EntityReference<Organization> retailClient = clients.isEmpty() ? null : clients.get(0);
                String retailClientCurrency = retailClient != null ? CurrencyHelper.getCurrency((EntityReference)currentOrgRef, retailClient, (ContractType)ContractType.CLIENT) : currency;
                BigDecimal availableFunds = CurrencyHelper.exchange((BigDecimal)balance, (String)currency, (String)retailClientCurrency);
                if (credit != null) {
                    availableFunds = availableFunds.add(CurrencyHelper.exchange((BigDecimal)credit, (String)currency, (String)retailClientCurrency));
                }
                result.setAvailableFunds(nf.format(availableFunds));
                result.setAvailableFundsCurrency(retailClientCurrency);
            } else {
                BigDecimal availableFunds = balance;
                if (credit != null) {
                    availableFunds = availableFunds.add(credit);
                }
                result.setAvailableFunds(nf.format(availableFunds));
                result.setAvailableFundsCurrency(currency);
            }
        }
        BigDecimal hold = MiscUtil.guarded((BigDecimal)BalanceHelper.calculateBalance((EntityReference)currentOrgRef, null, (Date)new Date(), (ChartOfAccountsElementType)ChartOfAccountsElementType.SUPPLIER_HOLD_SERVICE, (DictionaryReference)currencyInfo, dimensionTypeObjectMap));
        result.setHold(nf.format(hold));
        result.setHoldCurrency(currency);
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)result);
    }

    private boolean isUnlimitedCredit(EntityReference<Organization> agencyRef, EntityReference<Organization> supplierAgencyRef) {
        List creditLimits = ((Organization)EntityStorage.get().resolve(agencyRef).getEntity()).getFinanceRestrictions().getCreditLimits();
        return creditLimits.stream().filter(cl -> MiscUtil.equals((Object)cl.getCreditor(), (Object)supplierAgencyRef)).anyMatch(CreditLimitInfo::isUnlimited);
    }
}

