/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.cabinet.getBalancesClients;

import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.BillingTransactionHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.ContractCustomerIndex;
import com.gridnine.xtrip.common.model.profile.CreditLimitInfo;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.cabinet.CabinetHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.BalanceClientsReference;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.GetBalancesClientsParameters;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.GetBalancesClientsResult;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;

@Deprecated
public class GetBalancesClientsProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        EntityContainer perCont;
        Person loginAgent;
        EntityReference<Organization> agencyRef;
        GetBalancesClientsParameters request = (GetBalancesClientsParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        int limit = 0;
        if (request.getLimit() != null) {
            if (request.getLimit() <= 0) {
                throw Xeption.forDeveloper((String)"limit <= 0", (Object[])new Object[0]);
            }
            if (request.getLimit() > 100) {
                throw Xeption.forDeveloper((String)"limit > 100", (Object[])new Object[0]);
            }
            limit = request.getLimit();
        }
        if ((agencyRef = CabinetHelper.findPlaceOFWorkReference(loginAgent = (Person)(perCont = EntityStorage.get().resolve((EntityReference)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.AUTHORIZED_USER))).getEntity())) == null) {
            throw Xeption.forDeveloper((String)"No agency found for agent profile", (Object[])new Object[0]);
        }
        GetBalancesClientsResult result = new GetBalancesClientsResult();
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ContractCustomerIndex.Property.contractType.name(), (Object)ContractType.CLIENT));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ContractCustomerIndex.Property.supplier.name(), agencyRef));
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractCustomerIndex.Property.startDate.name(), null), SearchCriterion.le((String)ContractCustomerIndex.Property.startDate.name(), (Object)MiscUtil.setDayEndTime((Date)new Date()))}));
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractCustomerIndex.Property.endDate.name(), null), SearchCriterion.ge((String)ContractCustomerIndex.Property.endDate.name(), (Object)MiscUtil.clearTime((Date)new Date()))}));
        List indices = EntityStorage.get().search(ContractCustomerIndex.class, query).getData();
        Collections.sort(indices, CabinetHelper.createClientsComparator());
        DecimalFormat df = new DecimalFormat("###.##");
        for (ContractCustomerIndex cci : indices) {
            EntityReference clientRef = cci.getCustomer();
            if (clientRef == null) continue;
            BigDecimal balance = BillingTransactionHelper.calculateBillingTransactionsSum((ContractType)ContractType.CLIENT, (EntityReference)clientRef, agencyRef, null, null, null, null, null);
            CreditLimitInfo clientCreditLimitInfo = ProfileHelper.getOrganizationCreditLimit((EntityReference)clientRef, agencyRef);
            BigDecimal credit = ProfileHelper.getCreditAmount((CreditLimitInfo)clientCreditLimitInfo);
            BalanceClientsReference balanceRef = new BalanceClientsReference();
            balanceRef.setClient(clientRef.getCaption());
            if (balance != null) {
                if (credit != null) {
                    balanceRef.setAvailableFunds(df.format(balance.add(credit)));
                } else {
                    balanceRef.setAvailableFunds(df.format(balance));
                }
                balanceRef.setOwnFunds(df.format(balance));
            }
            if (clientCreditLimitInfo != null) {
                balanceRef.setUnlimitedCredit(clientCreditLimitInfo.isUnlimited());
            }
            if (credit != null) {
                balanceRef.setCredit(df.format(credit));
            }
            balanceRef.setIndividualBalance("");
            balanceRef.setTemporarilyBlocked("");
            result.getBalancesClients().add(balanceRef);
            if (result.getBalancesClients().size() != limit) continue;
            break;
        }
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)result);
    }
}

