/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.cabinet.getBalancesCompany;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.ibecorp.CurrencyHelper;
import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.ibecorp.restriction.resource.IbeRestrictionGroupResources;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFileIndex;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.finance.ChartOfAccountsElementType;
import com.gridnine.xtrip.common.model.finance.CompanyRelation;
import com.gridnine.xtrip.common.model.finance.DimensionType;
import com.gridnine.xtrip.common.model.finance.TransactionSplitIndex;
import com.gridnine.xtrip.common.model.helpers.BalanceHelper;
import com.gridnine.xtrip.common.model.helpers.FinanceHelper;
import com.gridnine.xtrip.common.model.helpers.ModelHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.CreditLimitInfo;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.system.BillingTransactionCategory;
import com.gridnine.xtrip.common.restriction.resource.standard.StandardRestrictionResourceOperations;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.common.security.acl.resource.AclResourceOperationPermission;
import com.gridnine.xtrip.common.util.DateUtils;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.cabinet.CabinetHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.GetBalancesCompanyParameters;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.GetBalancesCompanyResult;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.GetBalancesCompanyResultSummary;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.RestTransaction;
import com.gridnine.xtrip.server.ibecorp.common.rest.CommonConverterHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.authorization.AuthorizationHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import com.gridnine.xtrip.server.security.acl.helper.AclHelper;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;

public class GetBalancesCompanyProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        String currency;
        EntityReference clientOrgRef;
        GetBalancesCompanyParameters request = (GetBalancesCompanyParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        Locale locale = LocaleHelper.getCurrentLocale();
        EntityContainer authorizedUserCtr = EntityStorage.get().resolve((EntityReference)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.AUTHORIZED_USER));
        if (Objects.equals(AclHelper.getPermission(null, (String)IbeRestrictionGroupResources.GROUP_BALANCE.getId(), (String)((Person)authorizedUserCtr.getEntity()).getLoginName(), (String)StandardRestrictionResourceOperations.USE.getId(), Collections.emptyList()), AclResourceOperationPermission.DENY)) {
            ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)new GetBalancesCompanyResult());
            return;
        }
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        EntityReference currentOrgRef = (EntityReference)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.CURRENT_ORGANIZATION);
        Person authorizedUser = (Person)authorizedUserCtr.getEntity();
        EntityReference supplierAgencyRef = AuthorizationHelper.isCorporantAuthorized(authorizedUser) ? salesContext.getSubagency() : salesContext.getAgency();
        GetBalancesCompanyResult result = new GetBalancesCompanyResult();
        ContractType balanceContractType = AuthorizationHelper.isCorporantAuthorized(authorizedUser) ? ContractType.CLIENT : ContractType.SUBAGENCY;
        Map<DimensionType, EntityReference> dimensionTypeObjectMap = Collections.singletonMap(DimensionType.ORGANIZATION, supplierAgencyRef);
        NumberFormat nf = CabinetHelper.getNumberFormat(locale);
        if (!currentOrgRef.equals((Object)supplierAgencyRef)) {
            result.setSummary(new GetBalancesCompanyResultSummary());
            String currency2 = CurrencyHelper.getCurrency((EntityReference)supplierAgencyRef, (EntityReference)currentOrgRef, (ContractType)balanceContractType);
            DictionaryReference currencyInfo = FinanceHelper.getCurrency((String)currency2);
            if (request.getPageSize() != null && request.getPage() != null && request.getStartDate() != null && request.getOrganization() != null) {
                int fromIndex = request.getPage() * request.getPageSize();
                int toIndex = request.getPage() * request.getPageSize() + request.getPageSize();
                String pattern = null;
                if (StringUtils.isNotBlank((String)request.getPattern())) {
                    pattern = "%" + request.getPattern() + "%";
                }
                ArrayList searchResultIndices = new ArrayList();
                BigDecimal creditSum = null;
                BigDecimal debitSum = null;
                if (request.getCompanyRelationWith() == CompanyRelation.AGENCY) {
                    List transactionIndexes = BalanceHelper.getTransactionIndexes((EntityReference)currentOrgRef, (Date)MiscUtil.clearTime((Date)DateUtils.toJavaDate((LocalDate)request.getStartDate())), (Date)MiscUtil.setDayEndTime((Date)DateUtils.toJavaDate((LocalDate)request.getEndDate())), (Date)new Date(), (ChartOfAccountsElementType)ChartOfAccountsElementType.SUPPLIER, (DictionaryReference)currencyInfo, dimensionTypeObjectMap, null, (String)pattern, (TransactionSplitIndex.Property)TransactionSplitIndex.Property.operationDate, (SortOrder)SortOrder.DESC);
                    result.getSummary().setCount(String.valueOf(transactionIndexes.size()));
                    if (fromIndex < transactionIndexes.size()) {
                        toIndex = toIndex > transactionIndexes.size() ? transactionIndexes.size() : toIndex;
                        searchResultIndices.addAll(transactionIndexes.subList(fromIndex, toIndex));
                    }
                    creditSum = BalanceHelper.calculateBalance((EntityReference)currentOrgRef, (Date)MiscUtil.clearTime((Date)DateUtils.toJavaDate((LocalDate)request.getStartDate())), (Date)MiscUtil.setDayEndTime((Date)DateUtils.toJavaDate((LocalDate)request.getEndDate())), (Date)new Date(), (ChartOfAccountsElementType)ChartOfAccountsElementType.SUPPLIER, (DictionaryReference)currencyInfo, dimensionTypeObjectMap, (boolean)true);
                    debitSum = BalanceHelper.calculateBalance((EntityReference)currentOrgRef, (Date)MiscUtil.clearTime((Date)DateUtils.toJavaDate((LocalDate)request.getStartDate())), (Date)MiscUtil.setDayEndTime((Date)DateUtils.toJavaDate((LocalDate)request.getEndDate())), (Date)new Date(), (ChartOfAccountsElementType)ChartOfAccountsElementType.SUPPLIER, (DictionaryReference)currencyInfo, dimensionTypeObjectMap, (boolean)false);
                } else if (request.getCompanyRelationWith() == CompanyRelation.CLIENT) {
                    Map<DimensionType, EntityReference> dtoMap;
                    DictionaryReference currInfo;
                    EntityReference org;
                    if (balanceContractType == ContractType.CLIENT) {
                        org = currentOrgRef;
                        currInfo = currencyInfo;
                        dtoMap = dimensionTypeObjectMap;
                    } else {
                        org = request.getOrganization();
                        String clientCurrency = CurrencyHelper.getCurrency((EntityReference)currentOrgRef, (EntityReference)org, (ContractType)ContractType.CLIENT);
                        currInfo = FinanceHelper.getCurrency((String)clientCurrency);
                        dtoMap = Collections.singletonMap(DimensionType.ORGANIZATION, currentOrgRef);
                    }
                    List transactionIndexes = BalanceHelper.getTransactionIndexes((EntityReference)org, (Date)MiscUtil.clearTime((Date)DateUtils.toJavaDate((LocalDate)request.getStartDate())), (Date)MiscUtil.setDayEndTime((Date)DateUtils.toJavaDate((LocalDate)request.getEndDate())), (Date)new Date(), (ChartOfAccountsElementType)ChartOfAccountsElementType.SUPPLIER, (DictionaryReference)currInfo, dtoMap, (Boolean)Boolean.TRUE, (String)pattern, (TransactionSplitIndex.Property)TransactionSplitIndex.Property.operationDate, (SortOrder)SortOrder.DESC);
                    result.getSummary().setCount(String.valueOf(transactionIndexes.size()));
                    if (fromIndex < transactionIndexes.size()) {
                        toIndex = toIndex > transactionIndexes.size() ? transactionIndexes.size() : toIndex;
                        searchResultIndices.addAll(transactionIndexes.subList(fromIndex, toIndex));
                    }
                    creditSum = BalanceHelper.calculateBalance((EntityReference)org, (Date)MiscUtil.clearTime((Date)DateUtils.toJavaDate((LocalDate)request.getStartDate())), (Date)MiscUtil.setDayEndTime((Date)DateUtils.toJavaDate((LocalDate)request.getEndDate())), (Date)new Date(), (ChartOfAccountsElementType)ChartOfAccountsElementType.SUPPLIER, (DictionaryReference)currInfo, dtoMap, (boolean)true);
                }
                if (creditSum == null) {
                    creditSum = BigDecimal.ZERO;
                }
                if (debitSum == null) {
                    debitSum = BigDecimal.ZERO;
                }
                result.getSummary().setDebitSum(nf.format(debitSum));
                result.getSummary().setCreditSum(nf.format(creditSum));
                Object[] bookingUids = (String[])searchResultIndices.stream().map(TransactionSplitIndex::getBookingUid).filter(Objects::nonNull).toArray(String[]::new);
                ArrayList bfIndexData = new ArrayList();
                if (bookingUids.length > 0) {
                    SearchQuery bookingFileQuery = new SearchQuery();
                    bookingFileQuery.getCriteria().getCriterions().add(SearchCriterion.in((String)"containerUid", (Object[])bookingUids));
                    bookingFileQuery.getPreferredProperties().add(BookingFileIndex.Property.fullNumber.name());
                    bookingFileQuery.getPreferredProperties().add(BookingFileIndex.Property.agent.name());
                    bfIndexData.addAll(EntityStorage.get().search(BookingFileIndex.class, bookingFileQuery).getData());
                }
                HashMap bookingFileIndexMap = new HashMap(bfIndexData.size());
                bfIndexData.forEach(idx -> bookingFileIndexMap.put(idx.getSource().getUid(), idx));
                for (TransactionSplitIndex splitIndex : searchResultIndices) {
                    RestTransaction reference = new RestTransaction();
                    if (splitIndex.getBookingUid() != null) {
                        BookingFileIndex bookingFileIndex = (BookingFileIndex)bookingFileIndexMap.get(splitIndex.getBookingUid());
                        reference.setAgent(CommonConverterHelper.getReferenceCaption(bookingFileIndex.getAgent()));
                        reference.setBookingNumber(bookingFileIndex.getFullNumber());
                    }
                    reference.setCompany(CommonConverterHelper.getReferenceCaption(splitIndex.getOrganization()));
                    if (splitIndex.isCredit()) {
                        reference.setOutcome(nf.format(ModelHelper.long2BigDecimal((long)splitIndex.getAmount())));
                        reference.setOperationType(BillingTransactionCategory.CREDIT.toString());
                    } else {
                        reference.setIncome(nf.format(ModelHelper.long2BigDecimal((long)splitIndex.getAmount())));
                        reference.setOperationType(BillingTransactionCategory.DEBIT.toString());
                    }
                    reference.setOperationDate(DateUtils.toLocalDate((Date)splitIndex.getOperationDate()));
                    reference.setNotes(splitIndex.getDescription());
                    result.getBalancesCompany().add(reference);
                }
            }
            if (!this.isUnlimitedCredit((EntityReference<Organization>)currentOrgRef, (EntityReference<Organization>)supplierAgencyRef)) {
                BigDecimal balance = MiscUtil.guarded((BigDecimal)BalanceHelper.calculateBalance((EntityReference)currentOrgRef, null, null, (Date)new Date(), (ChartOfAccountsElementType)ChartOfAccountsElementType.SUPPLIER, (DictionaryReference)currencyInfo, dimensionTypeObjectMap));
                BigDecimal credit = ProfileHelper.getOrganizationCreditAmount((EntityReference)currentOrgRef, (EntityReference)supplierAgencyRef);
                if (balanceContractType == ContractType.SUBAGENCY) {
                    BigDecimal availableFunds;
                    List<EntityReference<Organization>> clients = CabinetHelper.findCorporateClients((EntityReference<Organization>)currentOrgRef);
                    EntityReference<Organization> retailClient = clients.isEmpty() ? null : clients.get(0);
                    String retailClientCurrency = retailClient != null ? CurrencyHelper.getCurrency((EntityReference)currentOrgRef, retailClient, (ContractType)ContractType.CLIENT) : currency2;
                    BigDecimal availableFundsSubagent = balance;
                    BigDecimal ownFunds = availableFunds = CurrencyHelper.exchange((BigDecimal)balance, (String)currency2, (String)retailClientCurrency);
                    if (credit != null) {
                        availableFunds = availableFunds.add(CurrencyHelper.exchange((BigDecimal)credit, (String)currency2, (String)retailClientCurrency));
                        availableFundsSubagent = availableFundsSubagent.add(credit);
                    }
                    result.setAvailableFunds(nf.format(availableFunds));
                    result.setAvailableFundsCurrency(retailClientCurrency);
                    result.setAvailableFundsSubagent(nf.format(availableFundsSubagent));
                    result.setAvailableFundsSubagentCurrency(currency2);
                    result.setOwnFunds(nf.format(ownFunds));
                } else {
                    BigDecimal availableFunds = balance;
                    if (credit != null) {
                        availableFunds = availableFunds.add(credit);
                    }
                    result.setAvailableFunds(nf.format(availableFunds));
                    result.setAvailableFundsCurrency(currency2);
                    result.setOwnFunds(nf.format(balance));
                }
            }
        }
        if ((clientOrgRef = request.getClientOrganization()) != null && !clientOrgRef.equals((Object)currentOrgRef) && CabinetHelper.findCorporateClients((EntityReference<Organization>)currentOrgRef).contains(clientOrgRef) && !this.isUnlimitedCredit((EntityReference<Organization>)clientOrgRef, (EntityReference<Organization>)currentOrgRef)) {
            currency = CurrencyHelper.getCurrency((EntityReference)currentOrgRef, (EntityReference)clientOrgRef, (ContractType)balanceContractType);
            DictionaryReference currencyInfo = FinanceHelper.getCurrency((String)currency);
            Map<DimensionType, EntityReference> clientDimensionTypeObjectMap = Collections.singletonMap(DimensionType.ORGANIZATION, currentOrgRef);
            BigDecimal balance = MiscUtil.guarded((BigDecimal)BalanceHelper.calculateBalance((EntityReference)clientOrgRef, null, null, (Date)new Date(), (ChartOfAccountsElementType)ChartOfAccountsElementType.SUPPLIER, (DictionaryReference)currencyInfo, clientDimensionTypeObjectMap));
            String clientCurrency = CurrencyHelper.getCurrency((EntityReference)currentOrgRef, (EntityReference)clientOrgRef, (ContractType)balanceContractType);
            BigDecimal availableFunds = balance;
            BigDecimal credit = ProfileHelper.getOrganizationCreditAmount((EntityReference)clientOrgRef, (EntityReference)currentOrgRef);
            if (credit != null) {
                availableFunds = availableFunds.add(credit);
            }
            result.setAvailableClientFunds(nf.format(availableFunds));
            result.setAvailableClientFundsCurrency(clientCurrency);
            result.setClientOwnFunds(nf.format(balance));
            BigDecimal hold = MiscUtil.guarded((BigDecimal)BalanceHelper.calculateBalance((EntityReference)clientOrgRef, null, null, (Date)new Date(), (ChartOfAccountsElementType)ChartOfAccountsElementType.SUPPLIER_HOLD_SERVICE, (DictionaryReference)currencyInfo, clientDimensionTypeObjectMap));
            result.setHold(nf.format(hold));
            result.setHoldCurrency(currency);
        } else if (!currentOrgRef.equals((Object)supplierAgencyRef)) {
            currency = CurrencyHelper.getCurrency((EntityReference)supplierAgencyRef, (EntityReference)currentOrgRef, (ContractType)balanceContractType);
            DictionaryReference currencyInfo = FinanceHelper.getCurrency((String)currency);
            BigDecimal hold = MiscUtil.guarded((BigDecimal)BalanceHelper.calculateBalance((EntityReference)currentOrgRef, null, null, (Date)new Date(), (ChartOfAccountsElementType)ChartOfAccountsElementType.SUPPLIER_HOLD_SERVICE, (DictionaryReference)currencyInfo, dimensionTypeObjectMap));
            result.setHold(nf.format(hold));
            result.setHoldCurrency(currency);
        }
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)result);
    }

    private boolean isUnlimitedCredit(EntityReference<Organization> agencyRef, EntityReference<Organization> supplierAgencyRef) {
        List creditLimits = ((Organization)EntityStorage.get().resolve(agencyRef).getEntity()).getFinanceRestrictions().getCreditLimits();
        return creditLimits.stream().filter(cl -> MiscUtil.equals((Object)cl.getCreditor(), (Object)supplierAgencyRef)).anyMatch(CreditLimitInfo::isUnlimited);
    }
}

