/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.cabinet.getCertificateOfCompletedFlight;

import com.gridnine.xtrip.common.jr.JasperUtil;
import com.gridnine.xtrip.common.model.BaseIdentity;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.additionalservice.AdditionalServiceProduct;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.system.BaseFileDocument;
import com.gridnine.xtrip.common.model.system.BasicDocumentIndex;
import com.gridnine.xtrip.common.model.system.BinaryData;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.model.system.DocumentType;
import com.gridnine.xtrip.common.model.system.DownloadableData;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SearchResult;
import com.gridnine.xtrip.common.search.utils.SearchQueryHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.cabinet.CabinetHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.GetCertificateOfCompletedFlightParameters;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class GetCertificateOfCompletedFlightProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        GetCertificateOfCompletedFlightParameters parameters = (GetCertificateOfCompletedFlightParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        EntityReference bookingFile = parameters.getBooking();
        Reservation reservation = BookingHelper.findReservation((BookingFile)((BookingFile)EntityStorage.get().resolve(parameters.getBooking()).getEntity()), (String)parameters.getPnr());
        if (reservation != null) {
            List<String> products = reservation.getProducts().stream().filter(baseProduct -> baseProduct instanceof AdditionalServiceProduct).map(BaseIdentity::getUid).collect(Collectors.toList());
            List<DataHolder> itineraryData = this.getData((EntityReference<BookingFile>)bookingFile, products);
            List<DownloadableData> docs = itineraryData.stream().map(this::buildPDF2Download).collect(Collectors.toList());
            if (docs.size() == 0) {
                return;
            }
            DownloadableData result = docs.size() > 1 ? CabinetHelper.buildZIP2Download(docs, "certificatesOfCompletedFlight.zip") : docs.get(0);
            ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)result);
        }
    }

    private List<DataHolder> getData(EntityReference<BookingFile> bookingFile, List<String> productsUids) throws Exception {
        SearchQuery query = this.buildQuery(bookingFile);
        query.getCriteria().getCriterions().add(SearchQueryHelper.buildOrEqStringCriterion((String)"navigationKey", productsUids));
        SearchResult searchResult = EntityStorage.get().search(BasicDocumentIndex.class, query);
        return this.getTemplateData((SearchResult<BasicDocumentIndex>)searchResult);
    }

    private SearchQuery buildQuery(EntityReference<BookingFile> bookingFile) {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BasicDocumentIndex.Property.owner.name(), bookingFile));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BasicDocumentIndex.Property.type.name(), (Object)DocumentType.RECEIPT));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BasicDocumentIndex.Property.contentType.name(), (Object)ContentType.JASPERPRINT));
        return query;
    }

    private List<DataHolder> getTemplateData(SearchResult<BasicDocumentIndex> searchResult) throws Exception {
        ArrayList<DataHolder> dataHolders = new ArrayList<DataHolder>();
        for (int i = 0; i < searchResult.getData().size(); ++i) {
            BaseFileDocument doc = (BaseFileDocument)EntityStorage.get().resolve(((BasicDocumentIndex)searchResult.getData().get(i)).getSource()).getEntity();
            byte[] content = doc.getContentType() == ContentType.JASPERPRINT ? JasperUtil.convertToPdf((byte[])doc.getContent()) : doc.getContent();
            dataHolders.add(new DataHolder(doc.getName(), content));
        }
        return dataHolders;
    }

    private DownloadableData buildPDF2Download(DataHolder holder) {
        DownloadableData result = new DownloadableData();
        BinaryData binaryData = new BinaryData();
        String documentName = holder.documentName.endsWith(".pdf") ? holder.documentName : holder.documentName + ".pdf";
        binaryData.setContentType(ContentType.PDF);
        binaryData.setData(holder.payload);
        result.setFileName(documentName);
        result.setContent(binaryData);
        return result;
    }

    private static class DataHolder {
        private final byte[] payload;
        private final String documentName;

        private DataHolder(String documentName, byte[] payload) {
            Objects.requireNonNull(documentName);
            Objects.requireNonNull(payload);
            this.documentName = documentName;
            this.payload = payload;
        }
    }
}

