/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.cabinet.getContracts;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.profile.ContractIndex;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.cabinet.CabinetConverterHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.cabinet.CabinetHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.ContractsParameters;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.ContractsResult;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class GetContractsProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        ContractsParameters params = (ContractsParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        CabinetHelper.checkRequestPaginationParameters(params.getPage(), params.getPageSize());
        ContractsResult result = new ContractsResult();
        SearchQuery query = CabinetHelper.buildClientsQuery((EntityReference<Organization>)salesContext.getSubagency());
        if (StringUtils.isNotBlank((String)params.getPattern())) {
            String pattern = "%" + params.getPattern() + "%";
            query.getCriteria().getCriterions().add(SearchCriterion.ilike((String)ContractIndex.Property.name.name(), (String)pattern));
        }
        result.setCount(CabinetHelper.queryCount(query, ContractIndex.class));
        EntityStorage es = EntityStorage.get();
        List contractCtrs = CabinetHelper.queryPageData(query, ContractIndex.class, params.getPage(), params.getPageSize(), SortOrder.ASC, ContractIndex.Property.name.name()).stream().map(ContractIndex::getSource).map(arg_0 -> ((EntityStorage)es).resolve(arg_0)).collect(Collectors.toList());
        result.getContracts().addAll(contractCtrs.stream().map(CabinetConverterHelper::convertContract2ContractListItem).collect(Collectors.toList()));
        result.getContractTypes().add(ContractType.CLIENT);
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)result);
    }
}

