/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.cabinet.getEmployeeFormData;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.booking.RestBookingHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.cabinet.CabinetConverterHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.cabinet.CabinetHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.EmployeeOrganizationCostCode;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.EmployeeOrganizationInfoConfig;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.GetEmployeeFormDataParameters;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.GetEmployeeFormDataResult;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.util.List;

public class GetEmployeeFormDataProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        GetEmployeeFormDataParameters params = (GetEmployeeFormDataParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        EmployeeOrganizationInfoConfig info = this.convertOrganization2EmployeeOrganizationInfo(params);
        GetEmployeeFormDataResult result = new GetEmployeeFormDataResult();
        result.setOrganizationInfo(info);
        result.setHideSystemAccess(!CabinetHelper.updateUserAccountGranted());
        result.setEmployeeCategoryAccess(CabinetHelper.updateUserAccountCategoryGranted());
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)result);
    }

    private EmployeeOrganizationInfoConfig convertOrganization2EmployeeOrganizationInfo(GetEmployeeFormDataParameters params) {
        EntityReference orgRef = params.getOrganization();
        if (orgRef == null) {
            return null;
        }
        EmployeeOrganizationInfoConfig result = new EmployeeOrganizationInfoConfig();
        result.setOrganization(orgRef);
        Organization org = (Organization)EntityStorage.get().resolve(orgRef).getEntity();
        org.getEmployeeCategories().stream().map(CabinetConverterHelper::convertEmployeeCategoryToRest).forEach(result.getEmployeeCategoryInfos()::add);
        result.getRoles().addAll(org.getAclSettings().getOrganizationAclRoles());
        List<EmployeeOrganizationCostCode> organizationCostCodes = RestBookingHelper.getEmployeeOrganizationCostCodes(org, params.getPersonCostCodes());
        result.getCostCodesInfo().addAll(organizationCostCodes);
        return result;
    }
}

