/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.cabinet.getEmployees;

import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonEmployment;
import com.gridnine.xtrip.common.model.profile.PersonIndex;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.autocomplete.organizations.CorporateClientHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.cabinet.CabinetConverterHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.cabinet.CabinetHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.GetEmployeesParameters;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.GetEmployeesResult;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import com.gridnine.xtrip.server.security.acl.helper.AclHelper;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class GetEmployeesProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        GetEmployeesParameters params = (GetEmployeesParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        EntityContainer userCtr = EntityStorage.get().resolve((EntityReference)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.AUTHORIZED_USER));
        CabinetHelper.checkRequestPaginationParameters(params.getPage(), params.getPageSize());
        boolean includeDisabled = params.isIncludeDisabled() != null && params.isIncludeDisabled() != false;
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.isNotEmpty((String)PersonIndex.Property.employmentsUids.name()));
        if (!includeDisabled) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)PersonIndex.Property.disabled.name(), (Object)Boolean.FALSE));
        }
        if (StringUtils.isNotBlank((String)params.getPattern())) {
            String pattern = "%" + params.getPattern() + "%";
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.ilike((String)PersonIndex.Property.name.name(), (String)pattern), SearchCriterion.ilike((String)PersonIndex.Property.englishFirstName.name(), (String)pattern), SearchCriterion.ilike((String)PersonIndex.Property.englishLastName.name(), (String)pattern)}));
        }
        HashSet<Object> employerRefs = new HashSet<Object>();
        if (params.getClient() != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.contains((String)PersonIndex.Property.employmentsUids.name(), (Object)params.getClient().getUid()));
            employerRefs.add(params.getClient());
        } else {
            EntityReference currentOrg = (EntityReference)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.CURRENT_ORGANIZATION);
            employerRefs.addAll(CorporateClientHelper.getCorporateClients((EntityReference<Organization>)currentOrg, true));
        }
        AclHelper.modifyQuery((SearchQuery)query, (String)PersonIndex.class.getName(), (String)((Person)userCtr.getEntity()).getLoginName(), Collections.emptyList());
        query.getPreferredProperties().add("containerUid");
        GetEmployeesResult result = new GetEmployeesResult();
        result.setCount(CabinetHelper.queryCount(query, PersonIndex.class));
        List<PersonIndex> employeeIndices = CabinetHelper.queryPageData(query, PersonIndex.class, params.getPage(), params.getPageSize(), SortOrder.ASC, PersonIndex.Property.name.name());
        employeeIndices.stream().map(EntityIndex::getSource).map(personRef -> EntityStorage.get().resolve(personRef)).map(personCtr -> this.person2PersonEmployersMap((EntityContainer<Person>)personCtr, employerRefs)).map(CabinetConverterHelper::convertPersonEmployersMap2PersonListItem).collect(Collectors.toCollection(() -> ((GetEmployeesResult)result).getEmployees()));
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)result);
    }

    private MiscUtil.Pair<EntityContainer<Person>, Set<EntityReference<Organization>>> person2PersonEmployersMap(EntityContainer<Person> personCtr, Set<EntityReference<Organization>> employerRefs) {
        LinkedHashSet personEmployerRefs = new LinkedHashSet();
        ((Person)personCtr.getEntity()).getEmployments().stream().sorted(Comparator.comparing(PersonEmployment::isMainEmployment).reversed()).map(PersonEmployment::getOrganization).filter(employerRefs::contains).forEach(personEmployerRefs::add);
        return new MiscUtil.Pair(personCtr, personEmployerRefs);
    }
}

