/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.cabinet.getFilteringAirlines;

import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.ProductIndex;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.parameters.EntityStorageSearchParameters;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonType;
import com.gridnine.xtrip.common.search.Projection;
import com.gridnine.xtrip.common.search.ProjectionQuery;
import com.gridnine.xtrip.common.search.ProjectionResult;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.cabinet.CabinetHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.avia.AviaConverterHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.GetAirlinesResult;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;

public class GetFilteringAirlinesProcessor
extends BaseProcessor {
    static List<Airline> getFilteringAirlines(EntityContainer<Person> personCtr) throws Exception {
        EntityReference<Organization> subAgencyRef = CabinetHelper.findAgencyReference((Person)personCtr.getEntity());
        if (subAgencyRef != null) {
            ProjectionQuery query = new ProjectionQuery();
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ProductIndex.Property.subagency.name(), subAgencyRef));
            if (((Person)personCtr.getEntity()).getTypes().contains(PersonType.PASSENGER)) {
                EntityReference<Organization> corpClientRef = CabinetHelper.findPlaceOFWorkReference((Person)personCtr.getEntity());
                if (corpClientRef == null) {
                    throw Xeption.forDeveloper((String)("No corporate client found for agent: " + personCtr.getEntity()), (Object[])new Object[0]);
                }
                query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ProductIndex.Property.client.name(), corpClientRef));
            }
            query.getCriteria().getCriterions().add(SearchCriterion.ne((String)ProductIndex.Property.carrier.name(), null));
            query.getProjections().add(Projection.group((String)"carrier", (String)"carrierGroup"));
            query.getProjections().add(Projection.property((String)"carrier", (String)"carrier"));
            ProjectionResult productSummary = EntityStorage.get().search(ProductIndex.class, query, (EntityStorageSearchParameters)new EntityStorageSearchParameters().noCache(true));
            return productSummary.getData().stream().map(aliases -> (String)aliases.get("carrier")).map(carrierName -> (Airline)DictionaryCache.get().findByCode(Airline.class, carrierName)).collect(Collectors.toList());
        }
        return Collections.EMPTY_LIST;
    }

    public void process(MessageContext ctx) throws Exception {
        EntityReference personRef = (EntityReference)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.AUTHORIZED_USER);
        EntityContainer personCtr = EntityStorage.get().resolve(personRef);
        List<Airline> relatedAirlines = GetFilteringAirlinesProcessor.getFilteringAirlines((EntityContainer<Person>)personCtr);
        Date now = new Date();
        Locale locale = LocaleHelper.getCurrentLocale();
        GetAirlinesResult result = new GetAirlinesResult();
        result.getAirlines().addAll(relatedAirlines.stream().filter(Objects::nonNull).filter(airline -> airline.getCloseDate() == null || now.before(airline.getCloseDate())).map(airline -> AviaConverterHelper.convertAirlineReference2Rest(airline, locale)).collect(Collectors.toList()));
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)result);
    }
}

