/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.cabinet.getFinance;

import com.gridnine.xtrip.common.ibecorp.CurrencyHelper;
import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.finance.BillingItem;
import com.gridnine.xtrip.common.model.finance.BillingItemsList;
import com.gridnine.xtrip.common.model.finance.FinanceDocument;
import com.gridnine.xtrip.common.model.finance.FinanceDocumentData;
import com.gridnine.xtrip.common.model.helpers.FinanceHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.BaseRulesContainer;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.rules.finance.InvoicePrepaymentActionSet;
import com.gridnine.xtrip.common.model.rules.finance.InvoicePrepaymentPropertySet;
import com.gridnine.xtrip.common.model.rules.finance.Targets;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.model.system.VatAmount;
import com.gridnine.xtrip.common.rules.RuleEngine;
import com.gridnine.xtrip.common.rules.RuleResult;
import com.gridnine.xtrip.common.rules.RuleResultHandler;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.RuleSettings;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.cabinet.getFinance.IBusCabinetFinanceContextKeys;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.CreatePrepaymentInvoiceParameters;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import com.gridnine.xtrip.server.model.ibus.finance.documents.FinanceDocumentsIbusHelper;
import com.gridnine.xtrip.server.model.number.helpers.FinanceDocumentNameHelper;
import com.gridnine.xtrip.server.model.number.helpers.FinanceDocumentNumberHelper;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class CreatePrepaymentInvoiceProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        CreatePrepaymentInvoiceParameters request = (CreatePrepaymentInvoiceParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        EntityReference clientRef = (EntityReference)ctx.getMandatoryObject((Enum)IBusCabinetFinanceContextKeys.B2B_CABINET_FINANCE_CLIENT);
        EntityReference supplierRef = (EntityReference)ctx.getMandatoryObject((Enum)IBusCabinetFinanceContextKeys.B2B_CABINET_FINANCE_SUPPLIER);
        ContractType contractType = (ContractType)ctx.getMandatoryObject((Enum)IBusCabinetFinanceContextKeys.B2B_CABINET_FINANCE_CONTRACT_TYPE);
        String currency = CurrencyHelper.getCurrency((EntityReference)supplierRef, (EntityReference)clientRef, (ContractType)contractType);
        DictionaryReference currencyInfo = FinanceHelper.getCurrency((String)currency);
        EntityReference authorizedUserRef = (EntityReference)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.AUTHORIZED_USER);
        FinanceDocumentData financeDocumentData = this.getFinanceDocumentData((EntityReference<Organization>)supplierRef, (EntityReference<Contract>)request.getContract());
        FinanceDocument financeDocument = CreatePrepaymentInvoiceProcessor.createFinanceDocument(financeDocumentData);
        financeDocument.setDate(new Date());
        financeDocument.setPayer(clientRef);
        financeDocument.setAgency(supplierRef);
        financeDocument.setSupplier(supplierRef);
        if (request.getContract() != null) {
            financeDocument.setSupplierBankAccount(FinanceDocumentsIbusHelper.getBankAccount((EntityContainer)EntityStorage.get().resolve(request.getContract())));
        } else {
            financeDocument.setSupplierBankAccount(FinanceDocumentsIbusHelper.getBankAccount((EntityReference)supplierRef));
        }
        financeDocument.setCustomer(clientRef);
        financeDocument.setAgent(authorizedUserRef);
        financeDocument.setContract(request.getContract());
        financeDocument.setCurrency(currencyInfo);
        FinanceDocumentNumberHelper.generateNumber((FinanceDocument)financeDocument, (EntityStorageContext)new EntityStorageContext());
        FinanceDocumentNameHelper.generateName((FinanceDocument)financeDocument);
        financeDocument.getBillingItems().add(this.createBillingItem(request.getAmount(), request.getBillingItemName()));
        EntityContainer finDocumentContainer = EntityContainer.create((BaseEntity)financeDocument);
        ctx.putObject((Enum)IBusFinanceContextKeys.FINANCE_DOCUMENT_CONTAINER, (Object)finDocumentContainer);
    }

    private FinanceDocumentData getFinanceDocumentData(EntityReference<Organization> supplierRef, EntityReference<Contract> contractRef) throws Exception {
        EntityContainer contractContainer = EntityStorage.get().resolve(contractRef);
        RuleProxy proxy = new RuleProxy();
        Date date = new Date();
        proxy.setProxyType(Targets.INVOICE_PREPAYMENT.getId());
        proxy.setProxyDate(date);
        InvoicePrepaymentPropertySet propertySet = new InvoicePrepaymentPropertySet(proxy);
        propertySet.init(supplierRef, ((Contract)contractContainer.getEntity()).getAgreementType());
        proxy.setPropertySet((Object)propertySet);
        proxy.setActionSet((Object)new InvoicePrepaymentActionSet());
        List rules = ProfileHelper.getRuleContainers((EntityContainer)contractContainer, (Date)date);
        for (EntityContainer rule : rules) {
            RuleSet ruleSet = ((BaseRulesContainer)rule.getEntity()).getRuleSet();
            RuleEngine.applyRules(Collections.singletonList(proxy), (RuleSet)ruleSet, (RuleResultHandler)new RuleResultHandler(){

                public boolean isProcessAllRuleResults() {
                    return true;
                }

                public void processRuleResult(RuleProxy<?, ?> proxy, RuleSettings ruleSettings, RuleResult ruleResult) {
                }
            });
        }
        FinanceDocumentData data = ((InvoicePrepaymentActionSet)proxy.getActionSet()).getData();
        if (data == null) {
            throw Xeption.forEndUser((String)"\u0428\u0430\u0431\u043b\u043e\u043d \u0441\u0447\u0435\u0442\u0430 \u043d\u0430 \u043f\u0440\u0435\u0434\u043e\u043f\u043b\u0430\u0442\u0443 \u043d\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d. \u041e\u0431\u0440\u0430\u0442\u0438\u0442\u0435\u0441\u044c \u0432 \u0430\u0433\u0435\u043d\u0442\u0441\u0442\u0432\u043e.", (Object[])new Object[0]);
        }
        return data;
    }

    private static FinanceDocument createFinanceDocument(FinanceDocumentData data) {
        FinanceDocument doc = new FinanceDocument();
        doc.setType(data.getType());
        doc.setTemplate(data.getTemplate());
        doc.setBillingItemIncludeMode(data.getBillingItemIncludeMode());
        doc.setVatViewMode(data.getVatViewMode());
        doc.setGroupByTraveller(data.isGroupByTraveller());
        doc.setNotGroupByProduct(data.isNotGroupByProduct());
        doc.setMergeBillingItems(data.getMergeBillingItems());
        doc.setUseDelegate(data.isUseDelegate());
        doc.setUseFacsimile(data.isUseFacsimile());
        doc.setCaptionTemplate(data.getCaptionTemplate());
        doc.setDisableCustomerQuotes(data.isDisableCustomerQuotes());
        doc.setDisplayContract(data.isDisplayContract());
        doc.setNotDisplayTitleContractNumber(data.isNotDisplayTitleContractNumber());
        doc.setNotGroupByServiceType(data.isNotGroupByServiceType());
        doc.setInvertSign(data.isInvertSign());
        doc.setVendorDocument(data.isVendorDocument());
        doc.setUniversalDocumentStatus(data.getUniversalDocumentStatus());
        doc.getCustomParameters().putAll(data.getCustomParameters());
        return doc;
    }

    private NestedEntityReference<BillingItemsList, BillingItem> createBillingItem(BigDecimal amount, String name) {
        EntityContainer billingItemsListContainer = EntityContainer.create((BaseEntity)new BillingItemsList());
        BillingItemsList billingItemsList = (BillingItemsList)billingItemsListContainer.getEntity();
        BillingItem billingItem = new BillingItem();
        billingItem.setName(TextUtil.nonBlank((String)name) ? name : "\u041f\u0440\u0435\u0434\u043e\u043f\u043b\u0430\u0442\u0430");
        billingItem.setPaymentType(PaymentType.INVOICE);
        billingItem.setAmount(VatAmount.of((BigDecimal)amount));
        billingItemsList.getData().add(billingItem);
        EntityStorage.get().save(billingItemsListContainer, true);
        return new NestedEntityReference(billingItemsListContainer, (BaseEntity)billingItem);
    }
}

