/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.cabinet.getFinance;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.finance.CompanyRelation;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.OrganizationType;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.cabinet.getFinance.IBusCabinetFinanceContextKeys;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.GetFinanceParameters;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;

public class GetContractorsDataProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        EntityReference supplierRef;
        EntityReference clientRef;
        GetFinanceParameters request = (GetFinanceParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        CompanyRelation relation = request.getCompanyRelationWith();
        if (relation == CompanyRelation.AGENCY) {
            clientRef = request.getContractor();
            supplierRef = request.getOrganization();
        } else {
            clientRef = request.getOrganization();
            supplierRef = request.getContractor();
        }
        ContractType contractType = ProfileHelper.isOrganizationType((EntityReference)clientRef, (OrganizationType)OrganizationType.CORPORATE_CLIENT) ? ContractType.CLIENT : ContractType.SUBAGENCY;
        ctx.putObject((Enum)IBusCabinetFinanceContextKeys.B2B_CABINET_FINANCE_CLIENT, (Object)clientRef);
        ctx.putObject((Enum)IBusCabinetFinanceContextKeys.B2B_CABINET_FINANCE_SUPPLIER, (Object)supplierRef);
        ctx.putObject((Enum)IBusCabinetFinanceContextKeys.B2B_CABINET_FINANCE_CONTRACT_TYPE, (Object)contractType);
    }
}

