/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.cabinet.getFinance;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.profile.ContractIndex;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.cabinet.getFinance.IBusCabinetFinanceContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.util.List;
import java.util.stream.Collectors;

public class GetContractsProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        EntityReference clientRef = (EntityReference)ctx.getMandatoryObject((Enum)IBusCabinetFinanceContextKeys.B2B_CABINET_FINANCE_CLIENT);
        EntityReference supplierRef = (EntityReference)ctx.getMandatoryObject((Enum)IBusCabinetFinanceContextKeys.B2B_CABINET_FINANCE_SUPPLIER);
        ContractType contractType = (ContractType)ctx.getMandatoryObject((Enum)IBusCabinetFinanceContextKeys.B2B_CABINET_FINANCE_CONTRACT_TYPE);
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ContractIndex.Property.supplier.name(), (Object)supplierRef));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ContractIndex.Property.customer.name(), (Object)clientRef));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ContractIndex.Property.contractType.name(), (Object)contractType));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ContractIndex.Property.disabled.name(), (Object)false));
        query.getCriteria().getOrders().put(ContractIndex.Property.defaultContract.name(), SortOrder.DESC);
        List contractIndices = EntityStorage.get().search(ContractIndex.class, query).getData();
        List contractRefs = contractIndices.stream().map(ContractIndex::getSource).collect(Collectors.toList());
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, contractRefs);
    }
}

