/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.cabinet.getFinance;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.finance.CompanyRelation;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationType;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.autocomplete.organizations.CorporateClientHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.cabinet.CabinetHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.GetFinanceFormDataParameters;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.GetFinanceFormDataResult;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.util.Comparator;

public class GetFinanceFormDataProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        GetFinanceFormDataParameters parameters = (GetFinanceFormDataParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        EntityReference contractorRef = parameters.getContractor() == null ? (EntityReference)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.CURRENT_ORGANIZATION) : parameters.getContractor();
        GetFinanceFormDataResult result = new GetFinanceFormDataResult();
        boolean isCorporateClient = ProfileHelper.isOrganizationType((EntityReference)contractorRef, (OrganizationType)OrganizationType.CORPORATE_CLIENT);
        if (isCorporateClient) {
            result.getCompanyRelationsWith().add(CompanyRelation.AGENCY);
            result.getAgencies().add(salesContext.getSubagency());
            result.setContractorSelectionAvailable(true);
            result.getContractors().addAll(CorporateClientHelper.getCorporateClients((EntityReference<Organization>)contractorRef, true));
        } else if (salesContext.getAgency().equals((Object)contractorRef)) {
            result.getCompanyRelationsWith().add(CompanyRelation.CLIENT);
            result.getClients().addAll(CabinetHelper.findAllClients((EntityReference<Organization>)contractorRef));
            result.getContractors().add(contractorRef);
        } else {
            result.getCompanyRelationsWith().add(CompanyRelation.AGENCY);
            result.getAgencies().add(salesContext.getAgency());
            result.getCompanyRelationsWith().add(CompanyRelation.CLIENT);
            result.getClients().addAll(CabinetHelper.findCorporateClients((EntityReference<Organization>)contractorRef));
            result.getContractors().add(contractorRef);
        }
        Comparator comparator = (o1, o2) -> o1 == null ? (o2 == null ? 0 : 1) : (o1.getCaption() == null ? (o2 == null ? -1 : (o2.getCaption() == null ? 0 : 1)) : (o2 == null ? -1 : (o2.getCaption() == null ? -1 : o1.getCaption().compareTo(o2.getCaption()))));
        result.getContractors().sort(comparator);
        result.getAgencies().sort(comparator);
        result.getClients().sort(comparator);
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)result);
    }
}

