/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.cabinet.getFinance;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.ibecorp.CurrencyHelper;
import com.gridnine.xtrip.common.ibecorp.restriction.resource.IbeRestrictionGroupResources;
import com.gridnine.xtrip.common.ibecorp.rules.FinanceActionSet;
import com.gridnine.xtrip.common.ibecorp.rules.FinancePropertySet;
import com.gridnine.xtrip.common.ibecorp.rules.Targets;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.midoffice.helper.SalesContextHandler;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFileIndex;
import com.gridnine.xtrip.common.model.booking.FinanceDocumentType;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.CurrencyInfo;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.finance.ChartOfAccountsElementType;
import com.gridnine.xtrip.common.model.finance.CompanyRelation;
import com.gridnine.xtrip.common.model.finance.DimensionType;
import com.gridnine.xtrip.common.model.finance.ExternalFinanceDocumentIndex;
import com.gridnine.xtrip.common.model.finance.FinanceDocumentRecordIndex;
import com.gridnine.xtrip.common.model.finance.ShipmentIndex;
import com.gridnine.xtrip.common.model.finance.TransactionSplitIndex;
import com.gridnine.xtrip.common.model.helpers.BalanceHelper;
import com.gridnine.xtrip.common.model.helpers.FinanceHelper;
import com.gridnine.xtrip.common.model.helpers.ModelHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.CreditLimitInfo;
import com.gridnine.xtrip.common.model.profile.FinanceDocumentSettings;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.BillingTransactionCategory;
import com.gridnine.xtrip.common.rules.RuleEngine;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.common.search.Projection;
import com.gridnine.xtrip.common.search.ProjectionQuery;
import com.gridnine.xtrip.common.search.ProjectionResult;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.DateUtils;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.cabinet.CabinetHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.cabinet.getFinance.IBusCabinetFinanceContextKeys;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.ExternalFinanceDocumentsData;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.ExternalFinanceDocumentsParameters;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.FinanceDocumentsData;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.FinanceDocumentsParameters;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.GetFinanceDataParameters;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.GetFinanceDataResult;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.RestExternalFinanceDocument;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.RestFinanceDocument;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.RestTransaction;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.TransactionsData;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.TransactionsParameters;
import com.gridnine.xtrip.server.ibecorp.common.rest.CommonConverterHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class GetFinanceProcessor
extends BaseProcessor {
    private final NumberFormat nf = CabinetHelper.getNumberFormat(LocaleHelper.getCurrentLocale());

    public void process(MessageContext ctx) throws Exception {
        ExternalFinanceDocumentsParameters externalDocumentsParameters;
        FinanceDocumentsParameters documentsParameters;
        TransactionsParameters transactionsParameters;
        GetFinanceDataParameters request = (GetFinanceDataParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        EntityReference clientRef = (EntityReference)ctx.getMandatoryObject((Enum)IBusCabinetFinanceContextKeys.B2B_CABINET_FINANCE_CLIENT);
        EntityReference supplierRef = (EntityReference)ctx.getMandatoryObject((Enum)IBusCabinetFinanceContextKeys.B2B_CABINET_FINANCE_SUPPLIER);
        ContractType balanceContractType = (ContractType)ctx.getMandatoryObject((Enum)IBusCabinetFinanceContextKeys.B2B_CABINET_FINANCE_CONTRACT_TYPE);
        EntityContainer clientCtr = EntityStorage.get().resolve(clientRef);
        EntityContainer supplierCtr = EntityStorage.get().resolve(supplierRef);
        if (clientCtr == null || supplierCtr == null) {
            ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)new GetFinanceDataResult());
            return;
        }
        GetFinanceDataResult result = new GetFinanceDataResult();
        Map<DimensionType, EntityReference> dimensionTypeObjectMap = Collections.singletonMap(DimensionType.ORGANIZATION, supplierRef);
        String currency = CurrencyHelper.getCurrency((EntityReference)supplierRef, (EntityReference)clientRef, (ContractType)balanceContractType);
        DictionaryReference currencyInfo = FinanceHelper.getCurrency((String)currency);
        Date calculationDate = new Date();
        BigDecimal balance = MiscUtil.guarded((BigDecimal)BalanceHelper.calculateBalance((EntityReference)clientRef, null, (Date)calculationDate, (ChartOfAccountsElementType)ChartOfAccountsElementType.SUPPLIER, (DictionaryReference)currencyInfo, dimensionTypeObjectMap));
        result.setCurrentBalance(this.nf.format(balance));
        result.setCurrency(currency);
        if (!this.isUnlimitedCredit((Organization)clientCtr.getEntity(), (EntityReference<Organization>)supplierRef)) {
            BigDecimal credit = ProfileHelper.getOrganizationCreditAmount((EntityReference)clientRef, (EntityReference)supplierRef);
            BigDecimal availableFunds = balance;
            if (credit != null) {
                availableFunds = availableFunds.add(credit);
                result.setCredit(this.nf.format(credit));
            }
            result.setAvailableFunds(this.nf.format(availableFunds));
        } else {
            result.setAvailableFunds("\u0431\u0435\u0437\u043b\u0438\u043c\u0438\u0442");
            result.setCredit("\u0431\u0435\u0437\u043b\u0438\u043c\u0438\u0442");
        }
        if (request.getStartDate() != null) {
            BigDecimal startDateBalance = MiscUtil.guarded((BigDecimal)BalanceHelper.calculateBalance((EntityReference)clientRef, (Date)MiscUtil.clearTime((Date)DateUtils.toJavaDate((LocalDate)request.getStartDate())), (Date)calculationDate, (ChartOfAccountsElementType)ChartOfAccountsElementType.SUPPLIER, (DictionaryReference)currencyInfo, dimensionTypeObjectMap));
            result.setStartDateBalance(this.nf.format(startDateBalance));
        }
        LocalDate endDate = (LocalDate)MiscUtil.guarded((Object)request.getEndDate(), (Object)LocalDate.now());
        BigDecimal endDateBalance = MiscUtil.guarded((BigDecimal)BalanceHelper.calculateBalance((EntityReference)clientRef, (Date)MiscUtil.setDayEndTime((Date)DateUtils.toJavaDate((LocalDate)endDate)), (Date)calculationDate, (ChartOfAccountsElementType)ChartOfAccountsElementType.SUPPLIER, (DictionaryReference)currencyInfo, dimensionTypeObjectMap));
        result.setEndDateBalance(this.nf.format(endDateBalance));
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        boolean isDebtAvailable = this.isDebtAvailable((EntityReference<Organization>)clientRef, salesContext, request.getCompanyRelationWith());
        result.setDebtAvailable(isDebtAvailable);
        if (isDebtAvailable) {
            BigDecimal shipmentDebt = this.getShipmentDebt((EntityReference<Organization>)clientRef, (EntityReference<Organization>)supplierRef);
            result.setShipmentDebt(this.nf.format(shipmentDebt));
            BigDecimal outstandingDebt = BigDecimal.ZERO;
            if (balance.signum() < 0) {
                outstandingDebt = balance.negate().subtract(shipmentDebt);
            }
            result.setOutstandingDebt(this.nf.format(outstandingDebt));
        }
        if ((transactionsParameters = request.getTransactionsParameters()) != null && transactionsParameters.getPageSize() != null && transactionsParameters.getPage() != null) {
            result.setTransactionsData(this.getTransactions(MiscUtil.clearTime((Date)DateUtils.toJavaDate((LocalDate)request.getStartDate())), MiscUtil.setDayEndTime((Date)DateUtils.toJavaDate((LocalDate)endDate)), transactionsParameters, (EntityReference<Organization>)clientRef, dimensionTypeObjectMap, (DictionaryReference<CurrencyInfo>)currencyInfo));
        }
        if ((documentsParameters = request.getDocumentsParameters()) != null && documentsParameters.getPageSize() != null && documentsParameters.getPage() != null && request.getStartDate() != null) {
            result.setDocumentsData(this.getFinanceDocumentsList(MiscUtil.clearTime((Date)DateUtils.toJavaDate((LocalDate)request.getStartDate())), MiscUtil.setDayEndTime((Date)DateUtils.toJavaDate((LocalDate)endDate)), documentsParameters, (EntityReference<Organization>)clientRef, (EntityReference<Organization>)supplierRef));
        }
        if ((externalDocumentsParameters = request.getExternalDocumentsParameters()) != null && externalDocumentsParameters.getPageSize() != null && externalDocumentsParameters.getPage() != null && request.getStartDate() != null) {
            result.setExternalDocumentsData(this.getExternalFinanceDocumentsList(MiscUtil.clearTime((Date)DateUtils.toJavaDate((LocalDate)request.getStartDate())), MiscUtil.setDayEndTime((Date)DateUtils.toJavaDate((LocalDate)endDate)), externalDocumentsParameters, (EntityReference<Organization>)clientRef, (EntityReference<Organization>)supplierRef));
        }
        if (request.isGetAvailableFinDocumentTypes()) {
            result.getAvailableFinDocumentTypes().addAll(this.getDocumentsTypes((Organization)supplierCtr.getEntity()));
        }
        result.setCreatePrepaymentInvoice(CabinetHelper.isGranted(IbeRestrictionGroupResources.GROUP_FINANCES_PREPAYMENT_INVOICE));
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)result);
    }

    private boolean isUnlimitedCredit(Organization agency, EntityReference<Organization> supplierAgencyRef) {
        List creditLimits = agency.getFinanceRestrictions().getCreditLimits();
        return creditLimits.stream().filter(cl -> MiscUtil.equals((Object)cl.getCreditor(), (Object)supplierAgencyRef)).anyMatch(CreditLimitInfo::isUnlimited);
    }

    private boolean isDebtAvailable(EntityReference<Organization> clientRef, SalesContext salesContext, CompanyRelation companyRelation) throws Exception {
        if (salesContext.getClient() == null) {
            salesContext.setClient(ProfileHelper.findRetailProfileReference());
        }
        RuleSet ruleSet = SalesContextHandler.get().getRules(salesContext);
        RuleProxy proxy = new RuleProxy();
        proxy.setProxyDate(new Date());
        proxy.setProxyType(Targets.FINANCE.getId());
        FinancePropertySet propertySet = new FinancePropertySet(clientRef, proxy, companyRelation);
        FinanceActionSet actionSet = new FinanceActionSet();
        proxy.setPropertySet((Object)propertySet);
        proxy.setActionSet((Object)actionSet);
        RuleEngine.applyRules(Collections.singletonList(proxy), (RuleSet)ruleSet);
        return actionSet.isShownDebt();
    }

    private BigDecimal getShipmentDebt(EntityReference<Organization> clientsRef, EntityReference<Organization> supplierRef) {
        ProjectionQuery projectionQuery = new ProjectionQuery();
        projectionQuery.getCriteria().getCriterions().add(SearchCriterion.eq((String)ShipmentIndex.Property.supplier.name(), supplierRef));
        projectionQuery.getCriteria().getCriterions().add(SearchCriterion.eq((String)ShipmentIndex.Property.customer.name(), clientsRef));
        projectionQuery.getCriteria().getCriterions().add(SearchCriterion.eq((String)ShipmentIndex.Property.payed.name(), (Object)false));
        projectionQuery.getProjections().add(Projection.sum((String)ShipmentIndex.Property.totalAmount.name(), (String)"amountSum"));
        projectionQuery.getProjections().add(Projection.sum((String)ShipmentIndex.Property.totalPayedAmount.name(), (String)"payedAmountSum"));
        ProjectionResult productSummary = EntityStorage.get().search(ShipmentIndex.class, projectionQuery);
        BigDecimal totalAmount = productSummary.getBigDecimal("amountSum");
        BigDecimal totalPayedAmount = productSummary.getBigDecimal("payedAmountSum");
        return totalAmount.subtract(totalPayedAmount);
    }

    private TransactionsData getTransactions(Date startDate, Date endDate, TransactionsParameters parameters, EntityReference<Organization> clientsRef, Map<DimensionType, Object> dimensionTypeObjectMap, DictionaryReference<CurrencyInfo> currencyInfo) {
        TransactionsData transactions = new TransactionsData();
        int fromIndex = parameters.getPage() * parameters.getPageSize();
        int toIndex = parameters.getPage() * parameters.getPageSize() + parameters.getPageSize();
        String pattern = null;
        if (StringUtils.isNotBlank((String)parameters.getPattern())) {
            pattern = "%" + parameters.getPattern() + "%";
        }
        ArrayList<TransactionSplitIndex> searchResultIndices = new ArrayList<TransactionSplitIndex>();
        List transactionIndexes = BalanceHelper.getTransactionIndexes(clientsRef, (Date)startDate, (Date)endDate, (Date)new Date(), (ChartOfAccountsElementType)ChartOfAccountsElementType.SUPPLIER, currencyInfo, dimensionTypeObjectMap, null, (String)pattern, (TransactionSplitIndex.Property)TransactionSplitIndex.Property.operationDate, (SortOrder)SortOrder.DESC);
        transactions.setCount(String.valueOf(transactionIndexes.size()));
        if (fromIndex < transactionIndexes.size()) {
            toIndex = toIndex > transactionIndexes.size() ? transactionIndexes.size() : toIndex;
            searchResultIndices.addAll(transactionIndexes.subList(fromIndex, toIndex));
        }
        BigDecimal creditSum = BalanceHelper.calculateBalance(clientsRef, (Date)startDate, (Date)endDate, (Date)new Date(), (ChartOfAccountsElementType)ChartOfAccountsElementType.SUPPLIER, currencyInfo, dimensionTypeObjectMap, (boolean)true);
        BigDecimal debitSum = BalanceHelper.calculateBalance(clientsRef, (Date)startDate, (Date)endDate, (Date)new Date(), (ChartOfAccountsElementType)ChartOfAccountsElementType.SUPPLIER, currencyInfo, dimensionTypeObjectMap, (boolean)false);
        if (creditSum == null) {
            creditSum = BigDecimal.ZERO;
        }
        if (debitSum == null) {
            debitSum = BigDecimal.ZERO;
        }
        transactions.setDebitSum(this.nf.format(debitSum));
        transactions.setCreditSum(this.nf.format(creditSum));
        List<BookingFileIndex> bfIndexData = this.getBookingFileIndexData(searchResultIndices);
        HashMap bookingFileIndexMap = new HashMap(bfIndexData.size());
        bfIndexData.forEach(idx -> bookingFileIndexMap.put(idx.getSource().getUid(), idx));
        for (TransactionSplitIndex splitIndex : searchResultIndices) {
            BookingFileIndex bookingFileIndex = splitIndex.getBookingUid() != null ? (BookingFileIndex)bookingFileIndexMap.get(splitIndex.getBookingUid()) : null;
            transactions.getTransactions().add(this.toRestTransaction(splitIndex, bookingFileIndex));
        }
        return transactions;
    }

    private List<BookingFileIndex> getBookingFileIndexData(List<TransactionSplitIndex> searchResultIndices) {
        Object[] bookingUids = (String[])searchResultIndices.stream().map(TransactionSplitIndex::getBookingUid).filter(Objects::nonNull).toArray(String[]::new);
        ArrayList<BookingFileIndex> bfIndexData = new ArrayList<BookingFileIndex>();
        if (bookingUids.length > 0) {
            SearchQuery bookingFileQuery = new SearchQuery();
            bookingFileQuery.getCriteria().getCriterions().add(SearchCriterion.in((String)"containerUid", (Object[])bookingUids));
            bookingFileQuery.getPreferredProperties().add(BookingFileIndex.Property.fullNumber.name());
            bookingFileQuery.getPreferredProperties().add(BookingFileIndex.Property.agent.name());
            bfIndexData.addAll(EntityStorage.get().search(BookingFileIndex.class, bookingFileQuery).getData());
        }
        return bfIndexData;
    }

    private RestTransaction toRestTransaction(TransactionSplitIndex splitIndex, BookingFileIndex bookingFileIndex) {
        RestTransaction transaction = new RestTransaction();
        if (bookingFileIndex != null) {
            transaction.setAgent(CommonConverterHelper.getReferenceCaption(bookingFileIndex.getAgent()));
            transaction.setBookingNumber(bookingFileIndex.getFullNumber());
        }
        transaction.setCompany(CommonConverterHelper.getReferenceCaption(splitIndex.getOrganization()));
        if (splitIndex.isCredit()) {
            transaction.setOutcome(this.nf.format(ModelHelper.long2BigDecimal((long)splitIndex.getAmount())));
            transaction.setOperationType(BillingTransactionCategory.CREDIT.toString());
        } else {
            transaction.setIncome(this.nf.format(ModelHelper.long2BigDecimal((long)splitIndex.getAmount())));
            transaction.setOperationType(BillingTransactionCategory.DEBIT.toString());
        }
        transaction.setOperationDate(DateUtils.toLocalDate((Date)splitIndex.getOperationDate()));
        transaction.setNotes(splitIndex.getDescription());
        return transaction;
    }

    private List<FinanceDocumentType> getDocumentsTypes(Organization supplier) {
        List settings = supplier.getFinanceDocumentProperties().getFinanceDocumentsSettings();
        return settings.stream().filter(FinanceDocumentSettings::isUseDocument).map(FinanceDocumentSettings::getType).collect(Collectors.toList());
    }

    private FinanceDocumentsData getFinanceDocumentsList(Date startDate, Date endDate, FinanceDocumentsParameters parameters, EntityReference<Organization> clientsRef, EntityReference<Organization> supplierRef) {
        FinanceDocumentsData documents = new FinanceDocumentsData();
        SearchQuery query = this.buildFinanceDocumentQuery(clientsRef, supplierRef, startDate, endDate, parameters.getFinanceDocumentTypes(), parameters.getPattern(), parameters.isOnlyNotPayed());
        documents.setCount(String.valueOf(CabinetHelper.queryCount(query, FinanceDocumentRecordIndex.class)));
        ProjectionQuery projectionQuery = new ProjectionQuery();
        projectionQuery.getCriteria().getCriterions().addAll(query.getCriteria().getCriterions());
        projectionQuery.getProjections().add(Projection.sum((String)FinanceDocumentRecordIndex.Property.totalAmount.name(), (String)"amountSum"));
        projectionQuery.getProjections().add(Projection.sum((String)FinanceDocumentRecordIndex.Property.totalPayedAmount.name(), (String)"payedAmountSum"));
        ProjectionResult productSummary = EntityStorage.get().search(FinanceDocumentRecordIndex.class, projectionQuery);
        BigDecimal totalAmount = productSummary.getBigDecimal("amountSum");
        BigDecimal totalPayedAmount = productSummary.getBigDecimal("payedAmountSum");
        documents.setAmountSum(this.nf.format(totalAmount));
        documents.setPaidAmountSum(this.nf.format(totalPayedAmount));
        List<FinanceDocumentRecordIndex> searchResultIndices = CabinetHelper.queryPageData(query, FinanceDocumentRecordIndex.class, parameters.getPage(), parameters.getPageSize(), SortOrder.DESC, FinanceDocumentRecordIndex.Property.date.name());
        documents.getDocuments().addAll(searchResultIndices.stream().map(this::toRestFinanceDocument).collect(Collectors.toList()));
        return documents;
    }

    private ExternalFinanceDocumentsData getExternalFinanceDocumentsList(Date startDate, Date endDate, ExternalFinanceDocumentsParameters parameters, EntityReference<Organization> clientsRef, EntityReference<Organization> supplierRef) {
        ExternalFinanceDocumentsData documents = new ExternalFinanceDocumentsData();
        SearchQuery query = this.buildExternalFinanceDocumentQuery(clientsRef, supplierRef, startDate, endDate, parameters.getFinanceDocumentTypes(), parameters.getPattern());
        documents.setCount(String.valueOf(CabinetHelper.queryCount(query, ExternalFinanceDocumentIndex.class)));
        ProjectionQuery projectionQuery = new ProjectionQuery();
        projectionQuery.getCriteria().getCriterions().addAll(query.getCriteria().getCriterions());
        projectionQuery.getProjections().add(Projection.sum((String)ExternalFinanceDocumentIndex.Property.totalAmount.name(), (String)"amountSum"));
        ProjectionResult productSummary = EntityStorage.get().search(ExternalFinanceDocumentIndex.class, projectionQuery);
        BigDecimal totalAmount = productSummary.getBigDecimal("amountSum");
        documents.setAmountSum(this.nf.format(totalAmount));
        List<ExternalFinanceDocumentIndex> searchResultIndices = CabinetHelper.queryPageData(query, ExternalFinanceDocumentIndex.class, parameters.getPage(), parameters.getPageSize(), SortOrder.DESC, ExternalFinanceDocumentIndex.Property.date.name());
        documents.getDocuments().addAll(searchResultIndices.stream().map(this::toRestExternalFinanceDocument).collect(Collectors.toList()));
        return documents;
    }

    private SearchQuery buildFinanceDocumentQuery(EntityReference<Organization> clientsRef, EntityReference<Organization> supplierRef, Date startDate, Date endDate, List<FinanceDocumentType> financeDocumentTypes, String pattern, Boolean onlyNotPayed) {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)FinanceDocumentRecordIndex.Property.customer.name(), clientsRef));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)FinanceDocumentRecordIndex.Property.supplier.name(), supplierRef));
        query.getCriteria().getCriterions().add(SearchCriterion.ge((String)FinanceDocumentRecordIndex.Property.date.name(), (Object)startDate));
        query.getCriteria().getCriterions().add(SearchCriterion.le((String)FinanceDocumentRecordIndex.Property.date.name(), (Object)endDate));
        if (CollectionUtil.isNotEmpty(financeDocumentTypes)) {
            query.getCriteria().getCriterions().add(SearchCriterion.in((String)FinanceDocumentRecordIndex.Property.documentType.name(), (Object[])financeDocumentTypes.toArray()));
        }
        if (TextUtil.nonBlank((String)pattern)) {
            ArrayList<SearchCriterion> patternCriterions = new ArrayList<SearchCriterion>();
            patternCriterions.add(SearchCriterion.ilike((String)FinanceDocumentRecordIndex.Property.number.name(), (String)("%" + pattern + "%")));
            try {
                BigDecimal amountPattern = new BigDecimal(pattern);
                patternCriterions.add(SearchCriterion.eq((String)FinanceDocumentRecordIndex.Property.totalAmount.name(), (Object)amountPattern));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])patternCriterions.toArray(new SearchCriterion[0])));
        }
        if (Boolean.TRUE.equals(onlyNotPayed)) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)FinanceDocumentRecordIndex.Property.payed.name(), (Object)false));
        }
        return query;
    }

    private SearchQuery buildExternalFinanceDocumentQuery(EntityReference<Organization> clientsRef, EntityReference<Organization> supplierRef, Date startDate, Date endDate, List<FinanceDocumentType> financeDocumentTypes, String pattern) {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ExternalFinanceDocumentIndex.Property.customer.name(), clientsRef));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ExternalFinanceDocumentIndex.Property.supplier.name(), supplierRef));
        query.getCriteria().getCriterions().add(SearchCriterion.ge((String)ExternalFinanceDocumentIndex.Property.date.name(), (Object)startDate));
        query.getCriteria().getCriterions().add(SearchCriterion.le((String)ExternalFinanceDocumentIndex.Property.date.name(), (Object)endDate));
        if (CollectionUtil.isNotEmpty(financeDocumentTypes)) {
            query.getCriteria().getCriterions().add(SearchCriterion.in((String)ExternalFinanceDocumentIndex.Property.documentType.name(), (Object[])financeDocumentTypes.toArray()));
        }
        if (TextUtil.nonBlank((String)pattern)) {
            ArrayList<SearchCriterion> patternCriterions = new ArrayList<SearchCriterion>();
            patternCriterions.add(SearchCriterion.ilike((String)ExternalFinanceDocumentIndex.Property.number.name(), (String)("%" + pattern + "%")));
            try {
                BigDecimal amountPattern = new BigDecimal(pattern);
                patternCriterions.add(SearchCriterion.eq((String)ExternalFinanceDocumentIndex.Property.totalAmount.name(), (Object)amountPattern));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])patternCriterions.toArray(new SearchCriterion[0])));
        }
        return query;
    }

    private RestFinanceDocument toRestFinanceDocument(FinanceDocumentRecordIndex index) {
        RestFinanceDocument document = new RestFinanceDocument();
        document.setUid(index.getSource().getUid());
        document.getShipmentNumbers().addAll(index.getShipmentNumbers());
        document.setDate(DateUtils.toLocalDate((Date)index.getDate()));
        document.setDocumentNumber(index.getNumber());
        document.setDocumentType(index.getDocumentType());
        document.setTotalAmount(this.nf.format(index.getTotalAmount()));
        document.setTotalPayedAmount(this.nf.format(index.getTotalPayedAmount()));
        document.setPayed(index.isPayed());
        return document;
    }

    private RestExternalFinanceDocument toRestExternalFinanceDocument(ExternalFinanceDocumentIndex index) {
        RestExternalFinanceDocument document = new RestExternalFinanceDocument();
        document.setUid(index.getSource().getUid());
        document.setDate(DateUtils.toLocalDate((Date)index.getDate()));
        document.setDocumentNumber(index.getNumber());
        document.setDocumentType(index.getDocumentType());
        document.setTotalAmount(this.nf.format(index.getTotalAmount()));
        document.setBookingFileNumber(index.getBookingFileNumber());
        return document;
    }
}

