/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.cabinet.getItineraryReceipt;

import com.gridnine.xtrip.common.ibecorp.rzd.RzdCommonHelper;
import com.gridnine.xtrip.common.incidents.IncidentsLog;
import com.gridnine.xtrip.common.jr.JasperUtil;
import com.gridnine.xtrip.common.model.BaseIdentity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TravelSubject;
import com.gridnine.xtrip.common.model.booking.additionalservice.AdditionalServiceProduct;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.DocumentHelper;
import com.gridnine.xtrip.common.model.restriction.resource.ModelRestrictionEntityResources;
import com.gridnine.xtrip.common.model.system.BaseFileDocument;
import com.gridnine.xtrip.common.model.system.BasicDocumentIndex;
import com.gridnine.xtrip.common.model.system.BinaryData;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.model.system.DocumentType;
import com.gridnine.xtrip.common.model.system.DownloadableData;
import com.gridnine.xtrip.common.restriction.resource.RestrictionResourceProxy;
import com.gridnine.xtrip.common.restriction.resource.standard.StandardRestrictionResourceOperations;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SearchResult;
import com.gridnine.xtrip.common.search.utils.SearchQueryHelper;
import com.gridnine.xtrip.common.user.UserData;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.cabinet.CabinetHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.GetItineraryReceiptParameters;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import com.gridnine.xtrip.server.restriction.helper.RestrictionsHelper;
import com.gridnine.xtrip.server.security.acl.helper.AclHelper;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class GetItineraryReceiptProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        List<ItineraryDataHolder> itineraryData;
        GetItineraryReceiptParameters params = (GetItineraryReceiptParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        String bookingUid = params.getBookingUid();
        String reservationUid = params.getReservationUid();
        if (TextUtil.isBlank((String)bookingUid)) {
            throw Xeption.forDeveloper((String)"empty booking uid", (Object[])new Object[0]);
        }
        if (TextUtil.isBlank((String)reservationUid)) {
            throw Xeption.forDeveloper((String)"empty reservation uid", (Object[])new Object[0]);
        }
        EntityContainer bookingFileCtr = EntityStorage.get().resolve(new EntityReference(bookingUid, BookingFile.class, null));
        if (bookingFileCtr == null) {
            throw Xeption.forDeveloper((String)"Invalid bookingUid {0}", (Object[])new Object[]{bookingUid});
        }
        Reservation reservation = BookingHelper.findReservationByUid((BookingFile)((BookingFile)bookingFileCtr.getEntity()), (String)reservationUid);
        if (reservation == null) {
            throw Xeption.forDeveloper((String)"Invalid reservationUid {0}", (Object[])new Object[]{reservationUid});
        }
        String currentLogin = UserData.get().getCurrentUser();
        Map aclProxyMap = RestrictionsHelper.buildProxies((EntityContainer)bookingFileCtr, (String)ModelRestrictionEntityResources.ENTITY_BOOKING_FILE.getId());
        TravelSubject travelSubject = BookingHelper.getTravelSubject((Reservation)reservation);
        if (travelSubject == TravelSubject.RAILWAY) {
            itineraryData = this.getRailItineraryReceiptData((EntityReference<BookingFile>)bookingFileCtr.toReference(), reservation, aclProxyMap, currentLogin);
        } else if (travelSubject == TravelSubject.AIR) {
            itineraryData = this.getAviaItineraryReceiptData((EntityReference<BookingFile>)bookingFileCtr.toReference(), reservation, aclProxyMap, currentLogin);
        } else if (travelSubject == TravelSubject.HOTEL_RESERVATION) {
            itineraryData = this.getHotelReservationReceiptData((EntityReference<BookingFile>)bookingFileCtr.toReference(), reservation, aclProxyMap, currentLogin);
        } else if (travelSubject == TravelSubject.TRANSFER) {
            itineraryData = this.getTransferReceiptData((EntityReference<BookingFile>)bookingFileCtr.toReference(), reservation, aclProxyMap, currentLogin);
        } else {
            DownloadableData commonDocsZipData = this.createCommonDocsZipData((EntityReference<BookingFile>)bookingFileCtr.toReference(), reservation, aclProxyMap, currentLogin);
            ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)commonDocsZipData);
            return;
        }
        List<DownloadableData> docs = itineraryData.stream().map(this::buildPDF2Download).collect(Collectors.toList());
        if (docs.size() == 0) {
            return;
        }
        DownloadableData result = docs.size() > 1 ? CabinetHelper.buildZIP2Download(docs, "itineraryReceipts.zip") : docs.get(0);
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)result);
    }

    private DownloadableData buildPDF2Download(ItineraryDataHolder holder) {
        DownloadableData result = new DownloadableData();
        BinaryData binaryData = new BinaryData();
        String documentName = holder.documentName.endsWith(".pdf") ? holder.documentName : holder.documentName + ".pdf";
        binaryData.setContentType(ContentType.PDF);
        binaryData.setData(holder.payload);
        result.setFileName(documentName);
        result.setContent(binaryData);
        return result;
    }

    private DownloadableData createCommonDocsZipData(EntityReference<BookingFile> bookingRef, Reservation reservation, Map<String, RestrictionResourceProxy> aclProxyMap, String currentLogin) {
        SearchQuery query = GetItineraryReceiptProcessor.buildBaseQuery(bookingRef);
        query.getCriteria().getCriterions().add(this.buildReservationCriterion(reservation, aclProxyMap, currentLogin));
        query.getCriteria().getCriterions().add(SearchQueryHelper.buildOrEqEnumCriterion((String)BasicDocumentIndex.Property.type.name(), EnumSet.of(DocumentType.RECEIPT, DocumentType.VOUCHER, DocumentType.SPECIAL_TRAVELDOCUMENT, DocumentType.TRAVELDOCUMENT)));
        SearchResult searchResult = EntityStorage.get().search(BasicDocumentIndex.class, query);
        byte[] result = null;
        if (searchResult.getData().size() != 0) {
            try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
                try (ZipOutputStream zos = new ZipOutputStream(bos);){
                    for (int i = 0; i < searchResult.getData().size(); ++i) {
                        BaseFileDocument doc = (BaseFileDocument)EntityStorage.get().resolve(((BasicDocumentIndex)searchResult.getData().get(i)).getSource()).getEntity();
                        byte[] content = doc.getContentType() == ContentType.JASPERPRINT ? JasperUtil.convertToPdf((byte[])doc.getContent()) : doc.getContent();
                        doc.setName(DocumentHelper.getDocNameWithExtension((BaseFileDocument)doc));
                        ZipEntry entry = new ZipEntry(String.format(doc.getName(), i + 1));
                        zos.putNextEntry(entry);
                        zos.write(content);
                        zos.closeEntry();
                    }
                }
                result = bos.toByteArray();
            }
            catch (Exception e) {
                IncidentsLog.reportStackTrace((String)"Unable to ZIP itinerary receipts");
            }
        }
        DownloadableData downloadableData = new DownloadableData();
        BinaryData binaryData = new BinaryData();
        binaryData.setContentType(ContentType.BINARY);
        binaryData.setData(result);
        downloadableData.setFileName("bookingDocs.zip");
        downloadableData.setContent(binaryData);
        return downloadableData;
    }

    private List<ItineraryDataHolder> getAviaItineraryReceiptData(EntityReference<BookingFile> bookingRef, Reservation reservation, Map<String, RestrictionResourceProxy> aclProxyMap, String currentLogin) throws Exception {
        SearchQuery query = GetItineraryReceiptProcessor.buildSimpleQuery(bookingRef, MiscUtil.Pair.of((Object)DocumentType.RECEIPT, (Object)ContentType.JASPERPRINT), MiscUtil.Pair.of((Object)DocumentType.SPECIAL_TRAVELDOCUMENT, (Object)ContentType.PDF));
        query.getCriteria().getCriterions().add(this.buildReservationCriterion(reservation, aclProxyMap, currentLogin));
        SearchResult searchResult = EntityStorage.get().search(BasicDocumentIndex.class, query);
        return this.getItineraryData((SearchResult<BasicDocumentIndex>)searchResult);
    }

    private List<ItineraryDataHolder> getHotelReservationReceiptData(EntityReference<BookingFile> bookingRef, Reservation reservation, Map<String, RestrictionResourceProxy> aclProxyMap, String currentLogin) throws Exception {
        SearchQuery query = GetItineraryReceiptProcessor.buildSimpleQuery(bookingRef, MiscUtil.Pair.of((Object)DocumentType.VOUCHER, (Object)ContentType.JASPERPRINT));
        query.getCriteria().getCriterions().add(this.buildReservationCriterion(reservation, aclProxyMap, currentLogin));
        SearchResult searchResult = EntityStorage.get().search(BasicDocumentIndex.class, query);
        return this.getItineraryData((SearchResult<BasicDocumentIndex>)searchResult);
    }

    private List<ItineraryDataHolder> getTransferReceiptData(EntityReference<BookingFile> bookingRef, Reservation reservation, Map<String, RestrictionResourceProxy> aclProxyMap, String currentLogin) throws Exception {
        SearchQuery query = GetItineraryReceiptProcessor.buildSimpleQuery(bookingRef, MiscUtil.Pair.of((Object)DocumentType.RECEIPT, (Object)ContentType.JASPERPRINT));
        query.getCriteria().getCriterions().add(this.buildReservationCriterion(reservation, aclProxyMap, currentLogin));
        SearchResult searchResult = EntityStorage.get().search(BasicDocumentIndex.class, query);
        return this.getItineraryData((SearchResult<BasicDocumentIndex>)searchResult);
    }

    private List<ItineraryDataHolder> getRailItineraryReceiptData(EntityReference<BookingFile> bookingRef, Reservation reservation, Map<String, RestrictionResourceProxy> aclProxyMap, String currentLogin) throws Exception {
        SearchQuery query = GetItineraryReceiptProcessor.buildSimpleQuery(bookingRef, MiscUtil.Pair.of((Object)DocumentType.TRAVELDOCUMENT, (Object)ContentType.PDF), MiscUtil.Pair.of((Object)DocumentType.RECEIPT, (Object)ContentType.JASPERPRINT));
        query.getCriteria().getCriterions().add(this.buildReservationsCriterion(RzdCommonHelper.getRelatedReservations((Reservation)reservation), aclProxyMap, currentLogin));
        SearchResult searchResult = EntityStorage.get().search(BasicDocumentIndex.class, query);
        return this.getItineraryData((SearchResult<BasicDocumentIndex>)searchResult);
    }

    private static SearchQuery buildBaseQuery(EntityReference<BookingFile> bookingRef) {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.ne((String)BasicDocumentIndex.Property.external.name(), (Object)true));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BasicDocumentIndex.Property.owner.name(), bookingRef));
        return query;
    }

    private static SearchQuery buildSimpleQuery(EntityReference<BookingFile> bookingRef, MiscUtil.Pair<DocumentType, ContentType> ... pairs) {
        SearchQuery query = GetItineraryReceiptProcessor.buildBaseQuery(bookingRef);
        List orCriterions = Arrays.stream(pairs).map(GetItineraryReceiptProcessor::buildSimpleDocCriterion).collect(Collectors.toList());
        query.getCriteria().getCriterions().add(SearchQueryHelper.toOrCriterion(orCriterions));
        return query;
    }

    private static SearchCriterion buildSimpleDocCriterion(MiscUtil.Pair<DocumentType, ContentType> pair) {
        return SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)BasicDocumentIndex.Property.type.name(), (Object)pair.getFirst()), SearchCriterion.eq((String)BasicDocumentIndex.Property.contentType.name(), (Object)pair.getSecond())});
    }

    private SearchCriterion buildReservationCriterion(Reservation reservation, Map<String, RestrictionResourceProxy> aclProxyMap, String currentLogin) {
        return this.buildReservationsCriterion(Collections.singletonList(reservation), aclProxyMap, currentLogin);
    }

    private SearchCriterion buildReservationsCriterion(List<Reservation> reservations, Map<String, RestrictionResourceProxy> aclProxyMap, String currentLogin) {
        HashSet uids = new HashSet();
        reservations.forEach(reservation -> {
            reservation.getProducts().stream().filter(baseProduct -> !(baseProduct instanceof AdditionalServiceProduct)).filter(p -> {
                try {
                    return AclHelper.isGranted((RestrictionResourceProxy)((RestrictionResourceProxy)aclProxyMap.get(p.getUid())), (String)ModelRestrictionEntityResources.ENTITY_PRODUCT.getId(), (String)currentLogin, (String)StandardRestrictionResourceOperations.VIEW.getId(), Collections.emptyList());
                }
                catch (Exception e) {
                    throw Xeption.forDeveloper((String)"BuildReservationCriterion failed", (Throwable)e, (Object[])new Object[0]);
                }
            }).map(BaseIdentity::getUid).forEach(uids::add);
            uids.add(reservation.getUid());
        });
        return SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchQueryHelper.buildOrEqStringCriterion((String)"navigationKey", uids), SearchCriterion.eq((String)"navigationKey", null)});
    }

    private List<ItineraryDataHolder> getItineraryData(SearchResult<BasicDocumentIndex> searchResult) throws Exception {
        ArrayList<ItineraryDataHolder> dataHolders = new ArrayList<ItineraryDataHolder>();
        for (int i = 0; i < searchResult.getData().size(); ++i) {
            BaseFileDocument doc = (BaseFileDocument)EntityStorage.get().resolve(((BasicDocumentIndex)searchResult.getData().get(i)).getSource()).getEntity();
            byte[] content = doc.getContentType() == ContentType.JASPERPRINT ? JasperUtil.convertToPdf((byte[])doc.getContent()) : doc.getContent();
            dataHolders.add(new ItineraryDataHolder(doc.getName(), content));
        }
        return dataHolders;
    }

    private static class ItineraryDataHolder {
        private final byte[] payload;
        private final String documentName;

        private ItineraryDataHolder(String documentName, byte[] payload) {
            Objects.requireNonNull(documentName);
            Objects.requireNonNull(payload);
            this.documentName = documentName;
            this.payload = payload;
        }
    }
}

