/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.cabinet.getOrders;

import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.ibecorp.restriction.resource.IbeRestrictionGroupResources;
import com.gridnine.xtrip.common.incidents.IncidentsLog;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.BookingFileIndex;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.parameters.EntityStorageSearchParameters;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.ibecorp.booking.ReservationIndexInfo;
import com.gridnine.xtrip.common.model.ibecorp.booking.RestReservationIndexInfo;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSite;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSiteType;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.search.ResultMode;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.common.search.utils.SearchQueryHelper;
import com.gridnine.xtrip.common.user.UserData;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.DateUtils;
import com.gridnine.xtrip.common.util.EnumUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XSerializable;
import com.gridnine.xtrip.common.xml.XUtil;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.cabinet.CabinetHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.cabinet.getOrders.GetOrderParametersSortFields;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.GetOrdersParameters;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.GetOrdersResult;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.OrderInfo;
import com.gridnine.xtrip.server.ibecorp.common.rest.CommonConverterHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.SortInfo;
import com.gridnine.xtrip.server.ibecorp.security.acl.IbePermissionManager;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import com.gridnine.xtrip.server.security.acl.helper.AclHelper;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class GetOrdersProcessor
extends BaseProcessor {
    private static final DateTimeFormatter DF = DateTimeFormatter.ofPattern("dd.MM.yyyy");

    public void process(MessageContext ctx) throws Exception {
        GetOrdersParameters request = (GetOrdersParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        EntityContainer loginAgentCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.AUTHORIZED_USER_CONTAINER);
        SMSiteType siteType = (SMSiteType)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.SITE_TYPE);
        EntityReference siteRef = (EntityReference)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.SITE);
        GetOrdersResult result = new GetOrdersResult();
        if (siteType == SMSiteType.B2C) {
            SearchQuery query = new SearchQuery();
            CabinetHelper.applyB2cBookingsMandatoryFilters(query, (EntityReference<Person>)loginAgentCtr.toReference(), (EntityReference<SMSite>)siteRef);
            this.applyRestFilters(query, request);
            this.addExtraCriterions(query);
            this.composeResult(result, query, request);
        } else if (CabinetHelper.isGranted(IbeRestrictionGroupResources.GROUP_BOOKINGS) && IbePermissionManager.isIndexGranted(BookingFileIndex.class)) {
            EntityReference currentOrg = (EntityReference)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.CURRENT_ORGANIZATION);
            SearchQuery query = new SearchQuery();
            CabinetHelper.applyB2bBookingsMandatoryFilters(query, (EntityReference<Organization>)currentOrg, (EntityContainer<Person>)loginAgentCtr);
            this.applyRestFilters(query, request);
            this.addExtraCriterions(query);
            AclHelper.modifyQuery((SearchQuery)query, (String)BookingFileIndex.class.getName(), (String)UserData.get().getCurrentUser(), Collections.emptyList());
            this.composeResult(result, query, request);
        }
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)result);
    }

    private void composeResult(GetOrdersResult result, SearchQuery query, GetOrdersParameters request) {
        result.setTotalCount(this.getOrdersCount(query));
        ArrayList<BookingFileIndex> searchResultIndices = new ArrayList<BookingFileIndex>(CabinetHelper.queryPageData(query, BookingFileIndex.class, (Integer)MiscUtil.guarded((Object)request.getPage(), (Object)0), Math.min((Integer)MiscUtil.guarded((Object)request.getPageSize(), (Object)10), 1000), this.getSortOrder(request.getSortInfo()), this.getSortFields(request.getSortInfo())));
        this.fillResult(searchResultIndices, result);
    }

    private void applyRestFilters(SearchQuery query, GetOrdersParameters request) {
        if (request.getReservationStatus() != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.contains((String)BookingFileIndex.Property.reservationStatuses.name(), (Object)request.getReservationStatus()));
        }
        if (request.getClient() != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BookingFileIndex.Property.client.name(), (Object)request.getClient()));
        }
        if (request.getSubagency() != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.contains((String)BookingFileIndex.Property.subagencies.name(), (Object)request.getSubagency()), SearchCriterion.eq((String)BookingFileIndex.Property.subagency.name(), (Object)request.getSubagency())}));
        }
        if (request.getStartDate() != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.ge((String)BookingFileIndex.Property.firstTravelDate.name(), (Object)DateUtils.toJavaDate((LocalDate)request.getStartDate())));
        }
        if (request.getEndDate() != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.lt((String)BookingFileIndex.Property.firstTravelDate.name(), (Object)DateUtils.toJavaDate((LocalDate)request.getEndDate().plusDays(1L))));
        }
        if (request.getIssueStartDate() != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.ge((String)BookingFileIndex.Property.firstIssueDate.name(), (Object)DateUtils.toJavaDate((LocalDate)request.getIssueStartDate())));
        }
        if (request.getIssueEndDate() != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.lt((String)BookingFileIndex.Property.firstIssueDate.name(), (Object)DateUtils.toJavaDate((LocalDate)request.getIssueEndDate().plusDays(1L))));
        }
        if (request.getContactPerson() != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BookingFileIndex.Property.customerProfile.name(), (Object)request.getContactPerson()));
        }
        if (StringUtils.isNotBlank((String)request.getPattern())) {
            this.filterPattern(query, request.getPattern());
        }
    }

    private void filterPattern(SearchQuery query, String requestPattern) {
        String pattern = "%" + requestPattern + "%";
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.ilike((String)BookingFileIndex.Property.searchTravellers.name(), (String)pattern), SearchCriterion.ilike((String)BookingFileIndex.Property.travellers.name(), (String)pattern), SearchCriterion.ilike((String)BookingFileIndex.Property.fullNumber.name(), (String)pattern), SearchCriterion.ilike((String)BookingFileIndex.Property.travelLocation.name(), (String)pattern), SearchCriterion.ilike((String)BookingFileIndex.Property.ticketNumbers.name(), (String)pattern), SearchCriterion.ilike((String)BookingFileIndex.Property.recordLocators.name(), (String)pattern), SearchCriterion.ilike((String)BookingFileIndex.Property.pnr.name(), (String)pattern)}));
    }

    private void addExtraCriterions(SearchQuery query) {
        EnumSet<TicketType> ticketTypes = EnumSet.allOf(TicketType.class);
        ticketTypes.remove(TicketType.CORRECTION);
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.isEmpty((String)BookingFileIndex.Property.ticketTypes.name()), SearchQueryHelper.buildOrContainsEnumCriterion((String)BookingFileIndex.Property.ticketTypes.name(), ticketTypes)}));
        query.getCriteria().getCriterions().add(SearchCriterion.ne((String)BookingFileIndex.Property.lastIssueDate.name(), null));
    }

    private Collection<RestReservationIndexInfo> convertReservationIndexInfo(Collection<String> collection) {
        LinkedHashSet<RestReservationIndexInfo> restReservationIndexInfoCollection = new LinkedHashSet<RestReservationIndexInfo>();
        for (String rii : collection) {
            ReservationIndexInfo reservationIndexInfo = new ReservationIndexInfo();
            try {
                XUtil.fromString((String)rii, (XSerializable)reservationIndexInfo);
                this.toRestReservationIndexInfo(reservationIndexInfo, restReservationIndexInfoCollection);
            }
            catch (Exception e) {
                throw Xeption.forDeveloper((String)"Error converting reservationIndexInfo", (Throwable)e, (Object[])new Object[0]);
            }
        }
        return restReservationIndexInfoCollection;
    }

    private void toRestReservationIndexInfo(ReservationIndexInfo reservationIndexInfo, Collection<RestReservationIndexInfo> restReservationIndexInfoCollection) {
        RestReservationIndexInfo restReservationIndexInfo = new RestReservationIndexInfo();
        restReservationIndexInfo.setTravelSubject(reservationIndexInfo.getTravelSubject());
        if (reservationIndexInfo.getProductType() == ProductType.MISC_PRODUCT) {
            EntityReference universalProductDescRef = EntityStorage.get().actualize(reservationIndexInfo.getUniversalProductDesc());
            String universalProductDesc = universalProductDescRef != null && TextUtil.nonBlank((String)universalProductDescRef.getCaption()) ? universalProductDescRef.getCaption() : ProductType.MISC_PRODUCT.toString();
            restReservationIndexInfo.setTravelSubjectDesc(universalProductDesc);
        } else {
            restReservationIndexInfo.setTravelSubjectDesc(EnumUtil.stringValueOf((Enum)reservationIndexInfo.getTravelSubject()));
        }
        restReservationIndexInfo.setStatus(reservationIndexInfo.getStatus());
        restReservationIndexInfo.getRoutes().addAll(reservationIndexInfo.getRoutes());
        restReservationIndexInfoCollection.add(restReservationIndexInfo);
    }

    private void fillResult(List<BookingFileIndex> searchResultIndexes, GetOrdersResult result) {
        for (BookingFileIndex index : searchResultIndexes) {
            try {
                Set travellers;
                OrderInfo order = new OrderInfo();
                order.getReservationInfos().addAll(this.convertReservationIndexInfo(index.getReservationIndexInfo()));
                order.setArrivalLocation(index.getTravelLocation());
                order.setBooking(index.getSource());
                order.setDate(MiscUtil.toLocalDate((Date)index.getFirstTravelDate()));
                order.setContactPerson(index.getCustomerProfile());
                if (CollectionUtil.isEmpty((Collection)index.getSubagencies())) {
                    if (Objects.nonNull(index.getSubagency())) {
                        order.getSubagencies().addAll(Collections.singletonList(index.getSubagency()));
                    }
                } else {
                    order.getSubagencies().addAll(index.getSubagencies());
                }
                order.setClient(index.getClient() != null ? index.getClient().toString() : null);
                index.getAgents().stream().filter(Objects::nonNull).map(Object::toString).forEach(order.getAgents()::add);
                index.getIssueDates().stream().filter(TextUtil::nonBlank).forEach(d -> {
                    try {
                        order.getIssueDates().add(LocalDate.parse(d, DF));
                    }
                    catch (DateTimeParseException e) {
                        this.log.error("", (Throwable)e);
                    }
                });
                order.setDepartureLocation(index.getStartOfTravel());
                order.setTotal(CommonConverterHelper.convertMoney2Rest(index.getTotalPrice(), (String)MiscUtil.guarded((Object)index.getTotalPriceCurrency(), (Object)DictHelper.getLocalCurrency())));
                Set set = travellers = !index.getUniqueTravellers().isEmpty() ? index.getUniqueTravellers() : index.getTravellers();
                if (travellers.isEmpty()) {
                    EntityContainer bookingCtr = EntityStorage.get().resolve(index.getSource());
                    ((BookingFile)bookingCtr.getEntity()).getTravellers().stream().filter(Objects::nonNull).map(Traveller::getCyrillicName).filter(Objects::nonNull).forEach(travellers::add);
                }
                order.getTravellers().addAll(travellers);
                order.getTravelSubjects().addAll(!index.getTravelSubjectExceptCorrection().isEmpty() ? index.getTravelSubjectExceptCorrection() : index.getTravelSubject());
                result.getOrders().add(order);
            }
            catch (Throwable ex) {
                IncidentsLog.reportException((String)("build rest list order failed: " + index.getSource().getCaption() + " (" + index.getSource().getUid() + ")"), (Throwable)ex);
            }
        }
        result.getSortFields().addAll(Arrays.stream(GetOrderParametersSortFields.values()).map(Enum::name).collect(Collectors.toList()));
    }

    private String[] getSortFields(SortInfo sortInfo) {
        if (sortInfo == null || sortInfo.getSortField() == null) {
            return new String[]{BookingFileIndex.Property.lastIssueDate.name(), BookingFileIndex.Property.fullNumber.name()};
        }
        return new String[]{GetOrderParametersSortFields.valueOf(sortInfo.getSortField()).getIndexFieldName()};
    }

    private SortOrder getSortOrder(SortInfo sortInfo) {
        if (sortInfo == null || sortInfo.getSortOrder() == null) {
            return SortOrder.DESC;
        }
        return SortOrder.valueOf((String)sortInfo.getSortOrder().name());
    }

    private int getOrdersCount(SearchQuery query) {
        query.setResultMode(ResultMode.COUNT_ONLY);
        return EntityStorage.get().search(BookingFileIndex.class, query, (EntityStorageSearchParameters)new EntityStorageSearchParameters().noCache(true)).getTotalCount();
    }
}

