/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.cabinet.getPassengers;

import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSiteType;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonIndex;
import com.gridnine.xtrip.common.model.profile.PersonType;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.cabinet.CabinetConverterHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.cabinet.CabinetHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.GetPassengersParameters;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.GetPassengersResult;
import com.gridnine.xtrip.server.ibecorp.security.acl.IbePermissionManager;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import com.gridnine.xtrip.server.security.acl.helper.AclHelper;
import java.util.Collections;
import java.util.List;

public class GetPassengersProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        GetPassengersParameters parameters = (GetPassengersParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        EntityReference authorizedUser = (EntityReference)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.AUTHORIZED_USER);
        SMSiteType siteType = (SMSiteType)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.SITE_TYPE);
        GetPassengersResult result = new GetPassengersResult();
        CabinetHelper.checkRequestPaginationParameters(parameters.getPage(), parameters.getPageSize());
        if (IbePermissionManager.isIndexGranted(PersonIndex.class)) {
            String pattern = parameters.getPattern();
            if (!TextUtil.isBlank((String)pattern)) {
                pattern = "%" + pattern + "%";
            }
            SearchQuery searchQuery = new SearchQuery();
            searchQuery.getCriteria().getCriterions().add(SearchCriterion.icontains((String)PersonIndex.Property.types.name(), (String)PersonType.PASSENGER.name()));
            searchQuery.getCriteria().getCriterions().add(SearchCriterion.isEmpty((String)PersonIndex.Property.employmentsUids.name()));
            searchQuery.getCriteria().getCriterions().add(SearchCriterion.eq((String)PersonIndex.Property.disabled.name(), (Object)Boolean.FALSE));
            if (siteType.equals((Object)SMSiteType.B2C)) {
                searchQuery.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)PersonIndex.Property.parent.name(), (Object)authorizedUser.getUid()), SearchCriterion.eq((String)"containerUid", (Object)authorizedUser.getUid())}));
            }
            if (!TextUtil.isBlank((String)pattern)) {
                searchQuery.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.ilike((String)PersonIndex.Property.name.name(), (String)pattern), SearchCriterion.ilike((String)PersonIndex.Property.englishFirstName.name(), (String)pattern), SearchCriterion.ilike((String)PersonIndex.Property.englishLastName.name(), (String)pattern)}));
            }
            AclHelper.modifyQuery((SearchQuery)searchQuery, (String)PersonIndex.class.getName(), (String)((Person)EntityStorage.get().resolve(authorizedUser).getEntity()).getLoginName(), Collections.emptyList());
            searchQuery.getPreferredProperties().add("containerUid");
            result.setCount(CabinetHelper.queryCount(searchQuery, PersonIndex.class));
            List<PersonIndex> searchResultData = CabinetHelper.queryPageData(searchQuery, PersonIndex.class, parameters.getPage(), parameters.getPageSize(), SortOrder.ASC, PersonIndex.Property.name.name());
            EntityStorage es = EntityStorage.get();
            searchResultData.stream().map(PersonIndex::getSource).map(arg_0 -> ((EntityStorage)es).resolve(arg_0)).forEach(travellerCtr -> result.getPassengers().add(CabinetConverterHelper.convertTravellerPersonListItem((EntityContainer<Person>)travellerCtr)));
        }
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)result);
    }
}

