/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.cabinet.getProducts;

import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.ibecorp.restriction.resource.IbeRestrictionGroupResources;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.meta.MetaRegistryHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.CommonProductIndex;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.ReservationType;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.booking.misc.ProductVoiding;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.parameters.EntityStorageSearchParameters;
import com.gridnine.xtrip.common.model.handlers.ProductStatusHandler;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.BookingStreamHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSite;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSiteType;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonIndex;
import com.gridnine.xtrip.common.model.profile.PersonType;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.search.Projection;
import com.gridnine.xtrip.common.search.ProjectionQuery;
import com.gridnine.xtrip.common.search.ProjectionResult;
import com.gridnine.xtrip.common.search.ResultMode;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.common.search.utils.SearchQueryHelper;
import com.gridnine.xtrip.common.util.DateUtils;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.cabinet.CabinetHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.GetProductsParameters;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.GetProductsResult;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.GetProductsResultSummary;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.ProductInfo;
import com.gridnine.xtrip.server.ibecorp.common.rest.authorization.AuthorizationHelper;
import com.gridnine.xtrip.server.ibecorp.security.acl.IbePermissionManager;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import com.gridnine.xtrip.server.model.helpers.ProfileDao;
import com.gridnine.xtrip.server.security.acl.helper.AclHelper;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.joda.time.DateTime;

public class GetProductsProcessor
extends BaseProcessor {
    private final Locale locale = LocaleHelper.getCurrentLocale();
    private final NumberFormat df = CabinetHelper.getNumberFormat(this.locale);

    public void process(MessageContext ctx) throws Exception {
        boolean granted;
        GetProductsParameters request = (GetProductsParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        SMSiteType siteType = (SMSiteType)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.SITE_TYPE);
        EntityReference siteRef = (EntityReference)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.SITE);
        EntityContainer curUserCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.AUTHORIZED_USER_CONTAINER);
        Person loginAgent = (Person)curUserCtr.getEntity();
        GetProductsResult result = new GetProductsResult();
        result.setSummary(new GetProductsResultSummary());
        boolean bl = granted = CabinetHelper.isGranted(IbeRestrictionGroupResources.GROUP_SALES) && IbePermissionManager.isIndexGranted(CommonProductIndex.class);
        if (!granted) {
            ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)result);
            return;
        }
        SearchQuery query = new SearchQuery();
        if (siteType == SMSiteType.B2C) {
            CabinetHelper.applyB2cProductsMandatoryFilters(query, (EntityReference<Person>)curUserCtr.toReference(), (EntityReference<SMSite>)siteRef);
        } else {
            EntityReference currentOrg = (EntityReference)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.CURRENT_ORGANIZATION);
            CabinetHelper.applyB2bProductsMandatoryFilters(query, (EntityReference<Organization>)currentOrg, (EntityContainer<Person>)curUserCtr);
        }
        this.applyFilters(query, request, loginAgent);
        this.addExtraCriterions(query);
        AclHelper.modifyQuery((SearchQuery)query, (String)CommonProductIndex.class.getName(), (String)loginAgent.getLoginName(), Collections.emptyList());
        query.setResultMode(ResultMode.COUNT_ONLY);
        this.fillResultSummary(query, loginAgent, result);
        ArrayList<CommonProductIndex> searchResultIndices = new ArrayList<CommonProductIndex>(CabinetHelper.queryPageData(query, CommonProductIndex.class, request.getPage(), request.getPageSize(), SortOrder.DESC, CommonProductIndex.Property.issueDate.name(), CommonProductIndex.Property.bookingNumber.name(), CommonProductIndex.Property.firstTravelDate.name()));
        this.fillResult(searchResultIndices, result);
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)result);
    }

    private void fillResultSummary(SearchQuery query, Person loginAgent, GetProductsResult result) {
        result.getSummary().setCount(EntityStorage.get().search(CommonProductIndex.class, query, (EntityStorageSearchParameters)new EntityStorageSearchParameters().noCache(true)).getTotalCount());
        ProjectionQuery projectionQuery = new ProjectionQuery();
        projectionQuery.getCriteria().getCriterions().addAll(query.getCriteria().getCriterions());
        projectionQuery.getProjections().add(Projection.sum((String)CommonProductIndex.Property.totalSum.name(), (String)"totalSumResult"));
        ProjectionResult productSummary = EntityStorage.get().search(CommonProductIndex.class, projectionQuery, (EntityStorageSearchParameters)new EntityStorageSearchParameters().noCache(true));
        BigDecimal totalSumResult = productSummary.getBigDecimal("totalSumResult");
        if (!AuthorizationHelper.isCorporantAuthorized(loginAgent)) {
            BigDecimal incomeSumResult = productSummary.getBigDecimal("incomeSumResult");
            result.getSummary().setIncomeSum(this.df.format(incomeSumResult));
        }
        result.getSummary().setAmountSum(this.df.format(totalSumResult));
        String currencyCode = DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.EQUIVE_CURRENCY, (String)"RUB");
        result.getSummary().setCurrency(currencyCode);
    }

    private void applyFilters(SearchQuery query, GetProductsParameters request, Person loginAgent) throws Exception {
        if (Objects.nonNull(request.getStartDate())) {
            query.getCriteria().getCriterions().add(SearchCriterion.ge((String)CommonProductIndex.Property.issueDate.name(), (Object)MiscUtil.clearTime((Date)DateUtils.toJavaDate((LocalDate)request.getStartDate()))));
        }
        if (Objects.nonNull(request.getEndDate())) {
            query.getCriteria().getCriterions().add(SearchCriterion.le((String)CommonProductIndex.Property.issueDate.name(), (Object)MiscUtil.setDayEndTime((Date)DateUtils.toJavaDate((LocalDate)request.getEndDate()))));
        }
        if (Objects.nonNull(request.getAgent())) {
            this.filterAgent(query, (EntityReference<Person>)request.getAgent(), loginAgent);
        }
        if (Objects.nonNull(request.getAirline())) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)CommonProductIndex.Property.carrier.name(), (Object)request.getAirline()));
        }
        if (!request.getStatuses().isEmpty() && !request.getStatuses().containsAll(Arrays.asList(ProductStatus.values()))) {
            query.getCriteria().getCriterions().add(SearchQueryHelper.buildOrEqEnumCriterion((String)CommonProductIndex.Property.status.name(), (Collection)request.getStatuses()));
        }
        if (!request.getProductTypes().isEmpty() && !request.getProductTypes().containsAll(Arrays.asList(ProductType.values()))) {
            query.getCriteria().getCriterions().add(SearchQueryHelper.buildOrEqEnumCriterion((String)CommonProductIndex.Property.productType.name(), (Collection)request.getProductTypes()));
        }
        if (request.isWithTripartiteDiscount() != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)CommonProductIndex.Property.tripartiteDiscount.name(), (Object)request.isWithTripartiteDiscount()));
        }
        if (!TextUtil.isBlank((String)request.getPattern())) {
            this.filterPattern(query, request.getPattern());
        }
        if (Objects.nonNull(request.getSubagency())) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)CommonProductIndex.Property.subagency.name(), (Object)request.getSubagency()));
        }
        if (request.getClient() != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)CommonProductIndex.Property.client.name(), (Object)request.getClient()));
        }
        if (request.getContactPerson() != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)CommonProductIndex.Property.customerProfile.name(), (Object)request.getContactPerson()));
        }
        if (request.isOnHold() != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)CommonProductIndex.Property.onHold.name(), (Object)request.isOnHold()));
        }
    }

    private void filterPattern(SearchQuery query, String requestPattern) {
        String pattern = "%" + requestPattern + "%";
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.ilike((String)CommonProductIndex.Property.sortingTicketNumber.name(), (String)pattern), SearchCriterion.ilike((String)CommonProductIndex.Property.bookingNumber.name(), (String)pattern), SearchCriterion.ilike((String)CommonProductIndex.Property.recordLocators.name(), (String)pattern), SearchCriterion.ilike((String)CommonProductIndex.Property.recordLocator.name(), (String)pattern), SearchCriterion.ilike((String)CommonProductIndex.Property.travellersNames.name(), (String)pattern), SearchCriterion.ilike((String)CommonProductIndex.Property.routeLine.name(), (String)pattern), SearchCriterion.ilike((String)CommonProductIndex.Property.routeLineCodes.name(), (String)pattern)}));
    }

    private void filterAgent(SearchQuery query, EntityReference<Person> agent, Person loginAgent) throws Exception {
        SearchQuery queryAgent = new SearchQuery();
        queryAgent.getCriteria().getCriterions().add(SearchCriterion.contains((String)PersonIndex.Property.types.name(), (Object)(AuthorizationHelper.isCorporantAuthorized(loginAgent) ? PersonType.PASSENGER.name() : PersonType.AGENT.name())));
        queryAgent.getCriteria().getCriterions().add(SearchCriterion.eq((String)"containerUid", (Object)agent.getUid()));
        List agentRefs = ProfileDao.getProfileReferences((SearchQuery)queryAgent, PersonIndex.class);
        if (agentRefs.isEmpty()) {
            throw Xeption.forDeveloper((String)("No agent found for given container uid: " + agent.getUid()), (Object[])new Object[0]);
        }
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)CommonProductIndex.Property.agent.name(), agentRefs.get(0)));
    }

    private void addExtraCriterions(SearchQuery query) {
        query.getCriteria().getCriterions().add(SearchCriterion.ne((String)CommonProductIndex.Property.ticketType.name(), (Object)TicketType.CORRECTION));
        query.getCriteria().getCriterions().add(SearchCriterion.ne((String)CommonProductIndex.Property.productType.name(), (Object)ProductType.PRODUCT_VOIDING));
        query.getCriteria().getCriterions().add(SearchCriterion.ne((String)CommonProductIndex.Property.status.name(), (Object)ProductStatus.EXCHANGE));
    }

    private void fillResult(List<CommonProductIndex> searchResultIndices, GetProductsResult result) {
        for (CommonProductIndex prodIndex : searchResultIndices) {
            GeneralProductContractRelationData relationData;
            ProductInfo prodRef = new ProductInfo();
            result.getProducts().add(prodRef);
            prodRef.setBookingNumber(prodIndex.getBookingNumber());
            prodRef.setBookingUid(prodIndex.getSource().getUid());
            if (Objects.nonNull(prodIndex.getProductType())) {
                prodRef.setProductType(prodIndex.getProductType());
            }
            if (!TextUtil.isBlank((String)prodIndex.getRouteLineCodes())) {
                prodRef.setRoute(prodIndex.getRouteLineCodes());
            } else {
                prodRef.setRoute(MiscUtil.guarded((String)prodIndex.getRouteLine()));
            }
            if (Objects.nonNull(prodIndex.getFirstDepartureDate())) {
                prodRef.setDepartureDate(new DateTime((Object)prodIndex.getFirstDepartureDate()));
            }
            if (prodIndex.getIssueDate() != null) {
                prodRef.setOperationDate(new DateTime((Object)prodIndex.getIssueDate()));
            }
            if (!prodIndex.getTravellersNames().isEmpty()) {
                for (String travellerName : prodIndex.getTravellersNames()) {
                    prodRef.getTravellers().add(travellerName);
                }
            }
            if (Objects.nonNull(prodIndex.getStatus())) {
                prodRef.setStatus(MetaRegistryHelper.getDisplayName(ProductStatus.class, (String)prodIndex.getStatus().name(), (Locale)this.locale));
            }
            prodRef.setSubagency(prodIndex.getSubagency());
            prodRef.setClient(prodIndex.getClient());
            prodRef.setContactPerson(prodIndex.getCustomerProfile());
            Iterator systemNumbersIterator = prodIndex.getSystemNumbers().iterator();
            if (systemNumbersIterator.hasNext()) {
                prodRef.setTicketNumber((String)systemNumbersIterator.next());
            }
            if (TextUtil.nonBlank((String)prodIndex.getDisplayedRecordLocator())) {
                prodRef.setPnr(prodIndex.getDisplayedRecordLocator());
            } else {
                prodRef.setPnr(prodIndex.getRecordLocator());
            }
            prodRef.setTripartiteDiscount(prodIndex.isTripartiteDiscount());
            BookingFile bookingFile = (BookingFile)EntityStorage.get().resolve(prodIndex.getSource()).getEntity();
            AtomicBoolean isOnline = new AtomicBoolean(true);
            bookingFile.getReservations().forEach(res -> {
                if (res.getType() != ReservationType.INTERNET && res.getType() != ReservationType.IBE) {
                    isOnline.set(false);
                }
            });
            prodRef.setOnlineBooking(isOnline.get());
            BaseProduct product = Objects.requireNonNull(BookingHelper.findProduct((BookingFile)bookingFile, (String)prodIndex.getNavigationKey()));
            ProductStatus status = GeneralProductHelper.getStatus((BaseProduct)product);
            BigDecimal totalSum = !ProductStatusHandler.getAllVoidStatuses().contains(status) ? ((relationData = GeneralProductHelper.getClientContractRelation((BaseProduct)product)) == null ? new BigDecimal(0) : relationData.getFops().stream().filter(fop -> fop.getType() != PaymentType.TICKET).map(fop -> MiscUtil.guarded((BigDecimal)fop.getEquivalentAmount())).reduce(BigDecimal.ZERO, BigDecimal::add)) : BookingStreamHelper.getProductsStream((BookingFile)bookingFile, ProductVoiding.class).filter(pv -> MiscUtil.equals((Object)pv.getRelatedProduct(), (Object)product)).map(pv -> BookingHelper.getTotalPrice((BaseProduct)pv, (ContractType)ContractType.CLIENT)).reduce(BigDecimal.ZERO, BigDecimal::add);
            if (status == ProductStatus.REFUND) {
                totalSum = totalSum.negate();
            }
            String s = this.df.format(totalSum);
            prodRef.setAmount(s);
            prodRef.setIncome(s);
            BigDecimal holdSum = BigDecimal.ZERO;
            if (prodIndex.isOnHold()) {
                holdSum = MiscUtil.guarded((BigDecimal)MiscUtil.sum((BigDecimal[])new BigDecimal[]{prodIndex.getTotalSum(), prodIndex.getClientFeeValue()}));
            }
            prodRef.setHoldAmount(this.df.format(holdSum));
        }
    }
}

