/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.cabinet.getRuleActions;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.profile.ModelContract;
import com.gridnine.xtrip.common.model.rules.standard.ContractsFilteringCategories;
import com.gridnine.xtrip.common.model.rules.standard.Targets;
import com.gridnine.xtrip.common.model.rules.subsidized.SubsidizedContractFilteringCategories;
import com.gridnine.xtrip.common.rules.RuleFilteringCategory;
import com.gridnine.xtrip.common.rules.RuleSettings;
import com.gridnine.xtrip.common.rules.RulesEnvironment;
import com.gridnine.xtrip.common.rules.elements.RuleAction;
import com.gridnine.xtrip.common.rules.elements.RuleTarget;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.cabinet.CabinetConverterHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.cabinet.CabinetHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.RuleActionsParameters;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.RuleActionsResult;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.util.Collection;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class GetRuleActionsProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        RuleActionsParameters parameters = (RuleActionsParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        EntityContainer modelContractCtr = EntityStorage.get().resolve(parameters.getRuleGroup());
        RuleSettings ruleSettings = CabinetHelper.findRuleSettings((ModelContract)modelContractCtr.getEntity(), parameters.getRuleUid());
        Targets ruleTarget = ruleSettings != null ? ruleSettings.getTarget() : Targets.PRODUCT_COMMISSION;
        RulesEnvironment rulesEnvironment = (RulesEnvironment)Environment.getPublished(RulesEnvironment.class);
        RuleActionsResult result = new RuleActionsResult();
        Collection actions = rulesEnvironment.getActions((RuleTarget)ruleTarget).stream().filter(GetRuleActionsProcessor.filterRuleActions((RuleTarget)ruleTarget, rulesEnvironment)).collect(Collectors.toList());
        result.getActions().addAll(actions.stream().map(CabinetConverterHelper::convertRuleAction2Rest).collect(Collectors.toList()));
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)result);
    }

    private static Predicate<RuleAction> filterRuleActions(RuleTarget ruleTarget, RulesEnvironment rulesEnvironment) {
        return ruleAction -> {
            for (RuleFilteringCategory category : rulesEnvironment.getFilteringCategories()) {
                if (!GetRuleActionsProcessor.isValidCategory(category) || !rulesEnvironment.getActions(category).contains(ruleAction) || !rulesEnvironment.getTargets(category).contains(ruleTarget)) continue;
                return true;
            }
            return false;
        };
    }

    private static boolean isValidCategory(RuleFilteringCategory ruleFilteringCategory) {
        return ContractsFilteringCategories.contains((Object)ruleFilteringCategory) || SubsidizedContractFilteringCategories.AVIA_SUBSIDIZED_CONTRACT == ruleFilteringCategory;
    }
}

