/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.cabinet.getRuleGroups;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.profile.ContractIndex;
import com.gridnine.xtrip.common.model.profile.ModelContract;
import com.gridnine.xtrip.common.model.profile.ModelContractIndex;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.cabinet.CabinetConverterHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.cabinet.CabinetHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.RuleGroupListItem;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.RuleGroupsParameters;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.RuleGroupsResult;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class GetRuleGroupsProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        RuleGroupsParameters params = (RuleGroupsParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        CabinetHelper.checkRequestPaginationParameters(params.getPage(), params.getPageSize());
        RuleGroupsResult result = new RuleGroupsResult();
        if (StringUtils.isNotBlank((String)params.getContractUid())) {
            List<EntityContainer<ModelContract>> modelContractsCtrs = this.getContractRuleGroups(params.getContractUid());
            List groups = modelContractsCtrs.stream().map(mcCtr -> CabinetConverterHelper.convertModelContract2Rest((EntityContainer<ModelContract>)mcCtr, false)).sorted(Comparator.comparing(RuleGroupListItem::getName)).collect(Collectors.toList());
            if (StringUtils.isNotBlank((String)params.getPattern())) {
                groups = groups.stream().filter(rg -> StringUtils.containsIgnoreCase((String)rg.getName(), (String)params.getPattern())).collect(Collectors.toList());
            }
            int from = params.getPage() * params.getPageSize();
            int to = from + params.getPageSize();
            groups.subList(from, to);
            result.getRuleGroups().addAll(groups);
        } else {
            SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
            SearchQuery query = new SearchQuery();
            query.getCriteria().getCriterions().add(SearchCriterion.contains((String)ModelContractIndex.Property.agencies.name(), (Object)salesContext.getSubagency()));
            if (StringUtils.isNotBlank((String)params.getPattern())) {
                query.getCriteria().getCriterions().add(SearchCriterion.ilike((String)ModelContractIndex.Property.name.name(), (String)("%" + params.getPattern() + "%")));
            }
            List modelContractCtrs = CabinetHelper.queryPageData(query, ModelContractIndex.class, params.getPage(), params.getPageSize(), SortOrder.ASC, ModelContractIndex.Property.name.name()).stream().map(ModelContractIndex::getSource).map(ref -> EntityStorage.get().resolve(ref)).collect(Collectors.toList());
            result.getRuleGroups().addAll(modelContractCtrs.stream().map(mcCtr -> CabinetConverterHelper.convertModelContract2Rest((EntityContainer<ModelContract>)mcCtr, false)).collect(Collectors.toList()));
        }
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)result);
    }

    private List<EntityContainer<ModelContract>> getContractRuleGroups(String contractUid) {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)"containerUid", (Object)contractUid));
        query.getPreferredProperties().add(ContractIndex.Property.modelContracts.name());
        List data = EntityStorage.get().search(ContractIndex.class, query).getData();
        if (data.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        List modelContractsRefs = ((ContractIndex)data.get(0)).getModelContracts();
        if (modelContractsRefs.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        EntityStorage es = EntityStorage.get();
        return modelContractsRefs.stream().map(arg_0 -> ((EntityStorage)es).resolve(arg_0)).collect(Collectors.toList());
    }
}

