/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.cabinet.getRuleInfo;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.profile.ModelContract;
import com.gridnine.xtrip.common.rules.RuleSettings;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.cabinet.CabinetConverterHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.cabinet.CabinetHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.RuleInfoParameters;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.RuleInfoResult;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.util.stream.Collectors;

public class GetRuleInfoProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        RuleInfoParameters parameters = (RuleInfoParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        EntityContainer modelContractCtr = EntityStorage.get().resolve(parameters.getRuleGroup());
        RuleSettings ruleSettings = CabinetHelper.findRuleSettings((ModelContract)modelContractCtr.getEntity(), parameters.getRuleUid());
        RuleInfoResult result = new RuleInfoResult();
        result.setUid(parameters.getRuleUid());
        result.setRuleGroup(parameters.getRuleGroup());
        result.setName(ruleSettings.getName());
        result.getRestrictions().addAll(ruleSettings.getRestrictions().stream().map(CabinetConverterHelper::convertRuleRestriction2Rest).collect(Collectors.toList()));
        result.getResults().addAll(ruleSettings.getResults().stream().map(CabinetConverterHelper::convertRuleResult2Rest).collect(Collectors.toList()));
        result.setStartDate(CabinetConverterHelper.convertDate2Rest(ruleSettings.getPeriodBegin()));
        result.setEndDate(CabinetConverterHelper.convertDate2Rest(ruleSettings.getPeriodEnd()));
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)result);
    }
}

