/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.cabinet.getVisaInformation;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.gds.model.DocaInformation;
import com.gridnine.xtrip.common.gds.model.DocoInformation;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductIndex;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.parameters.EntityStorageSearchParameters;
import com.gridnine.xtrip.common.model.helpers.SearchQueryHelper;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.DocaReference;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.DocoReference;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.GetVisaInformationParameters;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.GetVisaInformationResult;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.VisaInformationReference;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.util.List;
import java.util.Locale;
import org.joda.time.LocalDate;

public class GetVisaInformationProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        List prodIndices;
        GetVisaInformationParameters request = (GetVisaInformationParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        if (TextUtil.isBlank((String)request.getPnr())) {
            throw Xeption.forDeveloper((String)"empty pnr", (Object[])new Object[0]);
        }
        Locale locale = LocaleHelper.getCurrentLocale();
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchQueryHelper.getRecordLocatorSearchCriterionForProductIndex((String)request.getPnr()));
        if (!TextUtil.isBlank((String)request.getTicketNumber())) {
            query.getCriteria().getCriterions().add(SearchCriterion.contains((String)ProductIndex.Property.ticketNumbers.name(), (Object)request.getTicketNumber()));
        }
        if ((prodIndices = EntityStorage.get().search(ProductIndex.class, query, (EntityStorageSearchParameters)new EntityStorageSearchParameters().noCache(true)).getData()).size() == 0) {
            throw Xeption.forDeveloper((String)("No ticket found for pnr " + request.getPnr()), (Object[])new Object[0]);
        }
        GetVisaInformationResult result = new GetVisaInformationResult();
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)result);
        DictionaryCache cache = (DictionaryCache)Environment.getPublished(DictionaryCache.class);
        for (ProductIndex prodInd : prodIndices) {
            EntityReference bfRef = prodInd.getSource();
            EntityContainer bfCont = EntityStorage.get().resolve(bfRef);
            if (bfCont == null) continue;
            for (Reservation res : ((BookingFile)bfCont.getEntity()).getReservations()) {
                for (BaseProduct bp : res.getProducts()) {
                    Country country;
                    if (!(bp instanceof Product)) continue;
                    Product prod = (Product)bp;
                    if (!TextUtil.isBlank((String)request.getTicketNumber()) && !TextUtil.isSame((String)request.getTicketNumber(), (String)prod.getSystemNumber()) || prod.getTraveller() == null) continue;
                    VisaInformationReference visaRef = new VisaInformationReference();
                    visaRef.setTicketNumber(prod.getSystemNumber());
                    visaRef.setTravelerName(prod.getTraveller().getNameInGds());
                    for (DocoInformation doco : prod.getTraveller().getDocoInformations()) {
                        Country placeOfBirth;
                        DocoReference docoRef = new DocoReference();
                        docoRef.setVisaNumber(doco.getVisaNumber());
                        if (doco.getPlaceOfBirthCountry() != null && (placeOfBirth = (Country)cache.resolveReference(doco.getPlaceOfBirthCountry())) != null) {
                            docoRef.setPlaceOfBirthCountry(placeOfBirth.getTranslations().containsKey(locale) ? (String)placeOfBirth.getTranslations().get(locale) : (String)placeOfBirth.getTranslations().values().iterator().next());
                        }
                        docoRef.setPlaceOfBirthCity(doco.getPlaceOfBirthCity());
                        docoRef.setPlaceOfBirthState(doco.getPlaceOfBirthState());
                        if (doco.getVisaApplicableCountry() != null && (country = (Country)cache.resolveReference(doco.getVisaApplicableCountry())) != null) {
                            docoRef.setVisaApplicableCountry(country.getTranslations().containsKey(locale) ? (String)country.getTranslations().get(locale) : (String)country.getTranslations().values().iterator().next());
                        }
                        docoRef.setVisaIssueDate(new LocalDate((Object)doco.getVisaIssueDate()));
                        docoRef.setVisaIssuePlace(doco.getVisaIssuePlace());
                        if (doco.getVisaRequirement() != null && doco.getVisaRequirement().getCountry() != null && (country = (Country)cache.resolveReference(doco.getVisaRequirement().getCountry())) != null) {
                            docoRef.setVisaRequirementCountry(country.getTranslations().containsKey(locale) ? (String)country.getTranslations().get(locale) : (String)country.getTranslations().values().iterator().next());
                        }
                        visaRef.getDocoList().add(docoRef);
                    }
                    for (DocaInformation doca : prod.getTraveller().getDocaInformations()) {
                        DocaReference docaRef = new DocaReference();
                        docaRef.setCity(doca.getCity());
                        if (doca.getCountry() != null && (country = (Country)cache.resolveReference(doca.getCountry())) != null) {
                            docaRef.setCountry(country.getTranslations().containsKey(locale) ? (String)country.getTranslations().get(locale) : (String)country.getTranslations().values().iterator().next());
                        }
                        if (doca.getType() != null) {
                            docaRef.setDocaAddressType(doca.getType().name());
                        }
                        docaRef.setStateProvince(doca.getStateProvince());
                        docaRef.setStreet(doca.getStreet());
                        docaRef.setZipPostalCode(doca.getZipPostalCode());
                        if (doca.getVisaRequirement() != null && doca.getVisaRequirement().getCountry() != null && (country = (Country)cache.resolveReference(doca.getVisaRequirement().getCountry())) != null) {
                            docaRef.setVisaRequirementCountry(country.getTranslations().containsKey(locale) ? (String)country.getTranslations().get(locale) : (String)country.getTranslations().values().iterator().next());
                        }
                        visaRef.getDocaList().add(docaRef);
                    }
                    result.getVisas().add(visaRef);
                }
            }
        }
    }
}

